/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.algebra.functions.aggregation;

import cz.cvut.fel.ida.algebra.functions.ActivationFcn;
import cz.cvut.fel.ida.algebra.functions.Aggregation;
import cz.cvut.fel.ida.algebra.functions.Combination;
import cz.cvut.fel.ida.algebra.functions.Transformation;
import cz.cvut.fel.ida.algebra.values.ScalarValue;
import cz.cvut.fel.ida.algebra.values.Value;
import java.util.List;
import java.util.logging.Logger;

public class Sum
implements Aggregation {
    private static final Logger LOG = Logger.getLogger(Sum.class.getName());

    @Override
    public Sum replaceWithSingleton() {
        return Aggregation.Singletons.sum;
    }

    @Override
    public Value evaluate(List<Value> inputs) {
        Value sum = inputs.get(0).clone();
        int len = inputs.size();
        for (int i = 1; i < len; ++i) {
            try {
                sum.incrementBy(inputs.get(i));
                continue;
            }
            catch (ArithmeticException e) {
                sum = sum.plus(inputs.get(i));
            }
        }
        return sum;
    }

    @Override
    public Value differentiate(List<Value> inputs) {
        return Value.ONE;
    }

    @Override
    public Value evaluate(Value combinedInputs) {
        double sum = 0.0;
        for (Double summedInput : combinedInputs) {
            sum += summedInput.doubleValue();
        }
        return new ScalarValue(sum);
    }

    @Override
    public Value differentiate(Value combinedInputs) {
        return Value.ONE;
    }

    @Override
    public boolean isPermutationInvariant() {
        return true;
    }

    @Override
    public ActivationFcn.State getState(boolean singleInput) {
        if (singleInput) {
            return new TransformationState(Aggregation.Singletons.sum);
        }
        return new AggregationState(Aggregation.Singletons.sum);
    }

    public static class TransformationState
    extends Transformation.State {
        public TransformationState(Transformation transformation) {
            super(transformation);
        }

        @Override
        public void ingestTopGradient(Value topGradient) {
            this.processedGradient = topGradient;
        }
    }

    public static class AggregationState
    extends Aggregation.State {
        public AggregationState(Combination combination) {
            super(combination);
        }

        @Override
        public void cumulate(Value value) {
            this.combinedInputs.incrementBy(value);
        }

        @Override
        public Value evaluate() {
            return this.combinedInputs;
        }

        @Override
        public void ingestTopGradient(Value topGradient) {
            this.processedGradient = topGradient;
        }

        @Override
        public void invalidate() {
            this.combinedInputs.zero();
        }

        @Override
        public Value nextInputGradient() {
            return this.processedGradient;
        }
    }
}

