/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.algebra.functions.error;

import cz.cvut.fel.ida.algebra.functions.ErrorFcn;
import cz.cvut.fel.ida.algebra.values.ScalarValue;
import cz.cvut.fel.ida.algebra.values.Value;
import java.util.Iterator;
import java.util.logging.Logger;

public class SquaredDiff
implements ErrorFcn {
    private static final Logger LOG = Logger.getLogger(SquaredDiff.class.getName());
    static Value oneHalf = new ScalarValue(0.5);
    static Value two = new ScalarValue(2.0);
    public static SquaredDiff singleton = new SquaredDiff();

    @Override
    public Value evaluate(Value output, Value target) {
        if (output.getClass() != target.getClass()) {
            LOG.severe("Prediction output and target label are of different algebraic types! (e.g. scalar vs vector)");
        }
        Value diff = output.minus(target);
        double accumulator = 0.0;
        int elements = 0;
        Iterator iterator = diff.iterator();
        while (iterator.hasNext()) {
            double value = (Double)iterator.next();
            accumulator += value * value;
            ++elements;
        }
        return new ScalarValue(accumulator / (double)elements);
    }

    @Override
    public Value differentiate(Value output, Value target) {
        return target.minus(output).times(two);
    }

    @Override
    public SquaredDiff getSingleton() {
        return singleton;
    }
}

