/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.algebra.functions.transformation.elementwise;

import cz.cvut.fel.ida.algebra.functions.ElementWise;
import cz.cvut.fel.ida.utils.generic.Pair;
import java.util.function.DoubleUnaryOperator;
import java.util.logging.Logger;

public class LeakyReLu
extends ElementWise {
    private static final Logger LOG = Logger.getLogger(LeakyReLu.class.getName());
    public static double alpha = 0.01;
    private static final DoubleUnaryOperator signum = in -> in > 0.0 ? in : alpha * in;
    private static final DoubleUnaryOperator zerograd = in -> in > 0.0 ? 1.0 : alpha;

    @Override
    public String getName() {
        return LeakyReLu.class.getSimpleName();
    }

    public LeakyReLu() {
        super(signum, zerograd);
    }

    @Override
    public LeakyReLu replaceWithSingleton() {
        return ElementWise.Singletons.leakyRelu;
    }

    @Override
    public Pair<Double, Double> getSaturationRange() {
        return new Pair<Double, Double>(-100.0, 1000.0);
    }
}

