/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.algebra.functions.transformation.elementwise;

import cz.cvut.fel.ida.algebra.functions.ElementWise;
import cz.cvut.fel.ida.utils.generic.Pair;
import java.util.function.DoubleUnaryOperator;
import java.util.logging.Logger;

public class LukasiewiczSigmoid
extends ElementWise {
    private static final Logger LOG = Logger.getLogger(LukasiewiczSigmoid.class.getName());
    static DoubleUnaryOperator logist = in -> in > 100.0 ? 1.0 : (in < -100.0 ? 0.0 : 1.0 / (1.0 + Math.exp(-6.0 * in - 0.5)));

    public LukasiewiczSigmoid() {
        super(logist, in -> in > 100.0 || in < -100.0 ? 0.0 : logist.applyAsDouble(in) * (1.0 - logist.applyAsDouble(in)));
    }

    @Override
    public LukasiewiczSigmoid replaceWithSingleton() {
        return ElementWise.Singletons.lukasiewiczSigmoid;
    }

    @Override
    public Pair<Double, Double> getSaturationRange() {
        return new Pair<Double, Double>(0.01, 0.99);
    }
}

