/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.algebra.functions.transformation.elementwise;

import cz.cvut.fel.ida.algebra.functions.ElementWise;
import cz.cvut.fel.ida.utils.generic.Pair;
import java.util.function.DoubleUnaryOperator;
import java.util.logging.Logger;

public class Sigmoid
extends ElementWise {
    private static final Logger LOG = Logger.getLogger(Sigmoid.class.getName());
    public static final DoubleUnaryOperator logist = in -> in > 100.0 ? 1.0 : (in < -100.0 ? 0.0 : 1.0 / (1.0 + Math.exp(-in)));
    private static final DoubleUnaryOperator diffLogist = in -> {
        if (in > 100.0 || in < -100.0) {
            return 0.0;
        }
        double sigm = 1.0 / (1.0 + Math.exp(-in));
        return sigm * (1.0 - sigm);
    };

    public Sigmoid() {
        super(logist, diffLogist);
    }

    @Override
    public Sigmoid replaceWithSingleton() {
        return ElementWise.Singletons.sigmoid;
    }

    @Override
    public Pair<Double, Double> getSaturationRange() {
        return new Pair<Double, Double>(0.01, 0.99);
    }
}

