/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.algebra.functions.transformation.elementwise;

import cz.cvut.fel.ida.algebra.functions.ElementWise;
import cz.cvut.fel.ida.utils.generic.Pair;
import java.util.function.DoubleUnaryOperator;
import java.util.logging.Logger;

public class Tanh
extends ElementWise {
    private static final Logger LOG = Logger.getLogger(Tanh.class.getName());
    private static final DoubleUnaryOperator tanh = Math::tanh;
    private static final DoubleUnaryOperator diffTanh = in -> {
        if (in > 100.0 || in < -100.0) {
            return 0.0;
        }
        double tanh1 = Math.tanh(in);
        return 1.0 - tanh1 * tanh1;
    };

    public Tanh() {
        super(tanh, diffTanh);
    }

    @Override
    public Tanh replaceWithSingleton() {
        return ElementWise.Singletons.tanh;
    }

    @Override
    public Pair<Double, Double> getSaturationRange() {
        return new Pair<Double, Double>(-0.99, 0.99);
    }
}

