/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.algebra.functions.transformation.joint;

import cz.cvut.fel.ida.algebra.functions.ActivationFcn;
import cz.cvut.fel.ida.algebra.functions.Transformation;
import cz.cvut.fel.ida.algebra.values.MatrixValue;
import cz.cvut.fel.ida.algebra.values.Value;
import cz.cvut.fel.ida.algebra.values.VectorValue;
import java.util.Arrays;
import java.util.logging.Logger;

public class Slice
implements Transformation {
    private static final Logger LOG = Logger.getLogger(Slice.class.getName());
    private final int[] cols;
    private final int[] rows;

    public Slice() {
        this.cols = null;
        this.rows = null;
    }

    public Slice(int[] rows, int[] cols) {
        if (cols != null && cols.length != 2) {
            String err = "Unsupported col slice: " + Arrays.toString(cols) + ". Expected exactly two elements.";
            LOG.severe(err);
            throw new ArithmeticException(err);
        }
        if (rows != null && rows.length != 2) {
            String err = "Unsupported row slice: " + Arrays.toString(rows) + ". Expected exactly two elements.";
            LOG.severe(err);
            throw new ArithmeticException(err);
        }
        this.cols = cols;
        this.rows = rows;
    }

    @Override
    public ActivationFcn replaceWithSingleton() {
        return null;
    }

    @Override
    public Value evaluate(Value combinedInputs) {
        return combinedInputs.slice(this.rows, this.cols);
    }

    @Override
    public Value differentiate(Value combinedInputs) {
        return null;
    }

    @Override
    public ActivationFcn.State getState(boolean singleInput) {
        return new State(this);
    }

    @Override
    public boolean changesShape() {
        return true;
    }

    public static class State
    extends Transformation.State {
        private final Slice slice;

        public State(Slice transformation) {
            super(transformation);
            this.slice = transformation;
        }

        @Override
        public void invalidate() {
            super.invalidate();
        }

        @Override
        public Value evaluate() {
            return this.slice.evaluate(this.input);
        }

        @Override
        public void ingestTopGradient(Value topGradient) {
            int[] size = topGradient.size();
            if (size.length == 0) {
                this.processedGradient = topGradient;
                return;
            }
            int rowsTo = this.slice.rows == null ? size[0] : this.slice.rows[1];
            int rowsFrom = this.slice.rows == null ? 0 : this.slice.rows[0];
            int colsTo = this.slice.cols == null ? size[1] : this.slice.cols[1];
            int colsFrom = this.slice.cols == null ? 0 : this.slice.cols[0];
            double[] values = topGradient.getAsArray();
            double[] inputValues = this.input.getAsArray();
            double[] outputValues = new double[inputValues.length];
            if (topGradient instanceof VectorValue) {
                boolean orientation = ((VectorValue)topGradient).rowOrientation;
                if (orientation) {
                    System.arraycopy(values, 0, outputValues, colsFrom, values.length);
                } else {
                    System.arraycopy(values, 0, outputValues, rowsFrom, values.length);
                }
                this.processedGradient = new VectorValue(outputValues, orientation);
                return;
            }
            int rows = ((MatrixValue)this.input).rows;
            int cols = ((MatrixValue)this.input).cols;
            int colNum = colsTo - colsFrom;
            for (int i = rowsFrom; i < rowsTo; ++i) {
                System.arraycopy(values, (i - rowsFrom) * colNum, outputValues, i * cols + colsFrom, colNum);
            }
            this.processedGradient = new MatrixValue(outputValues, rows, cols);
        }
    }
}

