/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.algebra.utils.metadata;

import cz.cvut.fel.ida.algebra.values.MatrixValue;
import cz.cvut.fel.ida.algebra.values.ScalarValue;
import cz.cvut.fel.ida.algebra.values.StringValue;
import cz.cvut.fel.ida.algebra.values.Value;
import cz.cvut.fel.ida.algebra.values.VectorValue;
import cz.cvut.fel.ida.algebra.weights.Weight;
import cz.cvut.fel.ida.utils.exporting.Exportable;
import java.util.logging.Logger;

public class ParameterValue
implements Exportable {
    private static final Logger LOG = Logger.getLogger(ParameterValue.class.getName());
    public Type type;
    public String stringValue;
    public Object value;

    public ParameterValue(Object value) {
        this.value = value;
        this.stringValue = value.toString();
        if (value instanceof Weight) {
            this.type = Type.WEIGHT;
        } else if (value instanceof StringValue) {
            if (this.stringValue.equals("true")) {
                this.type = Type.BOOLEAN;
                this.value = true;
            } else if (this.stringValue.equals("false")) {
                this.type = Type.BOOLEAN;
                this.value = false;
            } else {
                this.type = Type.STRING;
            }
        } else if (value instanceof Value) {
            this.type = Type.VALUE;
            if (!(value instanceof ScalarValue) && !(value instanceof VectorValue) && value instanceof MatrixValue) {
                // empty if block
            }
        } else {
            LOG.warning("Metadata value not recognized!");
        }
    }

    public ParameterValue(Weight weight) {
        this.stringValue = weight.name;
        this.value = weight;
        this.type = Type.WEIGHT;
    }

    public ParameterValue(Value iValue) {
        this.stringValue = this.value.toString();
        this.value = iValue;
        this.type = Type.VALUE;
    }

    public ParameterValue(int iValue) {
        this.stringValue = String.valueOf(this.value);
        this.value = iValue;
        this.type = Type.INT;
    }

    public ParameterValue(double iValue) {
        this.stringValue = String.valueOf(this.value);
        this.value = iValue;
        this.type = Type.DOUBLE;
    }

    public ParameterValue(boolean iValue) {
        this.stringValue = String.valueOf(this.value);
        this.value = iValue;
        this.type = Type.BOOLEAN;
    }

    public ParameterValue(String iValue) {
        this.stringValue = String.valueOf(this.value);
        this.value = iValue;
        this.type = Type.STRING;
    }

    public static enum Type {
        CONSTANT,
        WEIGHT,
        VALUE,
        INT,
        DOUBLE,
        BOOLEAN,
        STRING;

    }
}

