/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.algebra.values;

import cz.cvut.fel.ida.algebra.values.ScalarValue;
import cz.cvut.fel.ida.algebra.values.TensorValue;
import cz.cvut.fel.ida.algebra.values.Value;
import cz.cvut.fel.ida.algebra.values.VectorValue;
import cz.cvut.fel.ida.algebra.values.inits.ValueInitializer;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.DoubleUnaryOperator;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class MatrixValue
extends Value {
    private static final Logger LOG = Logger.getLogger(MatrixValue.class.getName());
    public int rows;
    public int cols;
    public double[] values;

    public MatrixValue(int rows, int cols) {
        this.rows = rows;
        this.cols = cols;
        this.values = new double[rows * cols];
    }

    public MatrixValue(double[] values, int rows, int cols) {
        this.rows = rows;
        this.cols = cols;
        this.values = values;
    }

    public MatrixValue(List<List<Double>> vectors) {
        this.rows = vectors.size();
        this.cols = vectors.get(0).size();
        this.values = new double[this.rows * this.cols];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                this.values[i * this.cols + j] = vectors.get(i).get(j);
            }
        }
    }

    @Override
    @NotNull
    public Iterator<Double> iterator() {
        return new ValueIterator();
    }

    @Override
    public void initialize(ValueInitializer valueInitializer) {
        valueInitializer.initMatrix(this);
    }

    @Override
    public MatrixValue zero() {
        Arrays.fill(this.values, 0.0);
        return this;
    }

    @Override
    public MatrixValue clone() {
        return new MatrixValue((double[])this.values.clone(), this.rows, this.cols);
    }

    @Override
    public MatrixValue getForm() {
        return new MatrixValue(this.rows, this.cols);
    }

    @Override
    public void transpose() {
        double[] trValues = new double[this.values.length];
        for (int i = 0; i < this.rows; ++i) {
            int tmpIndex = i * this.cols;
            for (int j = 0; j < this.cols; ++j) {
                trValues[j * this.rows + i] = this.values[tmpIndex + j];
            }
        }
        this.values = trValues;
        int tmp = this.rows;
        this.rows = this.cols;
        this.cols = tmp;
    }

    @Override
    public Value transposedView() {
        MatrixValue value = new MatrixValue(this.values, this.rows, this.cols);
        value.transpose();
        return value;
    }

    @Override
    public int[] size() {
        return new int[]{this.rows, this.cols};
    }

    @Override
    public Value slice(int[] rows, int[] cols) {
        int colsFrom;
        int rowsTo = rows == null ? this.rows : rows[1];
        int rowsFrom = rows == null ? 0 : rows[0];
        int colsTo = cols == null ? this.cols : cols[1];
        int n = colsFrom = cols == null ? 0 : cols[0];
        if (rowsFrom < 0 || rowsTo > this.rows || rowsFrom >= rowsTo) {
            String err = "Cannot slice MatrixValue with size " + Arrays.toString(this.size()) + " with row slice " + Arrays.toString(rows);
            LOG.severe(err);
            throw new ArithmeticException(err);
        }
        if (colsFrom < 0 || colsTo > this.cols || colsFrom >= colsTo) {
            String err = "Cannot slice MatrixValue with size " + Arrays.toString(this.size()) + " with col slice " + Arrays.toString(cols);
            LOG.severe(err);
            throw new ArithmeticException(err);
        }
        int colNum = colsTo - colsFrom;
        int rowNum = rowsTo - rowsFrom;
        double[] resValues = new double[rowNum * colNum];
        for (int i = rowsFrom; i < rowsTo; ++i) {
            System.arraycopy(this.values, i * this.cols + colsFrom, resValues, (i - rowsFrom) * colNum, colNum);
        }
        return new MatrixValue(resValues, rowNum, colNum);
    }

    @Override
    public Value reshape(int[] shape) {
        double[] data = this.values;
        if (this.values.length == 1 && shape.length == 1 && shape[0] == 0) {
            return new ScalarValue(this.values[0]);
        }
        if (shape.length == 1 && shape[0] == data.length) {
            return new VectorValue(data);
        }
        if (shape.length == 2) {
            if (shape[0] == 1 && shape[1] == data.length) {
                return new MatrixValue(data, 1, data.length);
            }
            if (shape[0] == data.length && shape[1] == 1) {
                return new MatrixValue(data, data.length, 1);
            }
            if (shape[0] == 0 && shape[1] == 0 && data.length == 1) {
                return new ScalarValue(data[0]);
            }
            if (shape[0] == 0 && shape[1] == data.length) {
                return new VectorValue(data);
            }
            if (shape[0] == data.length && shape[1] == 0) {
                return new VectorValue(data, true);
            }
            if (data.length / shape[1] == shape[0]) {
                return new MatrixValue(data, shape[0], shape[1]);
            }
        }
        String err = "Cannot reshape MatrixValue of shape " + Arrays.toString(this.size()) + " to shape " + Arrays.toString(shape);
        LOG.severe(err);
        throw new ArithmeticException(err);
    }

    @Override
    public double[] getAsArray() {
        return this.values;
    }

    @Override
    public void setAsArray(double[] value) {
        this.values = value;
    }

    @Override
    public Value apply(DoubleUnaryOperator function) {
        MatrixValue result = new MatrixValue(this.rows, this.cols);
        double[] tmpValues = result.values;
        for (int i = 0; i < tmpValues.length; ++i) {
            tmpValues[i] = function.applyAsDouble(this.values[i]);
        }
        return result;
    }

    @Override
    public void applyInplace(DoubleUnaryOperator function) {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = function.applyAsDouble(this.values[i]);
        }
    }

    @Override
    public double get(int i) {
        return this.values[i];
    }

    @Override
    public void set(int i, double value) {
        this.values[i] = value;
    }

    @Override
    public void increment(int i, double value) {
        int n = i;
        this.values[n] = this.values[n] + value;
    }

    @Override
    public boolean isNaN() {
        for (double value : this.values) {
            if (!Double.isNaN(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString(NumberFormat numberFormat) {
        if (numberFormat == null) {
            return "dim:" + Arrays.toString(this.size());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[\n");
        for (int j = 0; j < this.rows; ++j) {
            sb.append("[");
            for (int i = 0; i < this.cols; ++i) {
                sb.append(numberFormat.format(this.values[j * this.cols + i])).append(",");
            }
            sb.replace(sb.length() - 1, sb.length(), "],\n");
        }
        sb.replace(sb.length() - 2, sb.length(), "\n]");
        return sb.toString();
    }

    @Override
    public Value times(Value value) {
        return value.times(this);
    }

    @Override
    protected MatrixValue times(ScalarValue value) {
        MatrixValue clone = this.clone();
        double value1 = value.value;
        double[] values = clone.values;
        int i = 0;
        while (i < values.length) {
            int n = i++;
            values[n] = values[n] * value1;
        }
        return clone;
    }

    @Override
    protected VectorValue times(VectorValue value) {
        if (this.rows != value.values.length) {
            String err = "Matrix row length mismatch with vector length for multiplication: " + this.rows + " vs." + value.values.length;
            LOG.severe(err);
            throw new ArithmeticException(err);
        }
        if (!value.rowOrientation) {
            throw new ArithmeticException("Column vector times matrix, try transposition. Vector size = " + value.values.length);
        }
        VectorValue result = new VectorValue(this.cols, true);
        double[] resultValues = result.values;
        double[] origValues = value.values;
        for (int j = 0; j < this.rows; ++j) {
            int tmpIndex = j * this.cols;
            double originalValue = origValues[j];
            for (int i = 0; i < this.cols; ++i) {
                int n = i;
                resultValues[n] = resultValues[n] + originalValue * this.values[tmpIndex + i];
            }
        }
        return result;
    }

    @Override
    protected MatrixValue times(MatrixValue value) {
        if (value.cols != this.rows) {
            String err = "Matrix to matrix dimension mismatch for multiplication " + value.cols + " != " + this.rows;
            LOG.severe(err);
            throw new ArithmeticException(err);
        }
        MatrixValue result = new MatrixValue(value.rows, this.cols);
        double[] lhs = value.values;
        double[] resultValues = result.values;
        for (int i = 0; i < value.rows; ++i) {
            int tmpIndex = i * this.cols;
            int tmpIndexLhs = i * value.cols;
            for (int j = 0; j < this.cols; ++j) {
                double acc = resultValues[tmpIndex + j];
                for (int k = 0; k < value.cols; ++k) {
                    acc += lhs[tmpIndexLhs + k] * this.values[k * this.cols + j];
                }
                resultValues[tmpIndex + j] = acc;
            }
        }
        return result;
    }

    @Override
    protected Value times(TensorValue value) {
        throw new ArithmeticException("Algebbraic operation between Tensor and Matrix are not implemented yet");
    }

    @Override
    public Value elementTimes(Value value) {
        return value.elementTimes(this);
    }

    @Override
    protected Value elementTimes(ScalarValue value) {
        MatrixValue clone = this.clone();
        double value1 = value.value;
        double[] values = clone.values;
        int i = 0;
        while (i < values.length) {
            int n = i++;
            values[n] = values[n] * value1;
        }
        return clone;
    }

    @Override
    protected Value elementTimes(VectorValue value) {
        LOG.warning("Calculation vector element-wise product with matrix...");
        if (this.rows != value.values.length) {
            String err = "Matrix row length mismatch with vector length for multiplication" + this.rows + " vs." + value.values.length;
            LOG.severe(err);
            throw new ArithmeticException(err);
        }
        MatrixValue result = new MatrixValue(this.rows, this.cols);
        double[] resultValues = result.values;
        for (int i = 0; i < this.rows; ++i) {
            int tmpIndex = i * this.cols;
            for (int j = 0; j < this.cols; ++j) {
                resultValues[tmpIndex + j] = this.values[tmpIndex + j] * value.values[j];
            }
        }
        return result;
    }

    @Override
    protected Value elementTimes(MatrixValue value) {
        if (value.cols != this.cols || value.rows != this.rows) {
            String err = "Matrix elementTimes dimension mismatch: " + Arrays.toString(this.size()) + " vs." + Arrays.toString(value.size());
            LOG.severe(err);
            throw new ArithmeticException(err);
        }
        MatrixValue result = value.clone();
        double[] lhs = result.values;
        for (int i = 0; i < lhs.length; ++i) {
            int n = i;
            lhs[n] = lhs[n] * this.values[i];
        }
        return result;
    }

    @Override
    protected Value elementTimes(TensorValue value) {
        throw new ArithmeticException("Algebraic operation between Tensor and Matrix are not implemented yet");
    }

    @Override
    public Value transposedTimes(Value value) {
        return value.transposedTimes(this);
    }

    @Override
    protected Value transposedTimes(ScalarValue value) {
        MatrixValue clone = this.clone();
        double value1 = value.value;
        double[] values = clone.values;
        int i = 0;
        while (i < values.length) {
            int n = i++;
            values[n] = values[n] * value1;
        }
        return clone;
    }

    @Override
    protected Value transposedTimes(VectorValue value) {
        if (this.rows != value.values.length) {
            String err = "Matrix row length mismatch with vector length for multiplication: " + this.rows + " vs." + value.values.length;
            LOG.severe(err);
            throw new ArithmeticException(err);
        }
        if (value.rowOrientation) {
            throw new ArithmeticException("Row vector transposedTimes matrix, try transposition. Vector size = " + value.values.length);
        }
        VectorValue result = new VectorValue(this.cols, true);
        double[] resultValues = result.values;
        double[] origValues = value.values;
        for (int j = 0; j < this.rows; ++j) {
            int tmpIndex = j * this.cols;
            double originalValue = origValues[j];
            for (int i = 0; i < this.cols; ++i) {
                int n = i;
                resultValues[n] = resultValues[n] + originalValue * this.values[tmpIndex + i];
            }
        }
        return result;
    }

    @Override
    protected Value transposedTimes(MatrixValue value) {
        if (value.rows != this.rows) {
            String err = "Matrix to matrix dimension mismatch for transposed multiplication" + value.rows + " != " + this.rows;
            LOG.severe(err);
            throw new ArithmeticException(err);
        }
        MatrixValue result = new MatrixValue(value.cols, this.cols);
        double[] lhs = value.values;
        double[] resultValues = result.values;
        for (int i = 0; i < value.cols; ++i) {
            int tmpIndex = i * this.cols;
            for (int k = 0; k < value.rows; ++k) {
                int valuesTmpIndex = k * this.cols;
                double lhsValue = lhs[k * value.cols + i];
                for (int j = 0; j < this.cols; ++j) {
                    int n = tmpIndex + j;
                    resultValues[n] = resultValues[n] + lhsValue * this.values[valuesTmpIndex + j];
                }
            }
        }
        return result;
    }

    @Override
    protected Value transposedTimes(TensorValue value) {
        throw new ArithmeticException("Algebraic operation between Tensor and Matrix are not implemented yet");
    }

    @Override
    public Value kroneckerTimes(Value value) {
        return value.kroneckerTimes(this);
    }

    @Override
    protected Value kroneckerTimes(ScalarValue value) {
        MatrixValue clone = this.clone();
        double[] values = clone.values;
        int i = 0;
        while (i < values.length) {
            int n = i++;
            values[n] = values[n] * value.value;
        }
        return clone;
    }

    @Override
    protected Value kroneckerTimes(VectorValue vectorValue) {
        int rows = vectorValue.rows() * this.rows;
        int cols = vectorValue.cols() * this.cols;
        MatrixValue result = new MatrixValue(rows, cols);
        double[] resultValues = result.values;
        double[] otherValues = vectorValue.values;
        if (vectorValue.rowOrientation) {
            for (int c1 = 0; c1 < otherValues.length; ++c1) {
                for (int r2 = 0; r2 < this.rows; ++r2) {
                    for (int c2 = 0; c2 < this.cols; ++c2) {
                        resultValues[r2 * cols + c1 * this.cols + c2] = otherValues[c1] * this.values[r2 * this.cols + c2];
                    }
                }
            }
        } else {
            for (int r1 = 0; r1 < otherValues.length; ++r1) {
                for (int r2 = 0; r2 < this.rows; ++r2) {
                    for (int c2 = 0; c2 < this.cols; ++c2) {
                        resultValues[(r1 * this.rows + r2) * cols + c2] = otherValues[r1] * this.values[r2 * this.cols + c2];
                    }
                }
            }
        }
        return result;
    }

    @Override
    protected Value kroneckerTimes(MatrixValue otherValue) {
        int rows = this.rows * otherValue.rows;
        int cols = this.cols * otherValue.cols;
        MatrixValue result = new MatrixValue(rows, cols);
        double[] resultValues = result.values;
        double[] otherValues = otherValue.values;
        for (int r1 = 0; r1 < otherValue.rows; ++r1) {
            for (int c1 = 0; c1 < otherValue.cols; ++c1) {
                int otherTmpIndex = r1 * otherValue.cols + c1;
                for (int r2 = 0; r2 < this.rows; ++r2) {
                    int tmpIndex = (r1 * this.rows + r2) * cols + c1 * this.cols;
                    for (int c2 = 0; c2 < this.cols; ++c2) {
                        resultValues[tmpIndex + c2] = otherValues[otherTmpIndex] * this.values[r2 * this.cols + c2];
                    }
                }
            }
        }
        return result;
    }

    @Override
    protected Value kroneckerTimes(TensorValue value) {
        throw new ArithmeticException("Algebraic operation between Tensor and Matrix are not implemented yet");
    }

    @Override
    public Value elementDivideBy(Value value) {
        return value.elementDivideBy(this);
    }

    @Override
    protected Value elementDivideBy(ScalarValue value) {
        MatrixValue clone = this.clone();
        double value1 = value.value;
        double[] values = clone.values;
        for (int i = 0; i < values.length; ++i) {
            values[i] = MatrixValue.safeDivide(values[i], value1);
        }
        return clone;
    }

    @Override
    protected Value elementDivideBy(VectorValue value) {
        LOG.warning("Calculation vector element-wise division with matrix...");
        if (this.rows != value.values.length) {
            String err = "Matrix row length mismatch with vector length for multiplication" + this.rows + " vs." + value.values.length;
            LOG.severe(err);
            throw new ArithmeticException(err);
        }
        MatrixValue result = new MatrixValue(this.rows, this.cols);
        double[] resultValues = result.values;
        for (int i = 0; i < resultValues.length; ++i) {
            resultValues[i] = MatrixValue.safeDivide(value.values[i % this.cols], this.values[i]);
        }
        return result;
    }

    @Override
    protected Value elementDivideBy(MatrixValue value) {
        if (value.cols != this.cols || value.rows != this.rows) {
            String err = "Matrix elementTimes dimension mismatch: " + Arrays.toString(this.size()) + " vs." + Arrays.toString(value.size());
            LOG.severe(err);
            throw new ArithmeticException(err);
        }
        MatrixValue result = value.clone();
        double[] lhs = result.values;
        for (int i = 0; i < lhs.length; ++i) {
            lhs[i] = MatrixValue.safeDivide(lhs[i], this.values[i]);
        }
        return result;
    }

    @Override
    protected Value elementDivideBy(TensorValue value) {
        throw new ArithmeticException("Algebbraic operation between Tensor and Matrix are not implemented yet");
    }

    @Override
    public Value plus(Value value) {
        return value.plus(this);
    }

    @Override
    protected MatrixValue plus(ScalarValue value) {
        MatrixValue clone = this.clone();
        double value1 = value.value;
        double[] values = clone.values;
        int i = 0;
        while (i < values.length) {
            int n = i++;
            values[n] = values[n] + value1;
        }
        return clone;
    }

    @Override
    protected Value plus(VectorValue value) {
        throw new ArithmeticException("Incompatible summation of matrix plus vector ");
    }

    @Override
    protected Value plus(MatrixValue value) {
        if (this.rows != value.rows || this.cols != value.cols) {
            String err = "Matrix plus dimension mismatch: " + Arrays.toString(this.size()) + " vs." + Arrays.toString(value.size());
            LOG.severe(err);
            throw new ArithmeticException(err);
        }
        MatrixValue result = new MatrixValue(this.rows, this.cols);
        double[] resultValues = result.values;
        double[] otherValues = value.values;
        for (int i = 0; i < resultValues.length; ++i) {
            resultValues[i] = otherValues[i] + this.values[i];
        }
        return result;
    }

    @Override
    protected Value plus(TensorValue value) {
        throw new ArithmeticException("Algebbraic operation between Tensor and Matrix are not implemented yet");
    }

    @Override
    public Value minus(Value value) {
        return value.minus(this);
    }

    @Override
    protected Value minus(ScalarValue value) {
        MatrixValue result = new MatrixValue(this.rows, this.cols);
        double[] resultValues = result.values;
        double value1 = value.value;
        for (int i = 0; i < resultValues.length; ++i) {
            resultValues[i] = value1 - this.values[i];
        }
        return result;
    }

    @Override
    protected Value minus(VectorValue value) {
        LOG.severe("Incompatible dimensions of algebraic operation - vector minus matrix");
        return null;
    }

    @Override
    protected Value minus(MatrixValue value) {
        if (this.rows != value.rows || this.cols != value.cols) {
            String err = "Matrix minus dimension mismatch: " + Arrays.toString(this.size()) + " vs." + Arrays.toString(value.size());
            LOG.severe(err);
            throw new ArithmeticException(err);
        }
        MatrixValue result = new MatrixValue(this.rows, this.cols);
        double[] resultValues = result.values;
        double[] otherValues = value.values;
        for (int i = 0; i < resultValues.length; ++i) {
            resultValues[i] = otherValues[i] - this.values[i];
        }
        return result;
    }

    @Override
    protected Value minus(TensorValue value) {
        throw new ArithmeticException("Algebbraic operation between Tensor and Matrix are not implemented yet");
    }

    @Override
    public void incrementBy(Value value) {
        value.incrementBy(this);
    }

    @Override
    protected void incrementBy(ScalarValue value) {
        if (this.rows == 1 && this.cols == 1) {
            value.value += this.values[0];
        } else {
            String err = "Incompatible dimensions of algebraic operation - scalar incrementBy by matrix";
            LOG.severe(err);
            throw new ArithmeticException(err);
        }
    }

    @Override
    protected void incrementBy(VectorValue value) {
        String err = "Incompatible dimensions of algebraic operation - vector incrementBy by matrix";
        LOG.severe(err);
        throw new ArithmeticException(err);
    }

    @Override
    protected void incrementBy(MatrixValue value) {
        if (this.rows != value.rows || this.cols != value.cols) {
            String err = "Matrix incrementBy dimension mismatch: " + Arrays.toString(this.size()) + " vs." + Arrays.toString(value.size());
            LOG.severe(err);
            throw new ArithmeticException(err);
        }
        double[] otherValues = value.values;
        for (int i = 0; i < otherValues.length; ++i) {
            int n = i;
            otherValues[n] = otherValues[n] + this.values[i];
        }
    }

    @Override
    protected void incrementBy(TensorValue value) {
        throw new ArithmeticException("Algebbraic operation between Tensor and Matrix are not implemented yet");
    }

    @Override
    public void elementMultiplyBy(Value value) {
        value.elementMultiplyBy(this);
    }

    @Override
    protected void elementMultiplyBy(ScalarValue value) {
        String err = "Incompatible dimensions of algebraic operation - scalar multiplyBy by matrix";
        LOG.severe(err);
        throw new ArithmeticException(err);
    }

    @Override
    protected void elementMultiplyBy(VectorValue value) {
        String err = "Incompatible dimensions of algebraic operation - vector multiplyBy by matrix";
        LOG.severe(err);
        throw new ArithmeticException(err);
    }

    @Override
    protected void elementMultiplyBy(MatrixValue value) {
        if (this.rows != value.rows || this.cols != value.cols) {
            String err = "Matrix multiplyBy dimension mismatch: " + Arrays.toString(this.size()) + " vs." + Arrays.toString(value.size());
            LOG.severe(err);
            throw new ArithmeticException(err);
        }
        double[] otherValues = value.values;
        for (int i = 0; i < otherValues.length; ++i) {
            int n = i;
            otherValues[n] = otherValues[n] * this.values[i];
        }
    }

    @Override
    protected void elementMultiplyBy(TensorValue value) {
        throw new ArithmeticException("Algebbraic operation between Tensor and Matrix are not implemented yet");
    }

    @Override
    public boolean greaterThan(Value maxValue) {
        return maxValue.greaterThan(this);
    }

    @Override
    protected boolean greaterThan(ScalarValue maxValue) {
        double sum = 0.0;
        for (int i = 0; i < this.values.length; ++i) {
            sum += this.values[i];
        }
        return maxValue.value > sum;
    }

    @Override
    protected boolean greaterThan(VectorValue maxValue) {
        LOG.severe("Incompatible dimensions of algebraic operation - vector greaterThan matrix");
        return false;
    }

    @Override
    protected boolean greaterThan(MatrixValue maxValue) {
        if (this.rows != maxValue.rows || this.cols != maxValue.cols) {
            String err = "Matrix greaterThan dimension mismatch: " + Arrays.toString(this.size()) + " vs." + Arrays.toString(maxValue.size());
            LOG.severe(err);
            throw new ArithmeticException(err);
        }
        double thisSum = 0.0;
        double otherSum = 0.0;
        for (int i = 0; i < this.values.length; ++i) {
            thisSum += this.values[i];
            otherSum += maxValue.values[i];
        }
        return otherSum > thisSum;
    }

    @Override
    protected boolean greaterThan(TensorValue maxValue) {
        throw new ArithmeticException("Algebbraic operation between Tensor and Matrix are not implemented yet");
    }

    @Override
    public int hashCode() {
        long hashCode = 1L;
        for (int i = 0; i < this.values.length; ++i) {
            hashCode = 31L * hashCode + (long)Double.valueOf(this.values[i]).hashCode();
        }
        return Long.hashCode(hashCode);
    }

    @Override
    public boolean equals(Value obj) {
        if (obj instanceof MatrixValue) {
            MatrixValue m = (MatrixValue)obj;
            if (m.cols != this.cols || m.rows != this.rows) {
                return false;
            }
            return Arrays.equals(this.values, m.values);
        }
        return false;
    }

    protected class ValueIterator
    implements Iterator<Double> {
        int index;
        final int maxIndex;

        protected ValueIterator() {
            this.maxIndex = MatrixValue.this.rows * MatrixValue.this.cols;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.maxIndex;
        }

        @Override
        public Double next() {
            return MatrixValue.this.values[this.index++];
        }
    }
}

