/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.algebra.values;

import cz.cvut.fel.ida.algebra.values.MatrixValue;
import cz.cvut.fel.ida.algebra.values.One;
import cz.cvut.fel.ida.algebra.values.ScalarValue;
import cz.cvut.fel.ida.algebra.values.TensorValue;
import cz.cvut.fel.ida.algebra.values.VectorValue;
import cz.cvut.fel.ida.algebra.values.Zero;
import cz.cvut.fel.ida.algebra.values.inits.ValueInitializer;
import cz.cvut.fel.ida.setup.Settings;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.function.DoubleUnaryOperator;
import java.util.logging.Logger;

public abstract class Value
implements Iterable<Double>,
Comparable<Value>,
Serializable {
    private static final Logger LOG = Logger.getLogger(Value.class.getName());
    public static double epsilon = 1.0E-30;
    public static final Value ZERO = new Zero();
    public static final Value ONE = new One();

    public abstract void initialize(ValueInitializer var1);

    public abstract Value zero();

    public abstract Value clone();

    public abstract Value getForm();

    public abstract void transpose();

    public abstract Value transposedView();

    public abstract int[] size();

    public abstract Value slice(int[] var1, int[] var2);

    public abstract Value reshape(int[] var1);

    public abstract double[] getAsArray();

    public abstract void setAsArray(double[] var1);

    public abstract Value apply(DoubleUnaryOperator var1);

    public abstract void applyInplace(DoubleUnaryOperator var1);

    public abstract double get(int var1);

    public abstract void set(int var1, double var2);

    public abstract void increment(int var1, double var2);

    public abstract boolean isNaN();

    public abstract String toString(NumberFormat var1);

    public String toString() {
        return this.toString(Settings.defaultNumberFormat);
    }

    public String toDetailedString() {
        return this.toString(Settings.superDetailedNumberFormat);
    }

    public abstract Value times(Value var1);

    protected abstract Value times(ScalarValue var1);

    protected abstract Value times(VectorValue var1);

    protected abstract Value times(MatrixValue var1);

    protected abstract Value times(TensorValue var1);

    public abstract Value elementTimes(Value var1);

    protected abstract Value elementTimes(ScalarValue var1);

    protected abstract Value elementTimes(VectorValue var1);

    protected abstract Value elementTimes(MatrixValue var1);

    protected abstract Value elementTimes(TensorValue var1);

    public abstract Value transposedTimes(Value var1);

    protected abstract Value transposedTimes(ScalarValue var1);

    protected abstract Value transposedTimes(VectorValue var1);

    protected abstract Value transposedTimes(MatrixValue var1);

    protected abstract Value transposedTimes(TensorValue var1);

    public abstract Value kroneckerTimes(Value var1);

    protected abstract Value kroneckerTimes(ScalarValue var1);

    protected abstract Value kroneckerTimes(VectorValue var1);

    protected abstract Value kroneckerTimes(MatrixValue var1);

    protected abstract Value kroneckerTimes(TensorValue var1);

    public abstract Value elementDivideBy(Value var1);

    protected abstract Value elementDivideBy(ScalarValue var1);

    protected abstract Value elementDivideBy(VectorValue var1);

    protected abstract Value elementDivideBy(MatrixValue var1);

    protected abstract Value elementDivideBy(TensorValue var1);

    public abstract Value plus(Value var1);

    protected abstract Value plus(ScalarValue var1);

    protected abstract Value plus(VectorValue var1);

    protected abstract Value plus(MatrixValue var1);

    protected abstract Value plus(TensorValue var1);

    public abstract Value minus(Value var1);

    protected abstract Value minus(ScalarValue var1);

    protected abstract Value minus(VectorValue var1);

    protected abstract Value minus(MatrixValue var1);

    protected abstract Value minus(TensorValue var1);

    public abstract void incrementBy(Value var1);

    protected abstract void incrementBy(ScalarValue var1);

    protected abstract void incrementBy(VectorValue var1);

    protected abstract void incrementBy(MatrixValue var1);

    protected abstract void incrementBy(TensorValue var1);

    public abstract void elementMultiplyBy(Value var1);

    protected abstract void elementMultiplyBy(ScalarValue var1);

    protected abstract void elementMultiplyBy(VectorValue var1);

    protected abstract void elementMultiplyBy(MatrixValue var1);

    protected abstract void elementMultiplyBy(TensorValue var1);

    public abstract boolean greaterThan(Value var1);

    protected abstract boolean greaterThan(ScalarValue var1);

    protected abstract boolean greaterThan(VectorValue var1);

    protected abstract boolean greaterThan(MatrixValue var1);

    protected abstract boolean greaterThan(TensorValue var1);

    public abstract int hashCode();

    public abstract boolean equals(Value var1);

    public static double safeDivide(double numerator, double denominator) {
        double result = numerator / denominator;
        if (result != result) {
            return 1.0;
        }
        if (Double.isInfinite(result)) {
            return Math.copySign(1000.0, result);
        }
        return result;
    }

    @Override
    public int compareTo(Value o) {
        if (this.greaterThan(o)) {
            return 1;
        }
        if (o.greaterThan(this)) {
            return -1;
        }
        return 0;
    }

    public int getMaxInd() {
        Iterator iterator = this.iterator();
        double max = Double.NEGATIVE_INFINITY;
        int maxInd = -1;
        int i = 0;
        while (iterator.hasNext()) {
            Double next = (Double)iterator.next();
            if (next > max) {
                maxInd = i;
                max = next;
            }
            ++i;
        }
        return maxInd;
    }
}

