/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.algebra.values;

import cz.cvut.fel.ida.algebra.values.MatrixValue;
import cz.cvut.fel.ida.algebra.values.ScalarValue;
import cz.cvut.fel.ida.algebra.values.TensorValue;
import cz.cvut.fel.ida.algebra.values.Value;
import cz.cvut.fel.ida.algebra.values.inits.ValueInitializer;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.DoubleUnaryOperator;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class VectorValue
extends Value {
    private static final Logger LOG = Logger.getLogger(VectorValue.class.getName());
    public double[] values;
    public boolean rowOrientation = false;

    public VectorValue(int size) {
        this.values = new double[size];
    }

    public VectorValue(List<Double> vector) {
        this.values = vector.stream().mapToDouble(d -> d).toArray();
    }

    public VectorValue(int size, ValueInitializer valueInitializer) {
        this.values = new double[size];
        this.initialize(valueInitializer);
    }

    public VectorValue(double[] values) {
        this.values = values;
    }

    public VectorValue(double[] values, boolean rowOrientation) {
        this.values = values;
        this.rowOrientation = rowOrientation;
    }

    public VectorValue(int size, boolean rowOrientation) {
        this.values = new double[size];
        this.rowOrientation = rowOrientation;
    }

    protected int rows() {
        if (this.rowOrientation) {
            return 1;
        }
        return this.values.length;
    }

    protected int cols() {
        if (!this.rowOrientation) {
            return 1;
        }
        return this.values.length;
    }

    @Override
    @NotNull
    public Iterator<Double> iterator() {
        return new ValueIterator();
    }

    @Override
    public void initialize(ValueInitializer valueInitializer) {
        valueInitializer.initVector(this);
    }

    @Override
    public VectorValue zero() {
        Arrays.fill(this.values, 0.0);
        return this;
    }

    @Override
    public VectorValue clone() {
        VectorValue clone = new VectorValue((double[])this.values.clone(), this.rowOrientation);
        return clone;
    }

    @Override
    public VectorValue getForm() {
        VectorValue form = new VectorValue(this.values.length);
        form.rowOrientation = this.rowOrientation;
        return form;
    }

    @Override
    public void transpose() {
        this.rowOrientation = !this.rowOrientation;
    }

    @Override
    public Value transposedView() {
        return new VectorValue(this.values, !this.rowOrientation);
    }

    @Override
    public int[] size() {
        if (this.rowOrientation) {
            return new int[]{1, this.values.length};
        }
        return new int[]{this.values.length, 1};
    }

    @Override
    public Value slice(int[] rows, int[] cols) {
        int[] sliceCoords;
        if (this.rowOrientation) {
            if (rows != null && rows[0] != 0 && rows[1] != 1) {
                String err = "Cannot slice VectorValue with size " + Arrays.toString(this.size()) + " with row slice " + Arrays.toString(rows);
                LOG.severe(err);
                throw new ArithmeticException(err);
            }
            sliceCoords = cols;
        } else {
            if (cols != null && cols[0] != 0 && cols[1] != 1) {
                String err = "Cannot slice VectorValue with size " + Arrays.toString(this.size()) + " with col slice " + Arrays.toString(cols);
                LOG.severe(err);
                throw new ArithmeticException(err);
            }
            sliceCoords = rows;
        }
        if (sliceCoords == null) {
            return new VectorValue(this.values, this.rowOrientation);
        }
        int from = sliceCoords[0];
        int to = sliceCoords[1];
        if (from < 0 || to > this.values.length || from >= to) {
            String err = "Cannot slice VectorValue with size " + Arrays.toString(this.size()) + " with slice " + Arrays.toString(sliceCoords);
            LOG.severe(err);
            throw new ArithmeticException(err);
        }
        double[] resValues = new double[to - from];
        System.arraycopy(this.values, from, resValues, 0, resValues.length);
        return new VectorValue(resValues, this.rowOrientation);
    }

    @Override
    public Value reshape(int[] shape) {
        double[] data = this.values;
        if (this.values.length == 1 && shape.length == 1 && shape[0] == 0) {
            return new ScalarValue(this.values[0]);
        }
        if (shape.length == 1 && shape[0] == data.length) {
            return new VectorValue(data);
        }
        if (shape.length == 2) {
            if (shape[0] == 1 && shape[1] == data.length) {
                return new MatrixValue(data, 1, data.length);
            }
            if (shape[0] == data.length && shape[1] == 1) {
                return new MatrixValue(data, data.length, 1);
            }
            if (shape[0] == 0 && shape[1] == 0 && data.length == 1) {
                return new ScalarValue(data[0]);
            }
            if (shape[0] == 0 && shape[1] == data.length) {
                return new VectorValue(data);
            }
            if (shape[0] == data.length && shape[1] == 0) {
                return new VectorValue(data, true);
            }
            if (data.length / shape[1] == shape[0]) {
                return new MatrixValue(data, shape[0], shape[1]);
            }
        }
        String err = "Cannot reshape VectorValue of shape " + Arrays.toString(this.size()) + " to shape " + Arrays.toString(shape);
        LOG.severe(err);
        throw new ArithmeticException(err);
    }

    @Override
    public double[] getAsArray() {
        return this.values;
    }

    @Override
    public void setAsArray(double[] value) {
        this.values = value;
    }

    @Override
    public Value apply(DoubleUnaryOperator function) {
        VectorValue result = new VectorValue(this.values.length, this.rowOrientation);
        double[] resultValues = result.values;
        for (int i = 0; i < this.values.length; ++i) {
            resultValues[i] = function.applyAsDouble(this.values[i]);
        }
        return result;
    }

    @Override
    public void applyInplace(DoubleUnaryOperator function) {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = function.applyAsDouble(this.values[i]);
        }
    }

    @Override
    public double get(int i) {
        return this.values[i];
    }

    @Override
    public void set(int i, double value) {
        this.values[i] = value;
    }

    @Override
    public void increment(int i, double value) {
        int n = i;
        this.values[n] = this.values[n] + value;
    }

    @Override
    public boolean isNaN() {
        for (double value : this.values) {
            if (!Double.isNaN(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString(NumberFormat numberFormat) {
        if (numberFormat == null) {
            return "dim:" + Arrays.toString(this.size());
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.values.length; ++i) {
            sb.append(",").append(numberFormat.format(this.values[i]));
        }
        sb.replace(0, 1, "[");
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Value times(Value value) {
        return value.times(this);
    }

    @Override
    protected VectorValue times(ScalarValue value) {
        VectorValue result = this.clone();
        double[] resultValues = result.values;
        double otherValue = value.value;
        int i = 0;
        while (i < resultValues.length) {
            int n = i++;
            resultValues[n] = resultValues[n] * otherValue;
        }
        return result;
    }

    @Override
    protected Value times(VectorValue value) {
        if (value.rowOrientation && !this.rowOrientation && value.values.length == this.values.length) {
            double resultValue = 0.0;
            double[] otherValues = value.values;
            for (int i = 0; i < this.values.length; ++i) {
                resultValue += this.values[i] * otherValues[i];
            }
            return new ScalarValue(resultValue);
        }
        if (!value.rowOrientation && this.rowOrientation) {
            LOG.finest(() -> "Performing vector x vector matrix multiplication.");
            MatrixValue result = new MatrixValue(value.values.length, this.values.length);
            double[] resultValues = result.values;
            double[] tempValues = value.values;
            int index = 0;
            for (double tmpValue : tempValues) {
                for (double v : this.values) {
                    resultValues[index++] = tmpValue * v;
                }
            }
            return result;
        }
        String err = "Incompatible dimensions for vector multiplication: " + Arrays.toString(value.size()) + " vs " + Arrays.toString(this.size()) + " (try transposition)";
        LOG.severe(err);
        throw new ArithmeticException(err);
    }

    @Override
    protected VectorValue times(MatrixValue value) {
        if (value.cols != this.values.length) {
            String err = "Matrix row length mismatch with vector length for multiplication: " + value.cols + " vs." + this.values.length;
            LOG.severe(err);
            throw new ArithmeticException(err);
        }
        if (value.cols > 1 && this.rowOrientation) {
            LOG.severe("Multiplying matrix with a row-oriented vector: " + Arrays.toString(value.size()) + " times " + Arrays.toString(this.size()));
            throw new ArithmeticException("Multiplying matrix with a row-oriented vector: " + Arrays.toString(value.size()) + " times " + Arrays.toString(this.size()));
        }
        VectorValue result = new VectorValue(value.rows);
        double[] resultValues = result.values;
        double[] matrixValues = value.values;
        for (int i = 0; i < value.rows; ++i) {
            int tmpIndex = i * value.cols;
            for (int j = 0; j < value.cols; ++j) {
                int n = i;
                resultValues[n] = resultValues[n] + matrixValues[tmpIndex + j] * this.values[j];
            }
        }
        return result;
    }

    @Override
    protected Value times(TensorValue value) {
        throw new ArithmeticException("Algebraic operation between Tensor and Vector are not implemented yet");
    }

    @Override
    public Value elementTimes(Value value) {
        return value.elementTimes(this);
    }

    @Override
    protected Value elementTimes(ScalarValue value) {
        VectorValue result = this.getForm();
        double[] resultValues = result.values;
        double otherValue = value.value;
        for (int i = 0; i < this.values.length; ++i) {
            resultValues[i] = this.values[i] * otherValue;
        }
        return result;
    }

    @Override
    protected Value elementTimes(VectorValue value) {
        if (value.values.length != this.values.length) {
            String err = "Vector elementTimes dimension mismatch: " + value.values.length + " vs." + this.values.length;
            LOG.severe(err);
            throw new ArithmeticException(err);
        }
        VectorValue result = value.getForm();
        double[] resultValues = result.values;
        double[] otherValues = value.values;
        for (int i = 0; i < this.values.length; ++i) {
            resultValues[i] = this.values[i] * otherValues[i];
        }
        return result;
    }

    @Override
    protected Value elementTimes(MatrixValue value) {
        LOG.warning("Calculating matrix element-wise product with vector...");
        if (value.cols != this.values.length) {
            String err = "Matrix elementTimes vector broadcast dimension mismatch: " + value.cols + " vs." + this.values.length;
            LOG.severe(err);
            throw new ArithmeticException(err);
        }
        MatrixValue result = new MatrixValue(value.rows, value.cols);
        double[] resultValues = result.values;
        double[] matrixValues = value.values;
        for (int i = 0; i < resultValues.length; ++i) {
            resultValues[i] = matrixValues[i] * this.values[i % value.cols];
        }
        return result;
    }

    @Override
    protected Value elementTimes(TensorValue value) {
        throw new ArithmeticException("Algebbraic operation between Tensor and Vector are not implemented yet");
    }

    @Override
    public Value transposedTimes(Value value) {
        return value.transposedTimes(this);
    }

    @Override
    protected Value transposedTimes(ScalarValue value) {
        VectorValue result = this.getForm();
        double[] resultValues = result.values;
        double otherValue = value.value;
        for (int i = 0; i < this.values.length; ++i) {
            resultValues[i] = this.values[i] * otherValue;
        }
        return result;
    }

    @Override
    protected Value transposedTimes(VectorValue value) {
        if (!value.rowOrientation && !this.rowOrientation && value.values.length == this.values.length) {
            double resultValue = 0.0;
            double[] otherValues = value.values;
            for (int i = 0; i < this.values.length; ++i) {
                resultValue += this.values[i] * otherValues[i];
            }
            return new ScalarValue(resultValue);
        }
        if (value.rowOrientation && this.rowOrientation) {
            LOG.finest(() -> "Performing vector x vector matrix multiplication.");
            MatrixValue result = new MatrixValue(value.values.length, this.values.length);
            double[] resultValues = result.values;
            for (int i = 0; i < value.values.length; ++i) {
                double tmpValue = value.values[i];
                int tmpIndex = i * this.values.length;
                for (int j = 0; j < this.values.length; ++j) {
                    resultValues[tmpIndex + j] = tmpValue * this.values[j];
                }
            }
            return result;
        }
        String err = "Incompatible dimensions for transposed vector multiplication: " + Arrays.toString(value.size()) + " vs " + Arrays.toString(this.size()) + " (try transposition)";
        LOG.severe(err);
        throw new ArithmeticException(err);
    }

    @Override
    protected Value transposedTimes(MatrixValue value) {
        if (value.rows != this.values.length) {
            String err = "Matrix row length mismatch with vector length for transposed multiplication: " + value.cols + " vs." + this.values.length;
            LOG.severe(err);
            throw new ArithmeticException(err);
        }
        if (value.rows > 1 && this.rowOrientation) {
            LOG.severe("Multiplying matrix with a row-oriented vector: " + Arrays.toString(value.size()) + " times " + Arrays.toString(this.size()));
            throw new ArithmeticException("Multiplying matrix with a row-oriented vector: " + Arrays.toString(value.size()) + " times " + Arrays.toString(this.size()));
        }
        VectorValue result = new VectorValue(value.cols);
        double[] resultValues = result.values;
        double[] matrixValues = value.values;
        for (int j = 0; j < value.rows; ++j) {
            int tmpIndex = j * value.cols;
            double tmpValue = this.values[j];
            for (int i = 0; i < value.cols; ++i) {
                int n = i;
                resultValues[n] = resultValues[n] + matrixValues[tmpIndex + i] * tmpValue;
            }
        }
        return result;
    }

    @Override
    protected Value transposedTimes(TensorValue value) {
        throw new ArithmeticException("Algebraic operation between Tensor and Vector are not implemented yet");
    }

    @Override
    public Value kroneckerTimes(Value value) {
        return value.kroneckerTimes(this);
    }

    @Override
    protected Value kroneckerTimes(ScalarValue value) {
        VectorValue result = this.getForm();
        double[] resultValues = result.values;
        double otherValue = value.value;
        for (int i = 0; i < this.values.length; ++i) {
            resultValues[i] = this.values[i] * otherValue;
        }
        return result;
    }

    @Override
    protected Value kroneckerTimes(VectorValue value) {
        int rows = this.rows() * value.rows();
        int cols = this.cols() * value.cols();
        if (rows == 1 || cols == 1) {
            VectorValue result = new VectorValue(rows * cols, rows == 1);
            double[] resultValues = result.values;
            double[] otherValues = value.values;
            for (int i = 0; i < otherValues.length; ++i) {
                for (int j = 0; j < this.values.length; ++j) {
                    resultValues[i * this.values.length + j] = otherValues[i] * this.values[j];
                }
            }
            return result;
        }
        MatrixValue result = new MatrixValue(rows, cols);
        double[] resultValues = result.values;
        double[] otherValues = value.values;
        if (this.rowOrientation) {
            for (int i = 0; i < otherValues.length; ++i) {
                int tmpIndex = i * this.values.length;
                for (int j = 0; j < this.values.length; ++j) {
                    resultValues[tmpIndex + j] = otherValues[i] * this.values[j];
                }
            }
        } else {
            for (int j = 0; j < this.values.length; ++j) {
                int tmpIndex = j * otherValues.length;
                for (int i = 0; i < otherValues.length; ++i) {
                    resultValues[tmpIndex + i] = otherValues[i] * this.values[j];
                }
            }
        }
        return result;
    }

    @Override
    protected Value kroneckerTimes(MatrixValue matrix) {
        int rows = this.rows() * matrix.rows;
        int cols = this.cols() * matrix.cols;
        MatrixValue result = new MatrixValue(rows, cols);
        double[] resultValues = result.values;
        double[] otherValues = matrix.values;
        if (this.rowOrientation) {
            for (int r1 = 0; r1 < matrix.rows; ++r1) {
                for (int c1 = 0; c1 < matrix.cols; ++c1) {
                    for (int k = 0; k < this.values.length; ++k) {
                        int tmpIndex = c1 * this.values.length + k;
                        resultValues[r1 * cols + tmpIndex] = otherValues[r1 * matrix.cols + c1] * this.values[k];
                    }
                }
            }
        } else {
            for (int r1 = 0; r1 < matrix.rows; ++r1) {
                for (int c1 = 0; c1 < matrix.cols; ++c1) {
                    for (int k = 0; k < this.values.length; ++k) {
                        int tmpIndex = r1 * this.values.length + k;
                        resultValues[tmpIndex * cols + c1] = otherValues[r1 * matrix.cols + c1] * this.values[k];
                    }
                }
            }
        }
        return result;
    }

    @Override
    protected Value kroneckerTimes(TensorValue value) {
        throw new ArithmeticException("Algebbraic operation between Tensor and Vector are not implemented yet");
    }

    @Override
    public Value elementDivideBy(Value value) {
        return value.elementDivideBy(this);
    }

    @Override
    protected Value elementDivideBy(ScalarValue value) {
        VectorValue result = this.getForm();
        double[] resultValues = result.values;
        double otherValue = value.value;
        for (int i = 0; i < this.values.length; ++i) {
            resultValues[i] = VectorValue.safeDivide(otherValue, this.values[i]);
        }
        return result;
    }

    @Override
    protected Value elementDivideBy(VectorValue value) {
        if (value.values.length != this.values.length) {
            String err = "Vector elementTimes dimension mismatch: " + value.values.length + " vs." + this.values.length;
            LOG.severe(err);
            throw new ArithmeticException(err);
        }
        VectorValue result = value.getForm();
        double[] resultValues = result.values;
        double[] otherValues = value.values;
        for (int i = 0; i < this.values.length; ++i) {
            resultValues[i] = VectorValue.safeDivide(otherValues[i], this.values[i]);
        }
        return result;
    }

    @Override
    protected Value elementDivideBy(MatrixValue value) {
        LOG.warning("Calculation matrix element-wise product with vector...");
        if (value.cols != this.values.length) {
            String err = "Matrix elementTimes vector broadcast dimension mismatch: " + value.cols + " vs." + this.values.length;
            LOG.severe(err);
            throw new ArithmeticException(err);
        }
        MatrixValue result = new MatrixValue(value.rows, value.cols);
        double[] resultValues = result.values;
        double[] matrixValues = value.values;
        for (int i = 0; i < value.rows; ++i) {
            int tmpIndex = i * value.cols;
            for (int j = 0; j < value.cols; ++j) {
                resultValues[tmpIndex + j] = VectorValue.safeDivide(matrixValues[tmpIndex + j], this.values[j]);
            }
        }
        return result;
    }

    @Override
    protected Value elementDivideBy(TensorValue value) {
        throw new ArithmeticException("Algebbraic operation between Tensor and Vector are not implemented yet");
    }

    @Override
    public Value plus(Value value) {
        return value.plus(this);
    }

    @Override
    protected VectorValue plus(ScalarValue value) {
        double other = value.value;
        VectorValue result = this.getForm();
        double[] resultValues = result.values;
        for (int i = 0; i < this.values.length; ++i) {
            resultValues[i] = this.values[i] + other;
        }
        return result;
    }

    @Override
    protected VectorValue plus(VectorValue value) {
        if (value.values.length != this.values.length) {
            String err = "Vector element plus dimension mismatch: " + value.values.length + " vs." + this.values.length;
            LOG.severe(err);
            throw new ArithmeticException(err);
        }
        VectorValue result = value.getForm();
        double[] resultValues = result.values;
        double[] otherValues = value.values;
        for (int i = 0; i < this.values.length; ++i) {
            resultValues[i] = this.values[i] + otherValues[i];
        }
        return result;
    }

    @Override
    protected Value plus(MatrixValue value) {
        throw new ArithmeticException("Incompatible summation of matrix plus vector ");
    }

    @Override
    protected Value plus(TensorValue value) {
        throw new ArithmeticException("Algebbraic operation between Tensor and Vector are not implemented yet");
    }

    @Override
    public Value minus(Value value) {
        return value.minus(this);
    }

    @Override
    protected Value minus(ScalarValue value) {
        double other = value.value;
        VectorValue result = this.getForm();
        double[] resultValues = result.values;
        for (int i = 0; i < this.values.length; ++i) {
            resultValues[i] = other - this.values[i];
        }
        return result;
    }

    @Override
    protected Value minus(VectorValue value) {
        if (value.values.length != this.values.length) {
            String err = "Vector minus dimension mismatch: " + value.values.length + " vs." + this.values.length;
            LOG.severe(err);
            throw new ArithmeticException(err);
        }
        VectorValue result = value.getForm();
        double[] resultValues = result.values;
        double[] otherValues = value.values;
        for (int i = 0; i < this.values.length; ++i) {
            resultValues[i] = otherValues[i] - this.values[i];
        }
        return result;
    }

    @Override
    protected Value minus(MatrixValue value) {
        throw new ArithmeticException("Incompatible dimensions of algebraic operation - matrix minus vector");
    }

    @Override
    protected Value minus(TensorValue value) {
        throw new ArithmeticException("Algebbraic operation between Tensor and Vector are not implemented yet");
    }

    @Override
    public void incrementBy(Value value) {
        value.incrementBy(this);
    }

    @Override
    protected void incrementBy(ScalarValue value) {
        if (this.values.length == 1) {
            value.value += this.values[0];
        } else {
            throw new ArithmeticException("Incompatible dimensions of algebraic operation - scalar increment by vector");
        }
    }

    @Override
    protected void incrementBy(VectorValue value) {
        if (value.values.length != this.values.length) {
            String err = "Vector incrementBy dimension mismatch: " + value.values.length + " vs." + this.values.length;
            LOG.severe(err);
            throw new ArithmeticException(err);
        }
        double[] otherValues = value.values;
        for (int i = 0; i < otherValues.length; ++i) {
            int n = i;
            otherValues[n] = otherValues[n] + this.values[i];
        }
    }

    @Override
    protected void incrementBy(MatrixValue value) {
        String err = "Incompatible dimensions of algebraic operation - matrix increment by vector";
        LOG.severe(err);
        throw new ArithmeticException(err);
    }

    @Override
    protected void incrementBy(TensorValue value) {
        throw new ArithmeticException("Algebraic operation between Tensor and Vector are not implemented yet");
    }

    @Override
    public void elementMultiplyBy(Value value) {
        value.elementMultiplyBy(this);
    }

    @Override
    protected void elementMultiplyBy(ScalarValue value) {
        String err = "Incompatible dimensions of algebraic operation - scalar elementMultiplyBy by vector";
        LOG.severe(err);
        throw new ArithmeticException(err);
    }

    @Override
    protected void elementMultiplyBy(VectorValue value) {
        if (value.values.length != this.values.length) {
            String err = "Vector multiplyBy dimension mismatch: " + value.values.length + " vs." + this.values.length;
            LOG.severe(err);
            throw new ArithmeticException(err);
        }
        double[] otherValues = value.values;
        for (int i = 0; i < otherValues.length; ++i) {
            int n = i;
            otherValues[n] = otherValues[n] * this.values[i];
        }
    }

    @Override
    protected void elementMultiplyBy(MatrixValue value) {
        String err = "Incompatible dimensions of algebraic operation - matrix multiplyBy by vector";
        LOG.severe(err);
        throw new ArithmeticException(err);
    }

    @Override
    protected void elementMultiplyBy(TensorValue value) {
        throw new ArithmeticException("Algebbraic operation between Tensor and Vector are not implemented yet");
    }

    @Override
    public boolean greaterThan(Value maxValue) {
        return maxValue.greaterThan(this);
    }

    @Override
    protected boolean greaterThan(ScalarValue maxValue) {
        double sum = 0.0;
        for (int i = 0; i < this.values.length; ++i) {
            sum += this.values[i];
        }
        return maxValue.value > sum;
    }

    @Override
    protected boolean greaterThan(VectorValue maxValue) {
        if (maxValue.values.length != this.values.length) {
            String err = "Vector greaterThan dimension mismatch: " + maxValue.values.length + " vs." + this.values.length;
            LOG.severe(err);
            throw new ArithmeticException(err);
        }
        double thisSum = 0.0;
        double otherSum = 0.0;
        for (int i = 0; i < this.values.length; ++i) {
            thisSum += this.values[i];
            otherSum += maxValue.values[i];
        }
        return otherSum > thisSum;
    }

    @Override
    protected boolean greaterThan(MatrixValue maxValue) {
        LOG.severe("Incompatible dimensions of algebraic operation - matrix greaterThan vector");
        return false;
    }

    @Override
    protected boolean greaterThan(TensorValue maxValue) {
        throw new ArithmeticException("Algebbraic operation between Tensor and Vector are not implemented yet");
    }

    @Override
    public boolean equals(Value obj) {
        if (obj instanceof VectorValue) {
            if (this.rowOrientation != ((VectorValue)obj).rowOrientation) {
                return false;
            }
            return Arrays.equals(this.values, ((VectorValue)obj).values);
        }
        return false;
    }

    @Override
    public int hashCode() {
        long hashCode = 1L;
        for (int i = 0; i < this.values.length; ++i) {
            hashCode = 31L * hashCode + (long)Double.valueOf(this.values[i]).hashCode();
        }
        return Long.hashCode(hashCode);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof VectorValue)) {
            return false;
        }
        VectorValue vectorValue = (VectorValue)obj;
        if (vectorValue.values.length != this.values.length) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == vectorValue.values[i]) continue;
            return false;
        }
        return true;
    }

    protected class ValueIterator
    implements Iterator<Double> {
        int i = 0;

        protected ValueIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.i < VectorValue.this.values.length;
        }

        @Override
        public Double next() {
            return VectorValue.this.values[this.i++];
        }
    }
}

