/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.algebra.values.inits;

import cz.cvut.fel.ida.algebra.values.MatrixValue;
import cz.cvut.fel.ida.algebra.values.ScalarValue;
import cz.cvut.fel.ida.algebra.values.VectorValue;
import cz.cvut.fel.ida.algebra.values.inits.GlorotUniformInitializer;
import cz.cvut.fel.ida.setup.Settings;
import java.util.logging.Logger;

public class HeUniformInitializer
extends GlorotUniformInitializer {
    private static final Logger LOG = Logger.getLogger(HeUniformInitializer.class.getName());

    public HeUniformInitializer(Settings settings) {
        super(settings);
    }

    @Override
    protected double getLimit(MatrixValue value) {
        return Math.sqrt(6.0) / Math.sqrt(value.cols);
    }

    @Override
    protected double getLimit(VectorValue value) {
        if (value.rowOrientation) {
            return Math.sqrt(6.0) / Math.sqrt(value.values.length);
        }
        return Math.sqrt(6.0) / 1.0;
    }

    @Override
    protected double getLimit(ScalarValue value) {
        return Math.sqrt(6.0) / Math.sqrt(1.0);
    }
}

