/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.algebra.weights;

import cz.cvut.fel.ida.algebra.utils.metadata.WeightMetadata;
import cz.cvut.fel.ida.algebra.values.Value;
import cz.cvut.fel.ida.algebra.values.inits.ValueInitializer;
import cz.cvut.fel.ida.setup.Settings;
import cz.cvut.fel.ida.utils.exporting.Exportable;
import java.text.NumberFormat;
import org.jetbrains.annotations.Nullable;

public class Weight
implements Exportable {
    public final int index;
    public final String name;
    public Value value;
    public boolean isFixed = false;
    public Boolean isLearnable;
    public boolean manualInitialization = false;
    public boolean isShared;
    public boolean dropout = false;
    @Nullable
    double learningRate;
    public boolean isOffset;
    public Value momentum;
    public Value velocity;
    public WeightMetadata metadata;
    public static Weight unitWeight = new Weight(-1, "one", Value.ONE, true, true);
    public static Weight zeroWeight = new Weight(-2, "zero", Value.ZERO, true, true);

    public Weight(int index, String name, Value value, boolean fixed, boolean isInitialized) {
        this.index = index;
        this.name = name;
        this.value = value;
        this.isFixed = fixed;
        this.manualInitialization = isInitialized;
        if (isInitialized) {
            this.metadata = new WeightMetadata(value);
        }
        if (this.isFixed || index < 0) {
            this.isLearnable = false;
        }
    }

    public Weight clone() {
        Weight clone = new Weight(this.index, this.name, this.value.clone(), this.isFixed, this.manualInitialization);
        clone.metadata = this.metadata;
        clone.dropout = this.dropout;
        clone.isShared = this.isShared;
        if (this.momentum != null) {
            clone.momentum = this.momentum.clone();
            clone.velocity = this.velocity.clone();
        }
        return clone;
    }

    public int hashCode() {
        return this.index;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Weight)) {
            return false;
        }
        Weight obj1 = (Weight)obj;
        return this.index == obj1.index;
    }

    public void init(ValueInitializer valueInitializer) {
        if (this.isFixed) {
            return;
        }
        if (this.velocity != null) {
            this.velocity.zero();
        }
        if (this.momentum != null) {
            this.momentum.zero();
        }
        if (this.manualInitialization) {
            this.value = (Value)this.metadata.getByName("initValue");
            return;
        }
        this.value.initialize(valueInitializer);
    }

    public String toString() {
        return this.toString(Settings.shortNumberFormat);
    }

    public String toString(NumberFormat nf) {
        StringBuilder sb = new StringBuilder();
        if (this.manualInitialization || this.isFixed || this.isShared) {
            sb.append("<" + this.name + ">:");
        } else {
            sb.append(this.name + ":");
        }
        sb.append(this.value.toString(nf));
        return sb.toString();
    }

    public boolean isLearnable() {
        if (this.isLearnable != null) {
            return this.isLearnable;
        }
        this.isLearnable = this.isFixed ? Boolean.valueOf(false) : (this.index < 0 ? Boolean.valueOf(false) : (this.value == Value.ONE || this.value == Value.ZERO ? Boolean.valueOf(false) : Boolean.valueOf(true)));
        return this.isLearnable;
    }
}

