/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.drawing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class DrawWindow
extends JFrame {
    private static final Logger LOG = Logger.getLogger(DrawWindow.class.getName());
    private static final GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
    private static final int screenWidth = gd.getDisplayMode().getWidth();
    private static final int screenHeight = gd.getDisplayMode().getHeight();
    BufferedImage img;
    private static boolean centerImage = false;

    public DrawWindow(byte[] imageBytes, String name, final Object lock) {
        this.setDefaultCloseOperation(2);
        this.setTitle(name + " (close this window to continue debugging...)");
        if (centerImage) {
            this.setExtendedState(6);
        }
        try {
            this.img = ImageIO.read(new ByteArrayInputStream(imageBytes));
            if (this.img == null) {
                LOG.severe("The graph's image could not have been drawn!");
                return;
            }
        }
        catch (IOException e) {
            LOG.severe(e.getMessage());
        }
        ImagePanel imagePanel = new ImagePanel(this.img);
        JComponent scroll = this.makeScrollingPanel(imagePanel);
        this.add((Component)scroll, "Center");
        this.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosing(WindowEvent arg0) {
                Object object = lock;
                synchronized (object) {
                    DrawWindow.this.setVisible(false);
                    DrawWindow.this.dispose();
                    lock.notify();
                }
            }
        });
        this.pack();
        this.setVisible(true);
        imagePanel.revalidate();
        imagePanel.repaint();
    }

    public void pauseUntilWindowCloses(Object lock) {
        Thread t = new Thread(() -> {
            Object object = lock;
            synchronized (object) {
                while (this.isVisible()) {
                    try {
                        lock.wait();
                    }
                    catch (InterruptedException e) {
                        LOG.severe(e.getMessage());
                    }
                }
                LOG.finer("Image window closed");
            }
        });
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException e) {
            LOG.severe(e.getMessage());
        }
    }

    public JComponent makeScrollingPanel(ImagePanel imagePanel) {
        JScrollPane scroll = new JScrollPane(imagePanel);
        JViewport vport = scroll.getViewport();
        vport.addMouseMotionListener(imagePanel.mouseListener);
        vport.addMouseListener(imagePanel.mouseListener);
        vport.addMouseWheelListener(imagePanel.mouseListener);
        return scroll;
    }

    static class ImagePanel
    extends JPanel {
        private static final RenderingHints textRenderHints = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        private static final RenderingHints imageRenderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        private static final RenderingHints renderHints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        BufferedImage img;
        double scale = 1.0;
        Point position;
        MouseAdapter mouseListener;

        public ImagePanel(BufferedImage img) {
            this.img = img;
            this.setBackground(Color.BLACK);
            this.setBorder(BorderFactory.createLineBorder(Color.BLUE, 1));
            this.mouseListener = new MouseListener();
            this.position = new Point(0, 0);
            this.scale = Math.min((double)(screenWidth - 4) / (double)img.getWidth(null), (double)(screenHeight - 15) / (double)img.getHeight(null));
            this.setDoubleBuffered(true);
        }

        public static void applyRenderHints(Graphics2D g2d) {
            g2d.setRenderingHints(textRenderHints);
            g2d.setRenderingHints(imageRenderHints);
            g2d.setRenderingHints(renderHints);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = new Dimension((int)((double)this.img.getWidth() * this.scale), (int)((double)this.img.getHeight() * this.scale));
            return size;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g.create();
            ImagePanel.applyRenderHints(g2d);
            if (centerImage) {
                g2d.translate(this.getWidth() / 2, (this.getHeight() + 15) / 2);
                g2d.translate(-((double)this.img.getWidth() * this.scale) / 2.0, -((double)this.img.getHeight() * this.scale) / 2.0);
            }
            g2d.scale(this.scale, this.scale);
            g2d.drawImage((Image)this.img, 0, 0, this);
            g2d.dispose();
            this.invalidate();
            this.revalidate();
        }

        private Image getScaledImage(Image srcImg, int w, int h) {
            BufferedImage resizedImg = new BufferedImage(w, h, 2);
            Graphics2D g2 = resizedImg.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.drawImage(srcImg, 0, 0, w, h, null);
            g2.dispose();
            return resizedImg;
        }

        private Image getScaledInstance(int w, int h) {
            return this.img.getScaledInstance(w, h, 2);
        }

        class MouseListener
        extends MouseAdapter {
            MouseListener() {
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                double delta = 1.0 - 0.05 * e.getPreciseWheelRotation();
                ImagePanel.this.scale *= delta;
                this.zoomShift(e, delta);
                ImagePanel.this.invalidate();
                ImagePanel.this.revalidate();
                ImagePanel.this.repaint();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                JViewport vport = (JViewport)e.getSource();
                JComponent label = (JComponent)vport.getView();
                Point cp = e.getPoint();
                Point vp = vport.getViewPosition();
                vp.translate(ImagePanel.this.position.x - cp.x, ImagePanel.this.position.y - cp.y);
                label.scrollRectToVisible(new Rectangle(vp, vport.getSize()));
                ImagePanel.this.position.setLocation(cp);
                ImagePanel.this.invalidate();
                ImagePanel.this.revalidate();
                ImagePanel.this.repaint();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                ImagePanel.this.position.setLocation(e.getPoint());
            }

            private void zoomShift(MouseEvent e, double scaleDelta) {
                JViewport vport = (JViewport)e.getSource();
                JComponent label = (JComponent)vport.getView();
                Point cp = e.getPoint();
                Point vp = vport.getViewPosition();
                int newX = (int)((double)cp.x * (scaleDelta - 1.0) + scaleDelta * (double)vp.x);
                int newY = (int)((double)cp.y * (scaleDelta - 1.0) + scaleDelta * (double)vp.y);
                Point moved = new Point(newX, newY);
                label.scrollRectToVisible(new Rectangle(moved, vport.getSize()));
                ImagePanel.this.position.setLocation(cp);
            }
        }
    }
}

