/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.drawing;

import cz.cvut.fel.ida.drawing.DrawWindow;
import cz.cvut.fel.ida.drawing.GraphViz;
import cz.cvut.fel.ida.setup.Settings;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public abstract class Drawer<S> {
    private static final Logger LOG = Logger.getLogger(Drawer.class.getName());
    public NumberFormat numberFormat;
    protected Settings.Detail drawingDetail;
    protected boolean storeNotShow;
    protected GraphViz graphviz;
    public Settings settings;

    public Drawer(Settings settings) {
        this.settings = settings;
        if (settings.drawing) {
            this.graphviz = new GraphViz(settings);
            Logger.getLogger("java.awt").setLevel(Level.WARNING);
            Logger.getLogger("sun.awt").setLevel(Level.WARNING);
            Logger.getLogger("javax.swing").setLevel(Level.WARNING);
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
                // empty catch block
            }
        }
        this.drawingDetail = settings.drawingDetail;
        this.numberFormat = this.drawingDetail == Settings.Detail.LOW ? null : Settings.defaultNumberFormat;
        this.storeNotShow = settings.storeNotShow;
    }

    public void display(byte[] imageBytes, String name) {
        Logger.getLogger("java.awt").setLevel(Level.WARNING);
        Logger.getLogger("sun.awt").setLevel(Level.WARNING);
        Logger.getLogger("javax.swing").setLevel(Level.WARNING);
        Object lock = new Object();
        DrawWindow debugWindow = new DrawWindow(imageBytes, name, lock);
        debugWindow.pauseUntilWindowCloses(lock);
    }

    public void draw(S obj) {
        if (this.graphviz == null) {
            LOG.warning("Drawing is required but no graphviz exec found, could not draw!");
            return;
        }
        this.graphviz.clearGraph();
        this.loadGraph(obj);
        try {
            LOG.info("Paused for drawing with Graphviz...(this may take a while for bigger graphs)");
            if (this.storeNotShow) {
                this.graphviz.storeGraphSource(obj.toString());
                byte[] image = this.graphviz.getGraphUsingTemporaryFile(this.graphviz.getDotSource(), this.graphviz.imgtype, this.graphviz.algorithm);
                this.graphviz.writeImageToFile(image, obj.toString());
                LOG.info("Graph stored into file named: " + obj.toString());
            } else {
                this.display(this.graphviz.getGraphImage(obj.toString()), obj.toString());
            }
        }
        catch (IOException | InterruptedException e) {
            LOG.severe(e.getMessage());
        }
    }

    public byte[] drawIntoFile(S obj, String path) {
        byte[] image = this.drawIntoBytes(obj);
        File file = new File(path);
        file.getParentFile().mkdirs();
        this.graphviz.writeImageToFile(image, file);
        return null;
    }

    public byte[] drawIntoBytes(S obj) {
        if (this.graphviz == null) {
            this.graphviz = new GraphViz(this.settings);
        }
        this.graphviz.clearGraph();
        this.loadGraph(obj);
        return this.graphviz.getGraphUsingTemporaryFile(this.graphviz.getDotSource(), this.graphviz.imgtype, this.graphviz.algorithm);
    }

    public String getGraphSource(S obj) {
        if (this.graphviz == null) {
            this.graphviz = new GraphViz(this.settings);
        }
        this.graphviz.clearGraph();
        this.loadGraph(obj);
        return this.graphviz.getDotSource();
    }

    public abstract void loadGraph(S var1);
}

