/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.learning.crossvalidation.splitting;

import cz.cvut.fel.ida.learning.LearningSample;
import cz.cvut.fel.ida.learning.crossvalidation.Fold;
import cz.cvut.fel.ida.learning.crossvalidation.splitting.LinearSplitter;
import cz.cvut.fel.ida.learning.crossvalidation.splitting.StratifiedSplitter;
import cz.cvut.fel.ida.setup.Settings;
import cz.cvut.fel.ida.utils.generic.Pair;
import cz.cvut.fel.ida.utils.generic.Utilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public interface Splitter<T extends LearningSample> {
    public List<Stream<T>> partition(Stream<T> var1, int var2);

    public List<List<T>> partition(List<T> var1, int var2);

    public Pair<List<T>, List<T>> partition(List<T> var1, double var2);

    default public List<Fold<T>> splitIntoFolds(Stream<T> samples, int foldCount) {
        return this.splitIntoFolds(this.partition(samples, foldCount));
    }

    default public List<Fold<T>> splitIntoFolds(List<Stream<T>> streams) {
        ArrayList<List<T>> folds = new ArrayList<List<T>>(streams.size());
        for (Stream<T> fold : streams) {
            folds.add(Utilities.terminateSampleStream(fold));
        }
        ArrayList<Fold<T>> cvf = new ArrayList<Fold<T>>(streams.size());
        for (int i = 0; i < folds.size(); ++i) {
            Fold fold = new Fold(i);
            fold.test = (List)folds.get(i);
            fold.train = new ArrayList();
            for (int j = 0; j < folds.size(); ++j) {
                if (j == i) continue;
                fold.train.addAll((Collection)folds.get(j));
            }
            cvf.add(fold);
        }
        return cvf;
    }

    @Deprecated
    default public Stream<Stream<T>> splitIntoStreams(Stream<T> samples) {
        return null;
    }

    @NotNull
    public static <T extends LearningSample> Splitter<T> getSplitter(Settings settings) {
        if (settings.stratification && settings.trainOnlineResultsType != Settings.ResultsType.REGRESSION) {
            return new StratifiedSplitter(settings);
        }
        return new LinearSplitter(settings);
    }
}

