/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.learning.results;

import cz.cvut.fel.ida.algebra.functions.ErrorFcn;
import cz.cvut.fel.ida.algebra.functions.error.Crossentropy;
import cz.cvut.fel.ida.algebra.functions.error.SoftEntropy;
import cz.cvut.fel.ida.algebra.functions.error.SquaredDiff;
import cz.cvut.fel.ida.algebra.values.Value;
import cz.cvut.fel.ida.setup.Settings;
import java.util.logging.Logger;

public class Result
implements Comparable<Result> {
    private static final Logger LOG = Logger.getLogger(Result.class.getName());
    ErrorFcn errorFcn;
    public String sampleId;
    int position;
    private Value output;
    private Value target;

    private Result(ErrorFcn errorFcn, String sampleId, int position, Value target, Value output) {
        this.errorFcn = errorFcn;
        this.sampleId = sampleId;
        this.position = position;
        this.setTarget(target);
        this.setOutput(output);
    }

    public Value errorValue() {
        return this.errorFcn.evaluate(this.getOutput(), this.getTarget());
    }

    public Value errorGradient() {
        return this.errorFcn.differentiate(this.getOutput(), this.getTarget());
    }

    public Value getOutput() {
        return this.output;
    }

    public void setOutput(Value output) {
        if (output.isNaN()) {
            throw new RuntimeException("NaN value encountered as an output result from sample " + this.sampleId + " - check for value/gradient exploding problems (or decrease learning rate)");
        }
        this.output = output;
    }

    public Value getTarget() {
        return this.target;
    }

    public void setTarget(Value target) {
        this.target = target;
    }

    public String toString() {
        return this.sampleId + " -> " + this.getOutput().toDetailedString() + " : " + String.valueOf(this.getTarget());
    }

    @Override
    public int compareTo(Result other) {
        return this.getOutput().compareTo(other.getOutput());
    }

    public static class Factory {
        Settings settings;
        ErrorFcn errorFcn;

        public Factory(Settings settings) {
            this.settings = settings;
            this.errorFcn = this.getErrFcn(settings);
        }

        public Result create(String sampleId, int index, Value target, Value output) {
            Result result = new Result(this.errorFcn, sampleId, index, target, output);
            return result;
        }

        private ErrorFcn getErrFcn(Settings settings) {
            if (settings.errorFunction == Settings.ErrorFcn.SQUARED_DIFF) {
                return SquaredDiff.singleton;
            }
            if (settings.errorFunction == Settings.ErrorFcn.CROSSENTROPY) {
                return Crossentropy.singleton;
            }
            if (settings.errorFunction == Settings.ErrorFcn.SOFTENTROPY) {
                return SoftEntropy.singleton;
            }
            return null;
        }
    }
}

