/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.learning.results;

import cz.cvut.fel.ida.algebra.functions.Aggregation;
import cz.cvut.fel.ida.algebra.functions.aggregation.Average;
import cz.cvut.fel.ida.algebra.functions.aggregation.Sum;
import cz.cvut.fel.ida.algebra.values.Value;
import cz.cvut.fel.ida.learning.results.ClassificationResults;
import cz.cvut.fel.ida.learning.results.DetailedClassificationResults;
import cz.cvut.fel.ida.learning.results.KBCResults;
import cz.cvut.fel.ida.learning.results.RegressionResults;
import cz.cvut.fel.ida.learning.results.Result;
import cz.cvut.fel.ida.learning.results.VoidResults;
import cz.cvut.fel.ida.learning.results.metrics.HITS;
import cz.cvut.fel.ida.setup.Settings;
import cz.cvut.fel.ida.utils.exporting.Exportable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class Results
implements Exportable<Results> {
    private static final Logger LOG = Logger.getLogger(Results.class.getName());
    transient Settings settings;
    @Deprecated
    public boolean evaluatedOnline = true;
    public transient List<Result> evaluations;
    Aggregation aggregationFcn;
    public Value error;

    public Results(@NotNull List<Result> evaluations, Settings settings) {
        this.settings = settings;
        this.evaluations = evaluations;
        this.aggregationFcn = Results.getAggregation(settings);
        if (!evaluations.isEmpty()) {
            this.recalculate();
        }
    }

    public void addResult(Result result) {
        this.evaluations.add(result);
    }

    public String toString() {
        return this.aggregationFcn.toString() + "-error= " + this.error.toDetailedString();
    }

    public abstract boolean recalculate();

    public abstract boolean betterThan(Results var1, Settings.ModelSelection var2);

    protected Results(Value meanError) {
        this.error = meanError;
    }

    public StringBuilder printOutputs(boolean sortByIndex) {
        if (sortByIndex) {
            this.evaluations.sort(new Comparator<Result>(){

                @Override
                public int compare(Result o1, Result o2) {
                    return Integer.compare(o1.position, o2.position);
                }
            });
        } else {
            Collections.sort(this.evaluations);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        for (Result evaluation : this.evaluations) {
            sb.append(evaluation.sampleId);
            sb.append(" , output: " + evaluation.getOutput().toDetailedString());
            if (evaluation.getTarget() != null) {
                sb.append(" , target: " + String.valueOf(evaluation.getTarget()));
            }
            sb.append("\n");
        }
        return sb;
    }

    private static Aggregation getAggregation(Settings settings) {
        if (settings.errorAggregationFcn == Settings.CombinationFcn.AVG) {
            return new Average();
        }
        if (settings.errorAggregationFcn == Settings.CombinationFcn.SUM) {
            return new Sum();
        }
        LOG.severe("Unsupported errorAggregationFcn.");
        return null;
    }

    public abstract String toString(Settings var1);

    public boolean isEmpty() {
        return this.evaluations.isEmpty();
    }

    private static class KBCFactory
    extends Factory<KBCResults> {
        HITS hits;
        private Set<HITS> consumed = new HashSet<HITS>();

        public KBCFactory(Settings settings) {
            super(settings);
        }

        @Override
        public KBCResults createFrom(List<Result> outputs) {
            KBCResults kbcResults = new KBCResults(outputs, this.settings, this.hits);
            this.cacheForReuse(kbcResults);
            return kbcResults;
        }

        @Override
        public void cacheForReuse(KBCResults results) {
            if (this.hits == null) {
                this.hits = results.hits;
                this.consumed.add(results.hits);
            } else if (this.hits != results.hits && !this.consumed.contains(results.hits)) {
                this.hits.mergeWith(results.hits);
                this.consumed.add(results.hits);
            }
        }
    }

    private static class DetailedClassificationFactory
    extends Factory<DetailedClassificationResults> {
        public DetailedClassificationFactory(Settings settings) {
            super(settings);
        }

        @Override
        public DetailedClassificationResults createFrom(List<Result> outputs) {
            return new DetailedClassificationResults(outputs, this.settings);
        }
    }

    private static class ClassificationFactory
    extends Factory<ClassificationResults> {
        public ClassificationFactory(Settings settings) {
            super(settings);
        }

        @Override
        public ClassificationResults createFrom(List<Result> outputs) {
            return new ClassificationResults(outputs, this.settings);
        }
    }

    private static class RegressionFactory
    extends Factory<RegressionResults> {
        public RegressionFactory(Settings settings) {
            super(settings);
        }

        @Override
        public RegressionResults createFrom(List<Result> outputs) {
            return new RegressionResults(outputs, this.settings);
        }
    }

    private static class VoidFactory
    extends Factory<Results> {
        public VoidFactory(Settings settings) {
            super(settings);
        }

        @Override
        public Results createFrom(List<Result> outputs) {
            return new VoidResults(outputs, this.settings);
        }
    }

    public static abstract class Factory<R extends Results> {
        Settings settings;

        public Factory(Settings settings) {
            this.settings = settings;
        }

        public static Factory getFrom(Settings.ResultsType type, Settings settings) {
            switch (type) {
                case KBC: {
                    return new KBCFactory(settings);
                }
                case REGRESSION: {
                    return new RegressionFactory(settings);
                }
                case CLASSIFICATION: {
                    return new ClassificationFactory(settings);
                }
                case DETAILEDCLASSIFICATION: {
                    return new DetailedClassificationFactory(settings);
                }
            }
            throw new RuntimeException("Unknown ResultsType required");
        }

        public abstract R createFrom(List<Result> var1);

        public void cacheForReuse(R trainingResults) {
        }
    }
}

