/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic;

import cz.cvut.fel.ida.logic.Constant;
import cz.cvut.fel.ida.logic.Literal;
import cz.cvut.fel.ida.logic.Term;
import cz.cvut.fel.ida.logic.Variable;
import cz.cvut.fel.ida.utils.generic.tuples.Pair;
import cz.cvut.fel.ida.utils.math.Sugar;
import cz.cvut.fel.ida.utils.math.collections.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class Clause {
    private LinkedHashSet<Literal> literals = new LinkedHashSet();
    private MultiMap<String, Literal> literalsByName;
    private MultiMap<Term, Literal> literalsByTerms;
    private int hashCode = -1;

    public Clause() {
    }

    public Clause(Iterable<? extends Literal> literals) {
        for (Literal literal : literals) {
            literal.allowModifications(false);
            this.addLiteral(literal);
        }
    }

    public Clause(Literal ... literals) {
        for (Literal literal : literals) {
            literal.allowModifications(false);
            this.addLiteral(literal);
        }
    }

    public void addLiterals(Collection<Literal> c) {
        this.hashCode = -1;
        for (Literal l : c) {
            this.addLiteral(l);
        }
    }

    public void addLiteral(Literal literal) {
        this.hashCode = -1;
        if (!this.literals.contains(literal)) {
            this.literals.add(literal);
        }
        if (this.literalsByName != null) {
            this.literalsByName.put(literal.predicateName(), literal);
        }
        if (this.literalsByTerms != null) {
            for (int i = 0; i < literal.arity(); ++i) {
                this.literalsByTerms.put(literal.get(i), literal);
            }
        }
    }

    public void removeLiteral(Literal literal) {
        this.hashCode = -1;
        if (this.literals.contains(literal)) {
            this.literals.remove(literal);
        }
        if (this.literalsByName != null) {
            this.literalsByName.remove(literal.predicateName(), literal);
        }
        if (this.literalsByTerms != null) {
            for (int i = 0; i < literal.arity(); ++i) {
                this.literalsByTerms.remove(literal.get(i), literal);
            }
        }
    }

    private void initLiteralsByTerms() {
        this.literalsByTerms = new MultiMap();
        for (Literal literal : this.literals) {
            for (int i = 0; i < literal.arity(); ++i) {
                this.literalsByTerms.put(literal.get(i), literal);
            }
        }
    }

    private void initLiteralsByName() {
        this.literalsByName = new MultiMap();
        for (Literal literal : this.literals) {
            this.literalsByName.put(literal.predicateName(), literal);
        }
    }

    public boolean isSubsetOf(Clause clause) {
        HashSet<Literal> set = new HashSet<Literal>();
        set.addAll(clause.literals);
        for (Literal l : this.literals) {
            if (set.contains(l)) continue;
            return false;
        }
        return true;
    }

    public int countLiterals() {
        return this.literals.size();
    }

    public Map<Term, Integer> termFrequenciesModLiterals() {
        if (this.literalsByTerms == null) {
            this.initLiteralsByTerms();
        }
        HashMap<Term, Integer> frequencies = new HashMap<Term, Integer>();
        for (Map.Entry<Term, Set<Literal>> entry : this.literalsByTerms.entrySet()) {
            frequencies.put(entry.getKey(), entry.getValue().size());
        }
        return frequencies;
    }

    public Map<Variable, Integer> variableFrequenciesModLiterals() {
        if (this.literalsByTerms == null) {
            this.initLiteralsByTerms();
        }
        HashMap<Variable, Integer> frequencies = new HashMap<Variable, Integer>();
        for (Map.Entry<Term, Set<Literal>> entry : this.literalsByTerms.entrySet()) {
            if (!(entry.getKey() instanceof Variable)) continue;
            frequencies.put((Variable)entry.getKey(), entry.getValue().size());
        }
        return frequencies;
    }

    public LinkedHashSet<Literal> literals() {
        return this.literals;
    }

    public Set<String> predicates() {
        if (this.literalsByName == null) {
            this.initLiteralsByName();
        }
        return this.literalsByName.keySet();
    }

    public Collection<Literal> getLiteralsByPredicate(String predicate) {
        if (this.literalsByName == null) {
            this.initLiteralsByName();
        }
        return this.literalsByName.get(predicate);
    }

    public Collection<Literal> getLiteralsByTerm(Term term) {
        if (this.literalsByTerms == null) {
            this.initLiteralsByTerms();
        }
        return this.literalsByTerms.get(term);
    }

    public boolean containsLiteral(Literal literal) {
        return this.literals.contains(literal);
    }

    public Set<Variable> variables() {
        if (this.literalsByTerms == null) {
            this.initLiteralsByTerms();
        }
        HashSet<Variable> set = new HashSet<Variable>();
        for (Map.Entry<Term, Set<Literal>> entry : this.literalsByTerms.entrySet()) {
            if (!(entry.getKey() instanceof Variable) || entry.getValue().size() <= 0) continue;
            set.add((Variable)entry.getKey());
        }
        return set;
    }

    public Set<Term> terms() {
        if (this.literalsByTerms == null) {
            this.initLiteralsByTerms();
        }
        return this.literalsByTerms.keySet();
    }

    public static Clause parse(String str) {
        return Clause.parse(str, ',');
    }

    public static Clause parse(String str, char literalSeparator) {
        if (((String)(str = ((String)str).trim())).isEmpty()) {
            return new Clause(Sugar.list());
        }
        if (((String)str).charAt(((String)str).length() - 1) == '.') {
            str = ((String)str).substring(0, ((String)str).length() - 1);
        }
        str = (String)str + literalSeparator + " ";
        int brackets = 0;
        boolean inQuotes = false;
        boolean ignoreNext = false;
        boolean expectingLiteralSeparator = false;
        ArrayList<String> split = new ArrayList<String>();
        char[] chars = ((String)str).toCharArray();
        StringBuilder sb = new StringBuilder();
        block7: for (char c : chars) {
            if (ignoreNext) {
                sb.append(c);
                ignoreNext = false;
                continue;
            }
            if (inQuotes) {
                sb.append(c);
                if (c != '\'') continue;
                inQuotes = false;
                continue;
            }
            switch (c) {
                case '\\': {
                    ignoreNext = true;
                    continue block7;
                }
                case '\t': 
                case '\n': 
                case ' ': {
                    continue block7;
                }
                case '\'': {
                    inQuotes = !inQuotes;
                    sb.append(c);
                    continue block7;
                }
                case '(': {
                    ++brackets;
                    sb.append(c);
                    continue block7;
                }
                case ')': {
                    --brackets;
                    expectingLiteralSeparator = true;
                    sb.append(c);
                    continue block7;
                }
                default: {
                    if (expectingLiteralSeparator && c == literalSeparator) {
                        expectingLiteralSeparator = false;
                        if (brackets == 0) {
                            split.add(sb.toString());
                            sb = new StringBuilder();
                            continue block7;
                        }
                        sb.append(c);
                        continue block7;
                    }
                    sb.append(c);
                }
            }
        }
        HashMap<Variable, Variable> variables = new HashMap<Variable, Variable>();
        HashMap<Constant, Constant> constants = new HashMap<Constant, Constant>();
        ArrayList<Literal> parsedLiterals = new ArrayList<Literal>();
        for (String s : split) {
            if (s.trim().length() <= 0) continue;
            parsedLiterals.add(Literal.parseLiteral(s.trim(), variables, constants));
        }
        int anonymousIndex = 1;
        for (Literal l : parsedLiterals) {
            for (int i = 0; i < l.arity(); ++i) {
                if (!l.get(i).name().equals("_")) continue;
                Variable an = Variable.construct("_" + anonymousIndex++);
                while (variables.containsKey(an.name())) {
                    an = Variable.construct("_" + anonymousIndex++, l.get(i).type());
                }
                l.set((Term)an, i);
                variables.put(an, an);
            }
        }
        return new Clause(parsedLiterals);
    }

    public String toString() {
        return this.toPrologLikeString(", ");
    }

    public String toString(String separator) {
        return this.toPrologLikeString(separator);
    }

    private String toPrologLikeString(String separator) {
        if (this.literals.size() == 0) {
            return "#EmptyClause";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        int numLiterals = this.literals.size();
        for (Literal l : this.literals) {
            sb.append(l.toString());
            if (i < numLiterals - 1) {
                sb.append(separator);
            }
            ++i;
        }
        return sb.toString();
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.literals.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof Clause) {
            Clause c = (Clause)o;
            return this.isSubsetOf(c) && c.isSubsetOf(this);
        }
        return false;
    }

    public Collection<Clause> connectedComponents() {
        return this.connectedComponents(false);
    }

    public Collection<Clause> connectedComponents(boolean justVariables) {
        return this.connectedComponents(justVariables, new HashSet<Term>());
    }

    public Collection<Clause> connectedComponents(boolean justVariables, Set<Term> ignoredTerms) {
        if (this.literalsByTerms == null) {
            this.initLiteralsByTerms();
        }
        HashSet<Literal> allLiteralsInSomeComponent = new HashSet<Literal>();
        Set<Collection<Term>> remainingTerms = justVariables ? Sugar.collectionDifference(this.variables(), ignoredTerms) : Sugar.collectionDifference(this.literalsByTerms.keySet(), ignoredTerms);
        ArrayList<Clause> components = new ArrayList<Clause>();
        while (remainingTerms.size() > 0) {
            Pair<Clause, Set<? extends Term>> pair = this.connectedComponent((Term)((Object)Sugar.chooseOne(remainingTerms)), ignoredTerms, justVariables);
            components.add((Clause)pair.r);
            allLiteralsInSomeComponent.addAll(((Clause)pair.r).literals());
            remainingTerms = Sugar.collectionDifference(remainingTerms, (Collection)pair.s);
        }
        for (Literal literal : Sugar.collectionDifference(this.literals, allLiteralsInSomeComponent)) {
            components.add(new Clause(Sugar.set(literal)));
        }
        return components;
    }

    private Pair<Clause, Set<? extends Term>> connectedComponent(Term termInComponent, Set<Term> ignoredTerms, boolean justVariables) {
        int i;
        HashSet<Term> closed = new HashSet<Term>();
        Stack<Term> open = new Stack<Term>();
        HashSet<Term> openSet = new HashSet<Term>();
        for (Literal literal : this.getLiteralsByTerm(termInComponent)) {
            for (int i2 = 0; i2 < literal.arity(); ++i2) {
                if (justVariables && !(literal.get(i2) instanceof Variable) || ignoredTerms.contains(literal.get(i2))) continue;
                open.push(literal.get(i2));
            }
        }
        while (!open.isEmpty()) {
            Term term = (Term)open.pop();
            if (closed.contains(term)) continue;
            for (Literal literal : this.getLiteralsByTerm(term)) {
                for (i = 0; i < literal.arity(); ++i) {
                    if (closed.contains(literal.get(i)) || openSet.contains(literal.get(i)) || justVariables && !(literal.get(i) instanceof Variable) || ignoredTerms.contains(literal.get(i))) continue;
                    open.push(literal.get(i));
                    openSet.add(literal.get(i));
                }
            }
            if (ignoredTerms.contains(term)) continue;
            closed.add(term);
        }
        HashSet<Literal> lits = new HashSet<Literal>();
        block5: for (Literal literal : this.literals()) {
            for (i = 0; i < literal.arity(); ++i) {
                if (justVariables && !(literal.get(i) instanceof Variable) || !closed.contains(literal.get(i))) continue;
                lits.add(literal);
                continue block5;
            }
        }
        return new Pair<Clause, Set<? extends Term>>(new Clause(lits), closed);
    }

    public static void main(String[] args) {
        Clause c = Clause.parse("professor(a1) v !taughtBy(a2,a1,a3) v !courseLevel(a2,Level_500)", 'v');
        for (Clause comp : c.connectedComponents(false, Sugar.set(Constant.construct("a1")))) {
            System.out.println(comp);
        }
    }
}

