/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic;

import cz.cvut.fel.ida.logic.Clause;
import cz.cvut.fel.ida.logic.Constant;
import cz.cvut.fel.ida.logic.Function;
import cz.cvut.fel.ida.logic.Literal;
import cz.cvut.fel.ida.logic.PrologList;
import cz.cvut.fel.ida.logic.Term;
import cz.cvut.fel.ida.logic.Variable;
import cz.cvut.fel.ida.utils.generic.tuples.Pair;
import cz.cvut.fel.ida.utils.math.Sugar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LGG {
    private TermLGG termLGG = new BasicTermLGG();
    private LiteralLGG literalLGG = new BasicLiteralLGG();
    private List<LiteralFilter> literalFilters = Sugar.list(new BasicLiteralFilter());
    private List<LiteralPrunning> literalPrunnings = new ArrayList<LiteralPrunning>();

    public Clause lgg(Clause ... clauses) {
        Clause c = clauses[0];
        for (int i = 1; i < clauses.length; ++i) {
            c = this.lgg(c, clauses[i]);
        }
        return c;
    }

    public Clause lgg(Clause a, Clause b) {
        return new Lgg().lgg(a, b);
    }

    public void addLiteralFilter(LiteralFilter literalFilter) {
        this.literalFilters.add(literalFilter);
    }

    public List<LiteralFilter> getLiteralFilters() {
        return this.literalFilters;
    }

    public void addLiteralPrunning(LiteralPrunning literalPrunning) {
        this.literalPrunnings.add(literalPrunning);
    }

    public List<LiteralPrunning> getLiteralPrunnings() {
        return this.literalPrunnings;
    }

    public TermLGG getTermLGG() {
        return this.termLGG;
    }

    public void setTermLGG(TermLGG termLGG) {
        this.termLGG = termLGG;
    }

    public LiteralLGG getLiteralLGG() {
        return this.literalLGG;
    }

    public void setLiteralLGG(LiteralLGG literalLGG) {
        this.literalLGG = literalLGG;
    }

    public static class TemplateBasedLiteralFilter
    implements LiteralFilter {
        private final Pair<String, Integer> query = new Pair();
        private Map<Pair<String, Integer>, boolean[]> cannotBeVariableMap = new HashMap<Pair<String, Integer>, boolean[]>();

        public TemplateBasedLiteralFilter(String template) {
            Pair<String, Integer> queryPair = new Pair<String, Integer>();
            for (Literal l : Clause.parse(template).literals()) {
                if (this.isGlobalConstant(l)) continue;
                boolean[] cannotBeVariable = null;
                queryPair.set(l.predicateName(), l.arity());
                if (this.cannotBeVariableMap.containsKey(queryPair)) {
                    cannotBeVariable = this.cannotBeVariableMap.get(queryPair);
                } else {
                    cannotBeVariable = new boolean[l.arity()];
                    Arrays.fill(cannotBeVariable, true);
                    this.cannotBeVariableMap.put(new Pair<String, Integer>(l.predicateName(), l.arity()), cannotBeVariable);
                }
                for (int i = 0; i < l.arity(); ++i) {
                    if (!l.get(i).name().startsWith("#")) {
                        cannotBeVariable[i] = false;
                    }
                    if (!l.get(i).name().startsWith("$")) continue;
                    cannotBeVariable[i] = true;
                }
            }
        }

        private boolean isGlobalConstant(Literal l) {
            for (int i = 0; i < l.arity(); ++i) {
                if (!l.get(i).name().startsWith("@")) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean filter(Literal literal) {
            this.query.set(literal.predicateName(), literal.arity());
            boolean[] cannotBeVariable = this.cannotBeVariableMap.get(this.query);
            if (cannotBeVariable == null) {
                return false;
            }
            for (int i = 0; i < literal.arity(); ++i) {
                if (!cannotBeVariable[i] || !(literal.get(i) instanceof Variable)) continue;
                return false;
            }
            return true;
        }
    }

    public static class BasicLiteralLGG
    implements LiteralLGG {
        @Override
        public Literal lgg(Literal litA, Literal litB, TermLGG tlgg) {
            Literal c = null;
            if (litA.predicateName().equals(litB.predicateName()) && litA.arity() == litB.arity()) {
                c = new Literal(litA.predicateName(), litA.arity());
                for (int i = 0; i < c.arity(); ++i) {
                    Term ta = litA.get(i);
                    Term tb = litB.get(i);
                    if (!(ta instanceof Term) || !(tb instanceof Term)) continue;
                    c.set(tlgg.termLGG(ta, tb, c.predicateName(), c.arity(), i), i);
                }
            }
            return c;
        }
    }

    public static class BasicTermLGG
    implements TermLGG {
        private int variableIndex = 0;
        private Map<Pair<Term, Term>, Variable> usedVariables = new HashMap<Pair<Term, Term>, Variable>();
        private Set<Term> terms;

        public BasicTermLGG() {
        }

        public BasicTermLGG(Set<Term> terms) {
            this.terms = terms;
        }

        @Override
        public Term termLGG(Term a, Term b, String predicate, int arity, int argument) {
            if (a instanceof Function && b instanceof Function) {
                return this.functionLGG((Function)a, (Function)b);
            }
            if (a instanceof PrologList && b instanceof PrologList) {
                throw new UnsupportedOperationException("Lists not supported yet");
            }
            return this.otherLGG(a, b);
        }

        private Term functionLGG(Function a, Function b) {
            if (a.name().equals(b.name()) && a.arity() == b.arity()) {
                Function c = new Function(a.name(), a.arity());
                for (int i = 0; i < c.arity(); ++i) {
                    c.set(this.termLGG(a.get(i), b.get(i), c.name(), c.arity(), i), i);
                }
                return c;
            }
            return this.newVariable(a, b);
        }

        private Term otherLGG(Term a, Term b) {
            if (a instanceof Constant && b instanceof Constant && a.equals(b)) {
                return a;
            }
            return this.newVariable(a, b);
        }

        private Variable newVariable(Term a, Term b) {
            Pair<Term, Term> pa = new Pair<Term, Term>(a, b);
            if (this.usedVariables.containsKey(pa)) {
                return this.usedVariables.get(pa);
            }
            do {
                ++this.variableIndex;
            } while (this.terms.contains(Variable.construct("V" + this.variableIndex)));
            Variable newVariable = Variable.construct("V" + this.variableIndex);
            this.usedVariables.put(new Pair<Term, Term>(a, b), newVariable);
            this.terms.add(newVariable);
            return newVariable;
        }

        @Override
        public TermLGG constructNew(Set<Term> termsUsedInClauses) {
            return new BasicTermLGG(termsUsedInClauses);
        }
    }

    public static interface TermLGG {
        public TermLGG constructNew(Set<Term> var1);

        public Term termLGG(Term var1, Term var2, String var3, int var4, int var5);
    }

    public static class BasicLiteralFilter
    implements LiteralFilter {
        @Override
        public boolean filter(Literal literal) {
            return true;
        }
    }

    public static interface LiteralPrunning {
        public Clause prune(Clause var1);
    }

    public static interface LiteralFilter {
        public boolean filter(Literal var1);
    }

    public static interface LiteralLGG {
        public Literal lgg(Literal var1, Literal var2, TermLGG var3);
    }

    private class Lgg {
        private Lgg() {
        }

        public Clause lgg(Clause a, Clause b) {
            ArrayList<Literal> literals = new ArrayList<Literal>();
            TermLGG tlgg = LGG.this.getTermLGG().constructNew(Sugar.setFromCollections(a.terms(), b.terms()));
            for (Literal litA : a.literals()) {
                block1: for (Literal litB : b.literals()) {
                    Literal lLGG = LGG.this.getLiteralLGG().lgg(litA, litB, tlgg);
                    if (lLGG == null) continue;
                    for (LiteralFilter literalFilter : LGG.this.literalFilters) {
                        if (literalFilter.filter(lLGG)) continue;
                        continue block1;
                    }
                    literals.add(lLGG);
                }
            }
            Clause retVal = new Clause(literals);
            for (LiteralPrunning literalPrunning : LGG.this.literalPrunnings) {
                retVal = literalPrunning.prune(retVal);
            }
            return retVal;
        }
    }
}

