/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic;

import cz.cvut.fel.ida.logic.Constant;
import cz.cvut.fel.ida.logic.Function;
import cz.cvut.fel.ida.logic.ParserUtils;
import cz.cvut.fel.ida.logic.Predicate;
import cz.cvut.fel.ida.logic.Term;
import cz.cvut.fel.ida.logic.Variable;
import cz.cvut.fel.ida.utils.generic.tuples.Pair;
import cz.cvut.fel.ida.utils.math.UniqueIDs;
import cz.cvut.fel.ida.utils.math.collections.FakeMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class Literal
implements Serializable {
    private static final Logger LOG = Logger.getLogger(Literal.class.getName());
    private Term[] terms;
    private Predicate predicate;
    private boolean negated = false;
    private int id;
    private int hashCode = -1;
    private boolean changePermitted = true;
    private static Map<Variable, Variable> fakeMapVar = new FakeMap<Variable, Variable>();
    private static Map<Constant, Constant> fakeMapConst = new FakeMap<Constant, Constant>();

    public Literal() {
        this.predicate = new Predicate("", 0);
    }

    public Literal(Predicate predicate) {
        this.predicate = predicate;
        this.id = (int)UniqueIDs.getUniqueName();
        this.terms = new Term[predicate.arity];
    }

    public Literal(String name, int arity) {
        this.id = (int)UniqueIDs.getUniqueName();
        this.terms = new Term[arity];
        this.predicate = new Predicate(name, arity);
    }

    public Literal(String name, Term ... terms) {
        this(name, terms.length);
        this.set(terms);
    }

    public Literal(String name, List<? extends Term> terms) {
        this.id = (int)UniqueIDs.getUniqueName();
        this.terms = new Term[terms.size()];
        System.arraycopy(terms.toArray(), 0, this.terms, 0, terms.size());
        this.predicate = new Predicate(name, terms.size());
    }

    public Literal(String name, boolean negated, int arity) {
        this(name, arity);
        this.negated = negated;
    }

    public Literal(String name, boolean negated, Term ... terms) {
        this(name, terms);
        this.negated = negated;
    }

    public Literal(String name, boolean negated, List<Term> terms) {
        this(name, terms);
        this.negated = negated;
    }

    public Literal(Predicate predicate, boolean negated, List<? extends Term> terms) {
        this(predicate);
        if (predicate.arity != terms.size()) {
            LOG.severe("Arity mismatch while creating a literal from predicate+terms");
        }
        System.arraycopy(terms.toArray(), 0, this.terms, 0, terms.size());
        this.negated = negated;
    }

    public Term get(int index) {
        return this.terms[index];
    }

    public void allowModifications(boolean allow) {
        this.changePermitted = allow;
    }

    public void set(Term term, int index) {
        if (!this.changePermitted) {
            throw new IllegalStateException("This particular literal has been locked for changes. Create new instance and change it.");
        }
        this.hashCode = -1;
        this.terms[index] = term;
    }

    public void set(Term ... terms) {
        for (int i = 0; i < terms.length; ++i) {
            this.set(terms[i], i);
        }
    }

    public void setTerms(Term[] terms) {
        this.terms = terms;
    }

    public int arity() {
        return this.terms.length;
    }

    public int countConstants() {
        int count = 0;
        for (int i = 0; i < this.terms.length; ++i) {
            if (!(this.terms[i] instanceof Constant)) continue;
            ++count;
        }
        return count;
    }

    public String predicateName() {
        return this.predicate.name;
    }

    public Predicate predicate() {
        return this.predicate;
    }

    public static Literal parseLiteral(String str) {
        return Literal.parseLiteral(str, fakeMapVar, fakeMapConst);
    }

    public static Literal parseLiteral(String str, Map<Variable, Variable> variables, Map<Constant, Constant> constants) {
        char[] c = str.toCharArray();
        StringBuilder predicateName = new StringBuilder();
        ArrayList<Term> arguments = new ArrayList<Term>(5);
        int index = 0;
        boolean inQuotes = false;
        boolean inDoubleQuotes = false;
        boolean ignoreNext = false;
        while (true) {
            if (c[index] == '\\' && !ignoreNext) {
                ignoreNext = true;
            } else {
                if (!(inQuotes || inDoubleQuotes || c[index] != '\'' || ignoreNext)) {
                    predicateName.append(c[index]);
                    inQuotes = true;
                } else if (!(inQuotes || inDoubleQuotes || c[index] != '\"' || ignoreNext)) {
                    predicateName.append(c[index]);
                    inDoubleQuotes = true;
                } else if (inQuotes && c[index] == '\'' && !ignoreNext) {
                    predicateName.append(c[index]);
                    inQuotes = false;
                } else if (inDoubleQuotes && c[index] == '\"' && !ignoreNext) {
                    predicateName.append(c[index]);
                    inDoubleQuotes = false;
                } else {
                    if (!inQuotes && !inDoubleQuotes && c[index] == '(') break;
                    predicateName.append(c[index]);
                }
                ignoreNext = false;
            }
            ++index;
        }
        boolean negated = false;
        String predicateNameString = predicateName.toString().trim();
        if (predicateNameString.startsWith("!")) {
            predicateNameString = predicateNameString.substring(1);
            negated = true;
        }
        inQuotes = false;
        ignoreNext = false;
        while (index < c.length && c[index] != ')') {
            if (c[index] != '(' && !Character.isSpaceChar(c[index])) {
                Pair<Term, Integer> pair = ParserUtils.parseTerm(c, index, ')', variables, constants);
                arguments.add((Term)pair.r);
                index = (Integer)pair.s;
            }
            ++index;
        }
        Literal retVal = new Literal(predicateNameString, negated, arguments.size());
        for (int i = 0; i < retVal.arity(); ++i) {
            retVal.set((Term)arguments.get(i), i);
        }
        return retVal;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.negated) {
            sb.append("!");
        }
        sb.append(this.predicate.name);
        if (this.terms.length > 0) {
            sb.append("(");
            for (Term t : this.terms) {
                sb.append(t).append(", ");
            }
            if (sb.charAt(sb.length() - 2) == ',') {
                sb.delete(sb.length() - 2, sb.length());
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Literal)) {
            return false;
        }
        Literal other = (Literal)o;
        if (other.negated != this.negated) {
            return false;
        }
        if (other.terms.length != this.terms.length) {
            return false;
        }
        if (!other.predicate.name.equals(this.predicate.name)) {
            return false;
        }
        for (int i = 0; i < this.terms.length; ++i) {
            if (this.terms[i].equals(other.terms[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hashCode != -1) {
            return this.hashCode;
        }
        int hash = this.predicate.name.hashCode();
        for (int i = 0; i < this.terms.length; ++i) {
            hash = (int)((long)this.terms[i].hashCode() * (long)hash);
        }
        this.hashCode = hash *= this.negated ? -1 : 1;
        return this.hashCode;
    }

    public int liftedHashCode() {
        int hash = this.predicate.name.hashCode();
        for (int i = 0; i < this.terms.length; ++i) {
            long varcode = this.terms[i] instanceof Variable ? 7L : (long)this.terms[i].hashCode();
            hash = (int)(varcode * (long)hash);
        }
        return hash;
    }

    public int id() {
        return this.id;
    }

    public boolean containsVariable() {
        for (Term t : this.terms) {
            if (!(t instanceof Variable)) continue;
            return true;
        }
        return false;
    }

    public boolean containsConstant() {
        for (Term t : this.terms) {
            if (!(t instanceof Constant)) continue;
            return true;
        }
        return false;
    }

    public Set<Term> terms() {
        HashSet<Term> set = new HashSet<Term>();
        for (Term t : this.terms) {
            set.add(t);
        }
        return set;
    }

    public Term[] arguments() {
        return this.terms;
    }

    public List<Term> termList() {
        return Arrays.asList(this.terms);
    }

    public Function toFunction() {
        Function f = new Function(this.predicate.name, this.arity());
        for (int i = 0; i < f.arity(); ++i) {
            f.set(this.get(i), i);
        }
        return f;
    }

    public Literal emptyCopy() {
        Literal p = new Literal();
        p.predicate = this.predicate;
        p.terms = new Term[this.terms.length];
        p.negated = this.negated;
        p.hashCode = -1;
        return p;
    }

    @Deprecated
    public Literal subsCopy(Map<? extends Term, ? extends Term> substitution) {
        Literal copy = this.emptyCopy();
        copy.hashCode = -1;
        for (int j = 0; j < this.arity(); ++j) {
            if (!substitution.containsKey(copy.get(j))) continue;
            copy.set(substitution.get(this.get(j)), j);
        }
        return copy;
    }

    public Literal subsCopy(Term[] substitution) {
        Literal copy = this.emptyCopy();
        for (int j = 0; j < this.arity(); ++j) {
            int indexWithinSubstitution = this.terms[j].getIndexWithinSubstitution();
            copy.terms[j] = indexWithinSubstitution >= 0 ? substitution[indexWithinSubstitution] : this.terms[j];
        }
        return copy;
    }

    public Literal negation() {
        return new Literal(this.predicate.name, !this.negated, this.terms);
    }

    public boolean isNegated() {
        return this.negated;
    }

    public Literal maskTerms(int[] maskedTerms) {
        ArrayList<Term> terms = new ArrayList<Term>(this.termList());
        for (int index : maskedTerms) {
            terms.set(index, Constant.construct("_"));
        }
        return new Literal(this.predicate, this.negated, terms);
    }
}

