/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic;

import cz.cvut.fel.ida.logic.Term;
import cz.cvut.fel.ida.utils.generic.tuples.Pair;
import cz.cvut.fel.ida.utils.math.Cache;

public class Variable
implements Term {
    private String type;
    private String name;
    private String toString;
    private int indexWithinSubstitution = -1;
    private int hashCode = Integer.MIN_VALUE;
    private static Cache<String, Variable> cache = new Cache();
    private static Cache<Pair<String, String>, Variable> cache2 = new Cache();

    protected Variable(String name) {
        this.toString = this.name = name.trim().intern();
    }

    private Variable(String name, String type) {
        this(name);
        this.type = type;
        this.toString = type + ":" + name;
    }

    public static Variable construct(String name) {
        Variable retVal = cache.get(name);
        if (retVal == null) {
            retVal = new Variable(name);
            cache.put(name, retVal);
        }
        return retVal;
    }

    public static Variable construct(String name, String type) {
        if (type == null) {
            return Variable.construct(name);
        }
        Pair<String, String> queryPair = new Pair<String, String>(name, type);
        Variable retVal = cache2.get(queryPair);
        if (retVal == null) {
            retVal = new Variable(name, type);
            cache2.put(queryPair, retVal);
        }
        return retVal;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return this.toString;
    }

    public boolean equals(Object o) {
        if (o instanceof Variable) {
            Variable v = (Variable)o;
            return !(o != this && (!v.name.equals(this.name) || v.type == null && this.type != null || v.type != null && this.type == null || v.type != this.type && !v.type.equals(this.type)));
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode != Integer.MIN_VALUE) {
            return this.hashCode;
        }
        return this.type == null ? (this.hashCode = this.name.hashCode()) : (this.hashCode = this.toString.hashCode());
    }

    public static void clearCache() {
        cache.clear();
        cache2.clear();
    }

    @Override
    public int getIndexWithinSubstitution() {
        return this.indexWithinSubstitution;
    }

    @Override
    public void setIndexWithinSubstitution(int indexWithinSubstitution) {
        this.indexWithinSubstitution = indexWithinSubstitution;
    }
}

