/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.constructs;

import cz.cvut.fel.ida.algebra.functions.Combination;
import cz.cvut.fel.ida.algebra.functions.Transformation;
import cz.cvut.fel.ida.logic.Literal;
import cz.cvut.fel.ida.logic.Predicate;
import cz.cvut.fel.ida.logic.Term;
import cz.cvut.fel.ida.logic.constructs.WeightedPredicate;
import cz.cvut.fel.ida.utils.exporting.Exportable;
import java.util.List;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Atom
implements Exportable {
    private static final Logger LOG = Logger.getLogger(Atom.class.getName());
    @NotNull
    public WeightedPredicate offsettedPredicate;
    @NotNull
    public Literal literal;
    @Nullable
    public Combination combination;
    @Nullable
    public Transformation transformation;
    @Nullable
    public String originalString;
    public boolean dropout;

    public Atom(WeightedPredicate weightedPredicate, List<Term> terms, boolean negated) {
        if (weightedPredicate.predicate.arity != terms.size()) {
            LOG.severe("Predicate arity and terms size mismatch while creating an Atom");
        }
        this.offsettedPredicate = weightedPredicate;
        this.literal = new Literal(weightedPredicate.predicate, negated, terms);
        this.combination = weightedPredicate.combination;
        this.transformation = weightedPredicate.transformation;
    }

    public Atom(Atom another) {
        this.offsettedPredicate = another.offsettedPredicate;
        this.literal = another.literal;
        this.combination = another.combination;
        this.transformation = another.transformation;
        this.originalString = another.originalString;
        this.dropout = another.dropout;
    }

    public Predicate getPredicate() {
        return this.literal.predicate();
    }

    @NotNull
    public WeightedPredicate getOffsettedPredicate() {
        return this.offsettedPredicate;
    }

    public boolean isNegated() {
        return this.literal.isNegated();
    }

    @NotNull
    public Literal getLiteral() {
        return this.literal;
    }

    public int hashCode() {
        return this.literal.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Atom)) {
            return false;
        }
        Atom other = (Atom)obj;
        return this.literal.equals(other.literal);
    }

    public String toString() {
        return this.literal.toString();
    }

    public Transformation getTransformation() {
        if (this.transformation != null) {
            return this.transformation;
        }
        if (this.offsettedPredicate.transformation != null) {
            return this.offsettedPredicate.transformation;
        }
        return null;
    }

    public Combination getCombination() {
        if (this.combination != null) {
            return this.combination;
        }
        if (this.offsettedPredicate.combination != null) {
            return this.offsettedPredicate.combination;
        }
        return null;
    }
}

