/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.constructs.building;

import cz.cvut.fel.ida.logic.constructs.Conjunction;
import cz.cvut.fel.ida.logic.constructs.building.SamplesBuilder;
import cz.cvut.fel.ida.logic.constructs.example.LiftedExample;
import cz.cvut.fel.ida.logic.constructs.example.LogicSample;
import cz.cvut.fel.ida.logic.constructs.example.ValuedFact;
import cz.cvut.fel.ida.logic.parsing.antlr.NeuralogicParser;
import cz.cvut.fel.ida.logic.parsing.examples.PlainExamplesParseTree;
import cz.cvut.fel.ida.logic.parsing.examples.PlainExamplesParseTreeExtractor;
import cz.cvut.fel.ida.logic.parsing.grammarParsing.PlainGrammarVisitor;
import cz.cvut.fel.ida.setup.Settings;
import cz.cvut.fel.ida.utils.generic.Pair;
import java.io.IOException;
import java.io.Reader;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class ExamplesBuilder
extends SamplesBuilder<PlainExamplesParseTree, Pair<Conjunction, LiftedExample>> {
    private static final Logger LOG = Logger.getLogger(ExamplesBuilder.class.getName());

    public ExamplesBuilder(Settings settings) {
        super(settings);
    }

    @Override
    public PlainExamplesParseTree parseTreeFrom(Reader reader) {
        try {
            return new PlainExamplesParseTree(reader);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Stream<Pair<Conjunction, LiftedExample>> buildFrom(PlainExamplesParseTree parseTree) {
        PlainGrammarVisitor plainGrammarVisitor = new PlainGrammarVisitor(this);
        LOG.info("Creating a parse tree from input examples file...");
        PlainExamplesParseTreeExtractor examplesParseTreeExtractor = new PlainExamplesParseTreeExtractor(plainGrammarVisitor);
        NeuralogicParser.ExamplesFileContext examplesFileContext = parseTree.getRoot();
        this.inferInputFormatSettings(examplesFileContext);
        Stream<Pair<Conjunction, LiftedExample>> labeledExamples = examplesParseTreeExtractor.getLabeledExamples(examplesFileContext);
        labeledExamples.onClose(() -> LOG.info("Closing input example parsing stream"));
        return labeledExamples;
    }

    @Override
    public Stream<LogicSample> sampleFrom(Pair<Conjunction, LiftedExample> pair) {
        LiftedExample example = (LiftedExample)pair.s;
        if (pair.r == null || ((Conjunction)pair.r).facts == null || ((Conjunction)pair.r).facts.size() == 0) {
            return Stream.of(this.createUnlabeledSample(String.valueOf(this.queryCounter), example));
        }
        if (((Conjunction)pair.r).facts.size() == 1 && ((Conjunction)pair.r).facts.get(0).getValue() == null) {
            ValuedFact query2 = ((Conjunction)pair.r).facts.get(0);
            return Stream.of(new LogicSample(null, this.createQueryAtom(query2.literal.toString(), query2, example)));
        }
        if (((Conjunction)pair.r).facts.size() == 1 && ((Conjunction)pair.r).facts.get(0).getValue() != null) {
            ValuedFact query3 = ((Conjunction)pair.r).facts.get(0);
            return Stream.of(new LogicSample(query3.getValue(), this.createQueryAtom(String.valueOf(this.queryCounter), query3, example))).peek(s -> LOG.fine("New Sample created " + s.toString()));
        }
        String minibatch = String.valueOf(this.queryCounter);
        return ((Conjunction)pair.r).facts.stream().map(query -> new LogicSample(query.getValue(), this.createQueryAtom(this.settings.queriesBatchPrefix + minibatch, (ValuedFact)query, example))).peek(s -> LOG.fine("New Batch Sample created " + s.toString()));
    }

    private LogicSample createUnlabeledSample(String id, LiftedExample example) {
        return new LogicSample(null, this.createQueryAtom(id, null, example));
    }

    private void inferInputFormatSettings(NeuralogicParser.ExamplesFileContext examplesFileContext) {
        if (examplesFileContext.liftedExample().size() == 0) {
            LOG.warning("There are no examples in the example source (file)!");
            LOG.severe("Problem with parsing the examples");
            System.exit(4);
        } else if (examplesFileContext.liftedExample().size() == 1) {
            LOG.fine("Detecting exactly 1 (big) example in the examples source (file), switching to knowledge-base mode.");
            if (this.settings.groundingMode != Settings.GroundingMode.GLOBAL) {
                this.settings.groundingMode = Settings.GroundingMode.GLOBAL;
                this.settings.infer();
                LOG.warning("Settings were set to a different grounding mode than detected! Will perform online rebuild of the grounding pipeline to the GLOBAL mode!");
                this.rebuildCallback.apply("GroundingPipeline");
            }
        } else {
            LOG.fine("Detecting multiple individual examples in the examples source (file), assuming independent graph mode");
            this.settings.queriesAlignedWithExamples = true;
            if (this.settings.groundingMode != Settings.GroundingMode.INDEPENDENT) {
                this.settings.groundingMode = Settings.GroundingMode.INDEPENDENT;
                this.settings.infer();
                LOG.warning("Settings were set to a different grounding mode than detected! Will perform online rebuild of the grounding pipeline to the STANDARD mode!");
                this.rebuildCallback.apply("GroundingPipeline");
            }
        }
        if (examplesFileContext.label() != null && !examplesFileContext.label().isEmpty()) {
            this.settings.queriesAlignedWithExamples = false;
            LOG.fine("Detecting examples to have ids/queries with them.");
        }
    }
}

