/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.constructs.building.factories;

import cz.cvut.fel.ida.logic.Variable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class VariableFactory {
    private static final Logger LOG = Logger.getLogger(VariableFactory.class.getName());
    private Map<String, Variable> str2var;
    private Map<Variable, Variable> var2var;

    public VariableFactory() {
        this.str2var = new HashMap<String, Variable>();
        this.var2var = new HashMap<Variable, Variable>();
    }

    public VariableFactory(Collection<Variable> vars) {
        this.str2var = vars.stream().collect(Collectors.toMap(Variable::toString, Function.identity()));
        this.var2var = vars.stream().collect(Collectors.toMap(Function.identity(), Function.identity()));
    }

    public Variable construct(String name, String type) {
        Variable result = this.str2var.get(name);
        if (result == null) {
            result = Variable.construct(name, type);
            this.str2var.put(name, result);
            this.var2var.put(result, result);
        } else {
            result.setType(type);
        }
        return result;
    }

    public Variable construct(String from) {
        if (from.contains(":")) {
            String[] split = from.split(":");
            return this.construct(split[1], split[0]);
        }
        Variable result = this.str2var.get(from);
        if (result == null) {
            result = Variable.construct(from);
            this.str2var.put(from, result);
            this.var2var.put(result, result);
        }
        return result;
    }

    public Variable construct(Variable from) {
        Variable result = this.var2var.get(from);
        if (result == null) {
            this.str2var.put(result.toString(), result);
            this.var2var.put(result, result);
        }
        return from;
    }
}

