/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.constructs.template;

import cz.cvut.fel.ida.algebra.values.Value;
import cz.cvut.fel.ida.algebra.weights.Weight;
import cz.cvut.fel.ida.learning.Model;
import cz.cvut.fel.ida.logic.HornClause;
import cz.cvut.fel.ida.logic.Literal;
import cz.cvut.fel.ida.logic.constructs.Atom;
import cz.cvut.fel.ida.logic.constructs.Conjunction;
import cz.cvut.fel.ida.logic.constructs.example.QueryAtom;
import cz.cvut.fel.ida.logic.constructs.example.ValuedFact;
import cz.cvut.fel.ida.logic.constructs.template.components.BodyAtom;
import cz.cvut.fel.ida.logic.constructs.template.components.HeadAtom;
import cz.cvut.fel.ida.logic.constructs.template.components.WeightedRule;
import cz.cvut.fel.ida.logic.constructs.template.types.GraphTemplate;
import cz.cvut.fel.ida.logic.subsumption.HerbrandModel;
import cz.cvut.fel.ida.utils.exporting.Exportable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class Template
implements Model<QueryAtom>,
Exportable {
    private static final Logger LOG = Logger.getLogger(Template.class.getName());
    static int counter = 0;
    protected String name = "template" + counter++;
    public LinkedHashSet<WeightedRule> rules;
    public LinkedHashSet<ValuedFact> facts;
    @Nullable
    public LinkedHashSet<Conjunction> constraints;
    public boolean containsNegation = false;
    public transient HerbrandModel herbrandModel;
    @Nullable
    public transient Set<Literal> inferredAtoms;
    @Nullable
    private transient Set<Literal> allAtoms;
    @Nullable
    public transient Map<HornClause, List<WeightedRule>> hornClauses;

    public Template() {
        this.rules = new LinkedHashSet();
        this.facts = new LinkedHashSet();
        this.constraints = new LinkedHashSet();
    }

    public Template(Template other) {
        this.rules = other.rules;
        this.facts = other.facts;
        this.constraints = other.constraints;
        this.containsNegation = other.containsNegation;
    }

    public Template(List<WeightedRule> rules, List<ValuedFact> facts) {
        this();
        this.rules.addAll(rules);
        this.facts.addAll(facts);
    }

    public void addConstraints(List<Conjunction> constr) {
        this.constraints = new LinkedHashSet<Conjunction>(constr);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Value evaluate(QueryAtom query) {
        return null;
    }

    @Override
    public List<Weight> getAllWeights() {
        ArrayList<Weight> weightList = new ArrayList<Weight>();
        for (WeightedRule rule : this.rules) {
            Weight headOffset;
            Weight offset;
            if (rule.getWeight() != null) {
                weightList.add(rule.getWeight());
            }
            if ((offset = rule.getOffset()) != null) {
                offset.isOffset = true;
                weightList.add(offset);
            }
            if ((headOffset = rule.getHead().getOffset()) != null) {
                headOffset.isOffset = true;
                weightList.add(headOffset);
            }
            for (BodyAtom bodyAtom : rule.getBody()) {
                if (bodyAtom.getConjunctWeight() == null) continue;
                weightList.add(bodyAtom.getConjunctWeight());
            }
        }
        for (ValuedFact fact : this.facts) {
            if (fact.weight == null) continue;
            weightList.add(fact.weight);
        }
        List<Weight> uniqueWeights = this.filterUnique(weightList);
        return uniqueWeights;
    }

    private List<Weight> filterUnique(List<Weight> weightList) {
        return weightList.stream().distinct().collect(Collectors.toList());
    }

    public void updateWeightsFrom(Map<Integer, Weight> neuralWeights) {
        List<Weight> templateWeights = this.getAllWeights();
        for (Weight weight : templateWeights) {
            if (!weight.isLearnable()) continue;
            weight.value = neuralWeights.get((Object)Integer.valueOf((int)weight.index)).value;
        }
    }

    public Set<Literal> getAllAtoms(boolean inferAtoms) {
        if (this.allAtoms != null) {
            return this.allAtoms;
        }
        this.allAtoms = this.facts.stream().map(Atom::getLiteral).collect(Collectors.toSet());
        if (this.inferredAtoms == null) {
            this.preprocessInference(inferAtoms);
        }
        this.allAtoms.addAll(this.inferredAtoms);
        return this.allAtoms;
    }

    public void setFacts(LinkedHashSet<ValuedFact> facts) {
        this.facts = facts;
    }

    public void preprocessInference(boolean inferAtoms) {
        if (this.inferredAtoms == null) {
            this.inferredAtoms = new HashSet<Literal>();
        }
        Iterator iterator = this.facts.iterator();
        while (iterator.hasNext()) {
            ValuedFact fact = (ValuedFact)iterator.next();
            if (!fact.literal.containsVariable()) continue;
            iterator.remove();
            WeightedRule weightedRule = new WeightedRule();
            weightedRule.setOriginalString(fact.originalString);
            HeadAtom headAtom = new HeadAtom(fact.offsettedPredicate, fact.literal.termList());
            weightedRule.setHead(headAtom);
            weightedRule.setWeight(fact.weight);
            weightedRule.setHashCode(headAtom.hashCode());
            weightedRule.setBody(new LinkedList<BodyAtom>());
            this.rules.add(weightedRule);
        }
        LinkedHashSet facts = this.facts.stream().map(Atom::getLiteral).collect(Collectors.toCollection(LinkedHashSet::new));
        LinkedHashSet rules = this.rules.stream().map(WeightedRule::toHornClause).collect(Collectors.toCollection(LinkedHashSet::new));
        this.herbrandModel = new HerbrandModel(facts, rules);
        if (inferAtoms) {
            Collection<Literal> atoms = this.herbrandModel.inferAtoms();
            this.inferredAtoms.addAll(atoms);
        }
    }

    public GraphTemplate prune(QueryAtom query) {
        LOG.warning("Inefficient template pruning");
        return new GraphTemplate(this).prune(query);
    }

    public void addAllFrom(Template template) {
        if (template == this) {
            return;
        }
        this.rules.addAll(template.rules);
        this.facts.addAll(template.facts);
        this.constraints.addAll(template.constraints);
    }

    public String toString() {
        return this.name + ":= rules: " + this.rules.size() + ", facts: " + this.facts.size() + ", constraints: " + this.constraints.size();
    }
}

