/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.constructs.template.components;

import cz.cvut.fel.ida.algebra.functions.Aggregation;
import cz.cvut.fel.ida.algebra.functions.Combination;
import cz.cvut.fel.ida.algebra.functions.Transformation;
import cz.cvut.fel.ida.algebra.weights.Weight;
import cz.cvut.fel.ida.logic.Clause;
import cz.cvut.fel.ida.logic.HornClause;
import cz.cvut.fel.ida.logic.Literal;
import cz.cvut.fel.ida.logic.Term;
import cz.cvut.fel.ida.logic.constructs.template.components.BodyAtom;
import cz.cvut.fel.ida.logic.constructs.template.components.GroundHeadRule;
import cz.cvut.fel.ida.logic.constructs.template.components.GroundRule;
import cz.cvut.fel.ida.logic.constructs.template.components.HeadAtom;
import cz.cvut.fel.ida.logic.constructs.template.metadata.RuleMetadata;
import cz.cvut.fel.ida.utils.exporting.Exportable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class WeightedRule
implements Exportable {
    boolean isEditable = false;
    private Weight weight;
    private Weight offset;
    private HeadAtom head;
    private List<BodyAtom> body;
    private Combination combinationFcn;
    private Transformation transformationFcn;
    private Aggregation aggregationFcn;
    public boolean allowDuplicitGroundings = false;
    private RuleMetadata metadata;
    private String originalString;
    private int hashCode = -1;

    public WeightedRule() {
    }

    public WeightedRule(WeightedRule other) {
        this.setWeight(other.getWeight());
        this.setHead(other.getHead());
        this.setBody(new ArrayList<BodyAtom>(other.getBody().size()));
        this.getBody().addAll(other.getBody());
        this.setOffset(other.getOffset());
        this.setAggregationFcn(other.getAggregationFcn());
        this.setTransformation(other.getTransformation());
        this.setCombination(other.getCombination());
        this.setMetadata(other.getMetadata());
        this.setOriginalString(other.getOriginalString());
        this.isEditable = other.isEditable;
    }

    public HornClause toHornClause() {
        List collected = this.getBody().stream().map(bodyLit -> bodyLit.getLiteral()).collect(Collectors.toList());
        return new HornClause(this.getHead().getLiteral(), new Clause(collected));
    }

    public GroundRule groundRule(Term[] terms) {
        Literal groundHead = this.head.literal.subsCopy(terms);
        int size = this.getBody().size();
        ArrayList<Literal> groundBody = new ArrayList<Literal>(size);
        for (BodyAtom atom : this.getBody()) {
            Literal literal = atom.literal;
            if (literal.predicate().hidden || literal.isNegated()) continue;
            groundBody.add(literal.subsCopy(terms));
        }
        GroundRule groundRule = new GroundRule(this, groundHead, groundBody.toArray(new Literal[groundBody.size()]));
        return groundRule;
    }

    public GroundHeadRule groundHeadRule(Literal groundHead) {
        GroundHeadRule groundRule = new GroundHeadRule(this, groundHead);
        return groundRule;
    }

    public String signatureString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHead().getPredicate()).append(":-");
        for (BodyAtom bodyAtom : this.getBody()) {
            sb.append(bodyAtom.getPredicate()).append(",");
        }
        return sb.toString();
    }

    public boolean detectWeights() {
        boolean hasWeights = this.hasOffset();
        for (BodyAtom bodyAtom : this.getBody()) {
            if (bodyAtom.weight == null) continue;
            hasWeights = true;
        }
        if (hasWeights) {
            for (BodyAtom bodyAtom : this.getBody()) {
                if (bodyAtom.weight != null) continue;
                bodyAtom.weight = Weight.unitWeight;
            }
        }
        return hasWeights;
    }

    public int hashCode() {
        if (this.hashCode != -1) {
            return this.hashCode;
        }
        this.hashCode = this.head.hashCode() + this.body.hashCode();
        return this.hashCode;
    }

    public void setHashCode(int hashCode) {
        this.hashCode = hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof WeightedRule)) {
            return false;
        }
        WeightedRule other = (WeightedRule)obj;
        if (this.getWeight() == null && other.getWeight() != null || this.getWeight() != null && other.getWeight() == null) {
            return false;
        }
        if (this.getOffset() == null && other.getOffset() != null || this.getOffset() != null && other.getOffset() == null) {
            return false;
        }
        if (this.getWeight() != null && !this.getWeight().equals(other.getWeight()) || this.getOffset() != null && !this.getOffset().equals(other.getOffset())) {
            return false;
        }
        if (this.getAggregationFcn() != null && !this.getAggregationFcn().equals(other.getAggregationFcn()) || this.getTransformation() != null && !this.getTransformation().equals(other.getTransformation()) || this.getCombination() != null && !this.getCombination().equals(other.getCombination())) {
            return false;
        }
        return this.getHead().equals(other.getHead()) && this.getBody().equals(other.getBody());
    }

    public String toRuleNeuronString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHead().toString()).append(":-");
        for (BodyAtom bodyAtom : this.getBody()) {
            sb.append(bodyAtom.toString()).append(",");
        }
        sb.setCharAt(sb.length() - 1, '.');
        return sb.toString();
    }

    public Weight getWeight() {
        return this.weight;
    }

    public void setWeight(Weight weight) {
        this.weight = weight;
    }

    public boolean hasOffset() {
        return this.offset != null;
    }

    public Weight getOffset() {
        return this.offset;
    }

    public void setOffset(Weight offset) {
        this.offset = offset;
    }

    public HeadAtom getHead() {
        return this.head;
    }

    public void setHead(HeadAtom head) {
        this.head = head;
    }

    public List<BodyAtom> getBody() {
        return this.body;
    }

    public void setBody(List<BodyAtom> body) {
        this.body = body;
    }

    public Aggregation getAggregationFcn() {
        return this.aggregationFcn;
    }

    public void setAggregationFcn(Aggregation aggregationFcn) {
        this.aggregationFcn = aggregationFcn;
    }

    public Transformation getTransformation() {
        return this.transformationFcn;
    }

    public void setTransformation(Transformation transformation) {
        this.transformationFcn = transformation;
    }

    public Combination getCombination() {
        return this.combinationFcn;
    }

    public void setCombination(Combination combinationFcn) {
        this.combinationFcn = combinationFcn;
    }

    public RuleMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(RuleMetadata metadata) {
        this.metadata = metadata;
    }

    public String getOriginalString() {
        return this.originalString;
    }

    public void setOriginalString(String originalString) {
        this.originalString = originalString;
    }
}

