/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.constructs.template.metadata;

import cz.cvut.fel.ida.algebra.functions.Combination;
import cz.cvut.fel.ida.algebra.functions.Transformation;
import cz.cvut.fel.ida.algebra.utils.metadata.Metadata;
import cz.cvut.fel.ida.algebra.utils.metadata.Parameter;
import cz.cvut.fel.ida.algebra.utils.metadata.ParameterValue;
import cz.cvut.fel.ida.algebra.values.Value;
import cz.cvut.fel.ida.algebra.weights.Weight;
import cz.cvut.fel.ida.logic.constructs.WeightedPredicate;
import cz.cvut.fel.ida.setup.Settings;
import java.util.Map;
import java.util.logging.Logger;

public class PredicateMetadata
extends Metadata<WeightedPredicate> {
    private static final Logger LOG = Logger.getLogger(PredicateMetadata.class.getName());

    public PredicateMetadata(Settings settings, Map<String, Object> pairs) {
        super(settings, pairs);
    }

    @Override
    public boolean addValidateMetadatum(String parameterText, Object value) {
        Settings.CombinationFcn combinationFcn;
        Combination function;
        Parameter parameter = new Parameter(parameterText);
        ParameterValue parameterValue = new ParameterValue(value);
        boolean valid = false;
        if (parameter.type == Parameter.Type.OFFSET && (parameterValue.type == ParameterValue.Type.VALUE || parameterValue.type == ParameterValue.Type.WEIGHT)) {
            valid = true;
        } else if (parameter.type == Parameter.Type.TRANSFORMATION && parameterValue.type == ParameterValue.Type.STRING) {
            Settings.TransformationFcn transformationFcn = Settings.parseTransformation(parameterValue.stringValue);
            Transformation function2 = Transformation.getFunction(transformationFcn);
            if (function2 != null) {
                valid = true;
                parameterValue.value = function2;
            }
        } else if (parameter.type == Parameter.Type.COMBINATION && parameterValue.type == ParameterValue.Type.STRING && (function = Combination.getFunction(combinationFcn = Settings.parseCombination(parameterValue.stringValue))) != null) {
            valid = true;
            parameterValue.value = function;
        }
        if (valid) {
            this.metadata.put(parameter, parameterValue);
        } else {
            LOG.warning("Invalid metadata context:" + parameterText + "=" + String.valueOf(value));
        }
        return true;
    }

    @Override
    public void applyTo(WeightedPredicate object) {
        this.metadata.forEach((param, value) -> this.apply(object, (Parameter)param, (ParameterValue)value));
    }

    private void apply(WeightedPredicate predicate, Parameter param, ParameterValue value) {
        if (param.type == Parameter.Type.TRANSFORMATION) {
            predicate.transformation = (Transformation)value.value;
        } else if (param.type == Parameter.Type.COMBINATION) {
            predicate.combination = (Combination)value.value;
        } else if (param.type == Parameter.Type.OFFSET) {
            if (value.value instanceof Weight) {
                predicate.weight = (Weight)value.value;
            } else if (value.value instanceof Value) {
                predicate.weight = new Weight(-1, "metaOffset", (Value)value.value, false, true);
            }
        }
    }

    public void addAll(PredicateMetadata predicateMetadata) {
        this.metadata.putAll(predicateMetadata.metadata);
    }

    public void addMetadata(PredicateMetadata predicateMetadata) {
        if (this.metadata == null) {
            this.metadata = predicateMetadata.metadata;
        } else {
            this.metadata.putAll(predicateMetadata.metadata);
        }
    }
}

