/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.constructs.template.metadata;

import cz.cvut.fel.ida.algebra.functions.Aggregation;
import cz.cvut.fel.ida.algebra.functions.Combination;
import cz.cvut.fel.ida.algebra.functions.Transformation;
import cz.cvut.fel.ida.algebra.utils.metadata.Metadata;
import cz.cvut.fel.ida.algebra.utils.metadata.Parameter;
import cz.cvut.fel.ida.algebra.utils.metadata.ParameterValue;
import cz.cvut.fel.ida.logic.constructs.template.components.WeightedRule;
import cz.cvut.fel.ida.setup.Settings;
import java.util.Map;
import java.util.logging.Logger;

public class RuleMetadata
extends Metadata<WeightedRule> {
    private static final Logger LOG = Logger.getLogger(RuleMetadata.class.getName());

    public RuleMetadata(Settings settings, Map<String, Object> stringObjectMap) {
        super(settings, stringObjectMap);
    }

    @Override
    public boolean addValidateMetadatum(String parameterText, Object value) {
        Settings.CombinationFcn combinationFcn;
        Combination function;
        Parameter parameter = new Parameter(parameterText);
        ParameterValue parameterValue = new ParameterValue(value);
        boolean valid = false;
        if (parameter.type == Parameter.Type.OFFSET && parameterValue.type == ParameterValue.Type.VALUE) {
            valid = true;
        } else if (parameter.type == Parameter.Type.LEARNABLE && parameterValue.type == ParameterValue.Type.BOOLEAN) {
            valid = true;
        } else if (parameter.type == Parameter.Type.TRANSFORMATION && parameterValue.type == ParameterValue.Type.STRING) {
            Settings.TransformationFcn transformationFcn = Settings.parseTransformation(parameterValue.stringValue);
            Transformation function2 = Transformation.getFunction(transformationFcn);
            if (function2 != null) {
                valid = true;
                parameterValue.value = function2;
            }
        } else if ((parameter.type == Parameter.Type.AGGREGATION || parameter.type == Parameter.Type.COMBINATION) && parameterValue.type == ParameterValue.Type.STRING && (function = Combination.getFunction(combinationFcn = Settings.parseCombination(parameterValue.stringValue))) != null) {
            valid = true;
            parameterValue.value = function;
        }
        if (valid) {
            this.metadata.put(parameter, parameterValue);
        }
        return true;
    }

    @Override
    public void applyTo(WeightedRule object) {
        this.metadata.forEach((param, value) -> this.apply(object, (Parameter)param, (ParameterValue)value));
    }

    private void apply(WeightedRule rule, Parameter param, ParameterValue value) {
        if (param.type == Parameter.Type.COMBINATION) {
            rule.setCombination((Combination)value.value);
        }
        if (param.type == Parameter.Type.TRANSFORMATION) {
            rule.setTransformation((Transformation)value.value);
        }
        if (param.type == Parameter.Type.AGGREGATION) {
            rule.setAggregationFcn((Aggregation)value.value);
        }
    }
}

