/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.constructs.template.types;

import cz.cvut.fel.ida.logic.Clause;
import cz.cvut.fel.ida.logic.Literal;
import cz.cvut.fel.ida.logic.Predicate;
import cz.cvut.fel.ida.logic.constructs.example.QueryAtom;
import cz.cvut.fel.ida.logic.constructs.template.Template;
import cz.cvut.fel.ida.logic.constructs.template.components.BodyAtom;
import cz.cvut.fel.ida.logic.constructs.template.components.WeightedRule;
import cz.cvut.fel.ida.logic.subsumption.Matching;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class GraphTemplate
extends Template {
    private static final Logger LOG = Logger.getLogger(GraphTemplate.class.getName());
    public transient Map<Literal, Set<WeightedRule>> atom2rules;
    transient Set<Literal> closedAtoms;
    transient Set<Literal> openAtoms;
    public boolean isStratified = true;

    public GraphTemplate() {
        this.atom2rules = new LinkedHashMap<Literal, Set<WeightedRule>>();
    }

    public GraphTemplate(GraphTemplate template) {
        super(template);
        this.atom2rules = template.atom2rules;
        this.closedAtoms = template.closedAtoms;
        this.openAtoms = template.openAtoms;
        this.isStratified = template.isStratified;
    }

    public GraphTemplate(Template template) {
        super(template);
        LinkedHashMap<Predicate, List> predicate2heads = new LinkedHashMap<Predicate, List>();
        this.atom2rules = new LinkedHashMap<Literal, Set<WeightedRule>>();
        this.closedAtoms = template.facts.stream().map(f -> f.literal).collect(Collectors.toSet());
        if (template.inferredAtoms != null) {
            this.closedAtoms.addAll(template.inferredAtoms);
        }
        this.openAtoms = new HashSet<Literal>();
        Clause clause = new Clause(this.closedAtoms);
        Matching matching = new Matching(Collections.singletonList(clause));
        for (WeightedRule weightedRule : template.rules) {
            List list = predicate2heads.computeIfAbsent(weightedRule.getHead().literal.predicate(), k -> new ArrayList());
            list.add(weightedRule);
            Set list2 = this.atom2rules.computeIfAbsent(weightedRule.getHead().literal, k -> new HashSet());
            list2.add(weightedRule);
        }
        for (Map.Entry entry : predicate2heads.entrySet()) {
            for (WeightedRule anyRule : (List)entry.getValue()) {
                for (BodyAtom bodyAtom : anyRule.getBody()) {
                    Literal bodyLiteral = bodyAtom.literal;
                    if (bodyLiteral.isNegated()) {
                        this.containsNegation = true;
                        bodyLiteral = new Literal(bodyLiteral.predicate(), false, bodyLiteral.termList());
                    }
                    List possibleRules = (List)predicate2heads.get(bodyLiteral.predicate());
                    boolean hasChildren = false;
                    if (possibleRules != null) {
                        for (WeightedRule possibleRule : possibleRules) {
                            if (!matching.subsumption(new Clause(possibleRule.getHead().literal), new Clause(bodyLiteral)).booleanValue() && !matching.subsumption(new Clause(bodyLiteral), new Clause(possibleRule.getHead().literal)).booleanValue()) continue;
                            hasChildren = true;
                            Set rules4atom = this.atom2rules.computeIfAbsent(bodyLiteral, k -> new HashSet());
                            rules4atom.add(possibleRule);
                        }
                    }
                    if (hasChildren || this.closedAtoms.contains(bodyLiteral)) continue;
                    this.openAtoms.add(bodyLiteral);
                }
            }
        }
    }

    @Override
    public GraphTemplate prune(QueryAtom queryAtom) {
        GraphTemplate pruned = new GraphTemplate(this);
        pruned.rules = new LinkedHashSet();
        this.recursePrune(queryAtom.headAtom.literal, pruned.rules);
        return pruned;
    }

    private void recursePrune(Literal head, LinkedHashSet<WeightedRule> rules) {
        Set<WeightedRule> childrenRules = this.atom2rules.get(head);
        if (childrenRules == null) {
            return;
        }
        for (WeightedRule rule : childrenRules) {
            rules.add(rule);
            for (BodyAtom bodyAtom : rule.getBody()) {
                this.recursePrune(bodyAtom.literal, rules);
            }
        }
    }

    private class UnsignedLiteral {
        private Literal literal;
        boolean wasNegated = false;

        public UnsignedLiteral(Literal literal) {
            if (literal.isNegated()) {
                this.literal = new Literal(literal.predicate(), false, literal.termList());
                this.wasNegated = true;
            } else {
                this.literal = literal;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UnsignedLiteral that = (UnsignedLiteral)o;
            return Objects.equals(this.literal, that.literal);
        }

        public int hashCode() {
            return Objects.hash(this.literal);
        }

        public String toString() {
            return this.wasNegated ? "!" + this.literal.toString() : this.literal.toString();
        }
    }

    public class Stratification {
        private final GraphTemplate graphTemplate;
        Set<Literal> open = new HashSet<Literal>();
        Set<Literal> closed = new HashSet<Literal>();
        LinkedList<UnsignedLiteral> path = new LinkedList();

        public Stratification(GraphTemplate graphTemplate) {
            this.graphTemplate = graphTemplate;
        }

        public void check() {
            for (Literal root : this.graphTemplate.atom2rules.keySet()) {
                this.checkCyclesStartingFrom(root);
            }
        }

        private void checkCyclesStartingFrom(Literal literal) {
            UnsignedLiteral unsignedLiteral = new UnsignedLiteral(literal);
            this.path.addLast(unsignedLiteral);
            literal = unsignedLiteral.literal;
            if (this.closed.contains(literal)) {
                return;
            }
            if (this.open.contains(literal)) {
                boolean negatedCycle;
                boolean bl = negatedCycle = !this.containsNegativeCycle(literal, this.path);
                if (negatedCycle) {
                    this.graphTemplate.isStratified = false;
                }
                return;
            }
            this.open.add(literal);
            Set<WeightedRule> rules = this.graphTemplate.atom2rules.get(literal);
            if (rules != null) {
                for (WeightedRule rule : rules) {
                    for (BodyAtom bodyAtom : rule.getBody()) {
                        this.checkCyclesStartingFrom(bodyAtom.literal);
                    }
                }
            }
            this.path.removeLast();
            this.open.remove(literal);
            this.closed.add(literal);
        }

        private boolean containsNegativeCycle(Literal literal, LinkedList<UnsignedLiteral> stack) {
            Iterator iterator = stack.iterator();
            LinkedList<UnsignedLiteral> cycle = new LinkedList<UnsignedLiteral>();
            boolean negatedCycle = false;
            UnsignedLiteral next = (UnsignedLiteral)iterator.next();
            while (!next.literal.equals(literal)) {
                next = (UnsignedLiteral)iterator.next();
            }
            cycle.add(next);
            do {
                next = (UnsignedLiteral)iterator.next();
                cycle.add(next);
                if (!next.wasNegated) continue;
                negatedCycle = true;
            } while (iterator.hasNext());
            if (negatedCycle) {
                LOG.severe("The template is not stratified - there is a cyclic dependency with negation: " + cycle.toString());
                LOG.severe("This may lead to weird and ambiguous behavior, please check your template carefully (or google stratified logic programming).");
                return true;
            }
            return false;
        }
    }
}

