/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.features.generation;

import cz.cvut.fel.ida.logic.Clause;
import cz.cvut.fel.ida.logic.Literal;
import cz.cvut.fel.ida.logic.features.generation.FeatureGenerationSettings;
import cz.cvut.fel.ida.logic.features.generation.FeaturesTable;
import cz.cvut.fel.ida.logic.features.generation.GraphTemplateBuilder;
import cz.cvut.fel.ida.logic.features.generation.PreprocessedInput;
import cz.cvut.fel.ida.logic.features.treeliker.Block;
import cz.cvut.fel.ida.logic.features.treeliker.Dataset;
import cz.cvut.fel.ida.logic.features.treeliker.Example;
import cz.cvut.fel.ida.logic.features.treeliker.HiFi;
import cz.cvut.fel.ida.logic.features.treeliker.PredicateDefinition;
import cz.cvut.fel.ida.logic.features.treeliker.Table;
import cz.cvut.fel.ida.logic.features.treeliker.TreeLikerSettings;
import cz.cvut.fel.ida.logic.features.treeliker.aggregables.GroundingCountingAggregablesBuilder;
import cz.cvut.fel.ida.logic.features.treeliker.aggregables.VoidAggregablesBuilder;
import cz.cvut.fel.ida.utils.math.collections.IntegerSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FeatureGenerator {
    public static FeaturesTable generateFeatures(List<Clause> dataset) {
        return FeatureGenerator.generateFeatures(dataset, FeatureGenerationSettings.TEMPLATE_DEPTH);
    }

    public static FeaturesTable generateFeatures(List<Clause> dataset, int featureDepth) {
        FeatureGenerator featureGenerator = new FeatureGenerator();
        return featureGenerator.generateFeatures_impl(dataset, featureDepth);
    }

    public static FeaturesTable generateFeatures(List<Clause> dataset, String template) {
        FeatureGenerator featureGenerator = new FeatureGenerator();
        return featureGenerator.generateFeatures_impl(dataset, template);
    }

    private FeaturesTable generateFeatures_impl(List<Clause> dataset, int featureDepth) {
        PreprocessedInput preprocessed = this.preprocess(dataset, featureDepth);
        return this.constructAndEvaluateFeatures(preprocessed);
    }

    private FeaturesTable generateFeatures_impl(List<Clause> dataset, String template) {
        PreprocessedInput preprocessed = new PreprocessedInput(template, dataset);
        return this.constructAndEvaluateFeatures(preprocessed);
    }

    private PreprocessedInput preprocess(List<Clause> dataset, int depth) {
        GraphTemplateBuilder templateBuilder = new GraphTemplateBuilder(dataset);
        String stringTemplate = templateBuilder.inferTemplate(depth);
        return new PreprocessedInput(stringTemplate, dataset);
    }

    private FeaturesTable constructAndEvaluateFeatures(PreprocessedInput preprocessed) {
        Set<Block> features = this.constructFeatures(preprocessed);
        return this.evaluateFeatures(features, preprocessed.getGlobalConstants(), preprocessed.getDataset());
    }

    private Set<Block> constructFeatures(PreprocessedInput preprocessed) {
        HashSet<Block> features = new HashSet<Block>();
        for (Set<PredicateDefinition> def : preprocessed.getTemplates()) {
            HiFi hifi = new HiFi(preprocessed.getDataset());
            if (FeatureGenerationSettings.COUNT_GROUNDINGS) {
                hifi.setAggregablesBuilder(GroundingCountingAggregablesBuilder.construct());
                hifi.setPostProcessingAggregablesBuilder(GroundingCountingAggregablesBuilder.construct());
            }
            features.addAll(hifi.constructFeatures(def));
        }
        return features;
    }

    private FeaturesTable evaluateFeatures(Set<Block> features, List<PredicateDefinition> globalConstants, Dataset dataset) {
        Table<Integer, String> table = new Table<Integer, String>();
        ArrayList<Block> nonConstantAttributes = new ArrayList<Block>();
        ArrayList<Block> globalConstantAttributes = new ArrayList<Block>();
        for (Block attribute : features) {
            if (attribute.definition().isGlobalConstant()) {
                globalConstantAttributes.add(attribute);
                continue;
            }
            nonConstantAttributes.add(attribute);
        }
        Dataset copyOfDataset = dataset.shallowCopy();
        copyOfDataset.reset();
        while (copyOfDataset.hasNextExample()) {
            Example example = copyOfDataset.nextExample();
            table.addClassification(copyOfDataset.currentIndex(), copyOfDataset.classificationOfCurrentExample());
            this.addGlobalConstants(example, copyOfDataset.currentIndex(), table, globalConstants);
        }
        HiFi hifi = new HiFi(dataset);
        if (FeatureGenerationSettings.COUNT_GROUNDINGS) {
            hifi.setAggregablesBuilder(VoidAggregablesBuilder.construct());
            hifi.setPostProcessingAggregablesBuilder(GroundingCountingAggregablesBuilder.construct());
        }
        table.addAll(hifi.constructTable(nonConstantAttributes));
        return FeaturesTable.fromTreeLikerTable(table);
    }

    private void addGlobalConstants(Example example, int exampleIndex, Table<Integer, String> t, List<PredicateDefinition> globalConstants) {
        for (PredicateDefinition def : globalConstants) {
            IntegerSet domain = example.getLiteralDomain(def.predicate());
            if (domain.size() == 1) {
                int literalId = domain.values()[0];
                Literal literal = example.integerToLiteral(literalId);
                for (int i = 0; i < def.modes().length; ++i) {
                    if (def.modes()[i] != 4) continue;
                    if (literal.arity() == 1) {
                        t.add(exampleIndex, def.stringPredicate(), literal.get(i).toString());
                        continue;
                    }
                    System.out.println("Warning: " + String.valueOf(def) + " cannot be used as global constant because its arity is not equal to one!!!!");
                }
                continue;
            }
            if (domain.size() > 1) {
                System.out.println("Warning: " + String.valueOf(def) + " cannot be used as global constant because there are more than one literals of the kind " + String.valueOf(def) + " in the example being processed or there is none!!!!");
                continue;
            }
            System.out.println("Warning: " + String.valueOf(def) + " cannot be used as global constant because there are no literals of the kind " + String.valueOf(def) + " in the example being processed or there is none!!!!");
        }
    }

    static {
        TreeLikerSettings.VERBOSITY = 0;
    }
}

