/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.features.generation;

import cz.cvut.fel.ida.logic.Clause;
import cz.cvut.fel.ida.logic.Literal;
import cz.cvut.fel.ida.logic.features.generation.FeatureGenerationSettings;
import cz.cvut.fel.ida.logic.features.treeliker.Table;
import cz.cvut.fel.ida.utils.generic.tuples.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class FeaturesTable {
    public final List<Clause> features;
    public final int[][] table;

    public static FeaturesTable fromTreeLikerTable(Table<Integer, String> propTable) {
        return new FeaturesTable(propTable);
    }

    private FeaturesTable(Table<Integer, String> propTable) {
        List<Pair<String, Clause>> sortedFeatures = this.sortFeatures(propTable.filteredAttributes());
        int noExamples = propTable.getAttributeVector((String)sortedFeatures.get((int)0).r).size();
        this.features = new ArrayList<Clause>(sortedFeatures.size());
        this.table = new int[noExamples][sortedFeatures.size()];
        int featureIndex = 0;
        for (Pair<String, Clause> featureData : sortedFeatures) {
            String originalFeature = (String)featureData.r;
            Clause clausalFeature = (Clause)featureData.s;
            this.features.add(clausalFeature);
            Map<Integer, String> values = propTable.getAttributeVector(originalFeature);
            for (Map.Entry<Integer, String> pair : values.entrySet()) {
                if (FeatureGenerationSettings.COUNT_GROUNDINGS) {
                    this.table[pair.getKey().intValue()][featureIndex] = Integer.parseInt(pair.getValue());
                    continue;
                }
                this.table[pair.getKey().intValue()][featureIndex] = pair.getValue().equals("+") ? 1 : 0;
            }
            ++featureIndex;
        }
    }

    private List<Pair<String, Clause>> sortFeatures(Set<String> features) {
        ArrayList<Pair<String, Clause>> sortedFeatures = new ArrayList<Pair<String, Clause>>(features.size());
        for (String feature : features) {
            Clause clause = Clause.parse(feature);
            String sortedClause = clause.literals().stream().map(Literal::toString).sorted().collect(Collectors.joining(", "));
            sortedFeatures.add(new Pair<String, Clause>(feature, Clause.parse(sortedClause)));
        }
        sortedFeatures.sort(Comparator.comparing(o -> ((Clause)o.s).toString()));
        return sortedFeatures;
    }

    public String toString() {
        return "FeaturesTable{\n" + this.printFeatures() + "\n" + Arrays.deepToString((Object[])this.table) + "\n}";
    }

    private String printFeatures() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (Clause feature : this.features) {
            sb.append(feature);
            sb.append("; ");
        }
        sb.append(']');
        return sb.toString();
    }
}

