/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.features.generation;

import cz.cvut.fel.ida.logic.Clause;
import cz.cvut.fel.ida.logic.Literal;
import cz.cvut.fel.ida.logic.Predicate;
import cz.cvut.fel.ida.logic.features.generation.FeatureGenerationSettings;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GraphTemplateBuilder {
    private final Set<Predicate> unaryPredicates = new HashSet<Predicate>();
    private final Set<Predicate> binaryPredicates = new HashSet<Predicate>();

    public GraphTemplateBuilder() {
    }

    public GraphTemplateBuilder(List<Clause> dataset) {
        this();
        this.processExamples(dataset);
    }

    public void processExamples(List<Clause> dataset) {
        this.unaryPredicates.clear();
        this.binaryPredicates.clear();
        for (Clause clause : dataset) {
            block5: for (Literal lit : clause.literals()) {
                switch (lit.arity()) {
                    case 1: {
                        this.unaryPredicates.add(lit.predicate());
                        continue block5;
                    }
                    case 2: {
                        this.binaryPredicates.add(lit.predicate());
                        continue block5;
                    }
                }
                throw new IllegalArgumentException("Cannot process literal " + String.valueOf(lit) + " of arity " + lit.arity() + ".Literals of arity zero or greater than two are not supported. Examples should be (labeled) graphs!");
            }
        }
    }

    public String inferTemplate() {
        return this.inferTemplate(FeatureGenerationSettings.TEMPLATE_DEPTH);
    }

    public String inferTemplate(int depth) {
        int i;
        if (depth < 0) {
            throw new IllegalArgumentException("Depth must be non-negative");
        }
        if (this.unaryPredicates.stream().noneMatch(pred -> pred.name.equals(FeatureGenerationSettings.VERTEX_PREDICATE_NAME))) {
            throw new IllegalArgumentException("Dataset must contain the auxiliary 'VERTEX' predicate.");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(FeatureGenerationSettings.VERTEX_PREDICATE_NAME);
        sb.append("(-x1)");
        for (Predicate pred2 : this.unaryPredicates) {
            if (pred2.name.equals(FeatureGenerationSettings.VERTEX_PREDICATE_NAME)) continue;
            for (i = 1; i <= depth + 1; ++i) {
                sb.append(", ");
                sb.append(pred2.name);
                sb.append("(+").append("x").append(i).append(")");
            }
        }
        for (Predicate pred2 : this.binaryPredicates) {
            for (i = 1; i < depth + 1; ++i) {
                sb.append(", ");
                sb.append(pred2.name);
                sb.append("(+").append("x").append(i).append(", -").append("x").append(i + 1).append(")");
            }
        }
        return sb.toString();
    }
}

