/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.features.generation;

import cz.cvut.fel.ida.logic.Clause;
import cz.cvut.fel.ida.logic.Literal;
import cz.cvut.fel.ida.logic.features.generation.NoClassMemBasedDataset;
import cz.cvut.fel.ida.logic.features.treeliker.Example;
import cz.cvut.fel.ida.logic.features.treeliker.PredicateDefinition;
import cz.cvut.fel.ida.logic.features.treeliker.Preprocessor;
import cz.cvut.fel.ida.utils.math.Sugar;
import cz.cvut.fel.ida.utils.math.collections.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class PreprocessedInput {
    private final List<Clause> originalData;
    private final List<Set<PredicateDefinition>> templates;
    private final List<PredicateDefinition> globalConstants;
    private final NoClassMemBasedDataset dataset;

    public PreprocessedInput(String template, List<Clause> dataset) {
        this.originalData = new ArrayList<Clause>(dataset);
        this.templates = new ArrayList<Set<PredicateDefinition>>();
        this.globalConstants = new ArrayList<PredicateDefinition>();
        this.dataset = new NoClassMemBasedDataset();
        Set<PredicateDefinition> literalDefinitions = PredicateDefinition.parseDefinition(template);
        this.detectGlobalConstants(literalDefinitions);
        Set<PredicateDefinition> modifiedTemplate = this.preprocessData(literalDefinitions);
        this.buildConnectedComponents(modifiedTemplate);
    }

    public List<Clause> getOriginalData() {
        return this.originalData;
    }

    public List<Set<PredicateDefinition>> getTemplates() {
        return this.templates;
    }

    public List<PredicateDefinition> getGlobalConstants() {
        return this.globalConstants;
    }

    public NoClassMemBasedDataset getDataset() {
        return this.dataset;
    }

    private void detectGlobalConstants(Set<PredicateDefinition> literalDefinitions) {
        for (PredicateDefinition def : literalDefinitions) {
            if (!def.isGlobalConstant()) continue;
            this.globalConstants.add(def);
        }
    }

    private Set<PredicateDefinition> preprocessData(Set<PredicateDefinition> template) {
        LinkedHashSet<PredicateDefinition> modifiedTemplate = new LinkedHashSet<PredicateDefinition>();
        template = this.preprocessDefinitions(template);
        for (Clause clause : this.originalData) {
            Clause reachableExample = Preprocessor.reachableLiterals(template, this.globalConstants, clause);
            LinkedHashSet<Literal> literals = new LinkedHashSet<Literal>();
            LinkedHashSet<String> constants = new LinkedHashSet<String>();
            for (PredicateDefinition def : template) {
                Collection<Literal> eLiterals = reachableExample.getLiteralsByPredicate(def.stringPredicate());
                PredicateDefinition cloned = def.cloneDefinition();
                for (int i = 0; i < def.modes().length; ++i) {
                    if (def.modes()[i] != 3) continue;
                    cloned.setMode(2, i);
                    for (Literal constLit : eLiterals) {
                        boolean prune;
                        StringBuilder sb = new StringBuilder();
                        try {
                            sb.append(constLit.get(i).toString());
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            System.err.println("Problem with " + String.valueOf(reachableExample));
                        }
                        constants.add(constLit.get(i).toString());
                        sb.append("(+");
                        sb.append(def.stringType(i));
                        sb.append("[1]), ");
                        PredicateDefinition constantDefinition = Sugar.chooseOne(PredicateDefinition.parseDefinition(sb.toString()));
                        if (constantDefinition != null && !(prune = false)) {
                            constantDefinition.setConstant(true);
                            modifiedTemplate.add(constantDefinition);
                        }
                        Literal newLiteral = new Literal(constLit.get(i).toString(), 1);
                        newLiteral.set(constLit.get(i), 0);
                        literals.add(newLiteral);
                    }
                }
                modifiedTemplate.add(cloned);
            }
            literals.addAll(reachableExample.literals());
            this.dataset.addExample(new Example(new Clause(literals)));
        }
        return modifiedTemplate;
    }

    private Set<PredicateDefinition> preprocessDefinitions(Set<PredicateDefinition> definitions) {
        HashSet<PredicateDefinition> retVal = new HashSet<PredicateDefinition>();
        for (PredicateDefinition def : definitions) {
            PredicateDefinition clone = def.cloneDefinition();
            int[] modes = def.modes();
            for (int i = 0; i < def.arity(); ++i) {
                if (modes[i] != 6 && modes[i] != 7) continue;
                clone.setMode(5, i);
            }
            retVal.add(clone);
        }
        return retVal;
    }

    private void buildConnectedComponents(Set<PredicateDefinition> modifiedTemplate) {
        ArrayList<PredicateDefinition> outputOnlyLiteralDefinitions = new ArrayList<PredicateDefinition>();
        LinkedHashSet<PredicateDefinition> remainingLiteralDefinitions = new LinkedHashSet<PredicateDefinition>();
        for (PredicateDefinition def : modifiedTemplate) {
            if (def.isOutputOnly()) {
                outputOnlyLiteralDefinitions.add(def);
                continue;
            }
            remainingLiteralDefinitions.add(def);
        }
        for (PredicateDefinition output : outputOnlyLiteralDefinitions) {
            this.templates.add(Sugar.setFromCollections(this.connectedComponent(output, remainingLiteralDefinitions), Sugar.set(output)));
        }
    }

    private Set<PredicateDefinition> connectedComponent(PredicateDefinition output, Set<PredicateDefinition> other) {
        HashSet<PredicateDefinition> closed = new HashSet<PredicateDefinition>();
        MultiMap<String, PredicateDefinition> inputToPredicate = new MultiMap<String, PredicateDefinition>();
        for (PredicateDefinition def : other) {
            String inputType = def.stringType(def.input());
            inputToPredicate.put(inputType, def);
        }
        Stack<PredicateDefinition> open = new Stack<PredicateDefinition>();
        open.push(output);
        while (open.size() > 0) {
            PredicateDefinition def;
            def = (PredicateDefinition)open.pop();
            closed.add(def);
            for (int i = 0; i < def.modes().length; ++i) {
                if (def.modes()[i] != 2) continue;
                for (PredicateDefinition d : inputToPredicate.get(def.stringType(i))) {
                    if (closed.contains(d)) continue;
                    open.push(d);
                }
            }
        }
        return closed;
    }
}

