/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.features.treeliker;

import cz.cvut.fel.ida.logic.Clause;
import cz.cvut.fel.ida.logic.Literal;
import cz.cvut.fel.ida.logic.features.treeliker.PredicateDefinition;
import cz.cvut.fel.ida.utils.generic.tuples.Pair;
import cz.cvut.fel.ida.utils.generic.tuples.Triple;
import cz.cvut.fel.ida.utils.math.StringUtils;
import cz.cvut.fel.ida.utils.math.collections.IntegerMultiMap;
import cz.cvut.fel.ida.utils.math.collections.IntegerSet;
import cz.cvut.fel.ida.utils.math.collections.MultiMap;
import cz.cvut.fel.ida.utils.math.collections.ValueToIndex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class Example {
    private int id;
    private int maxArity;
    private static int lastId;
    private static ValueToIndex<String> termsToIntegers;
    private Map<Integer, int[]> termsInLiterals = new HashMap<Integer, int[]>();
    private IntegerMultiMap<Integer> predicateMultiMap;
    private IntegerMultiMap<Triple<Integer, Integer, Integer>> literalMultiMap;
    private IntegerMultiMap<Pair<Integer, Integer>> predicateTermMultiMap = new IntegerMultiMap();
    private HashMap<Integer, Literal> originalLiterals = new HashMap();

    public Example(Clause e) {
        e = this.preprocessClause(e);
        this.buildLiteralMap(e);
        this.buildPredicateMap(e);
        this.buildTermsInLiterals(e);
        this.buildPredicateTermMultiMap(e);
        this.id = lastId++;
    }

    private Clause preprocessClause(Clause clause) {
        ArrayList<Literal> literals = new ArrayList<Literal>();
        for (Literal l : clause.literals()) {
            this.maxArity = Math.max(this.maxArity, l.arity());
            Literal newLit = new Literal(l.predicate());
            for (int i = 0; i < l.arity(); ++i) {
                newLit.set(l.get(i), i);
            }
            literals.add(newLit);
        }
        return new Clause(literals);
    }

    private void buildLiteralMap(Clause e) {
        this.literalMultiMap = new IntegerMultiMap();
        MultiMap<Triple<Integer, Integer, Integer>, Integer> hb = new MultiMap<Triple<Integer, Integer, Integer>, Integer>();
        HashSet<Integer> doubleTerms = new HashSet<Integer>();
        for (Literal literal : e.literals()) {
            for (int i = 0; i < literal.arity(); ++i) {
                hb.put(new Triple<Integer, Integer, Integer>(PredicateDefinition.predicateToInteger(literal.predicate().name, literal.arity()), i, termsToIntegers.valueToIndex(literal.get(i).toString())), literal.id());
                if (!StringUtils.isNumeric(literal.get(i).name())) continue;
                doubleTerms.add(termsToIntegers.valueToIndex(literal.get(i).toString()));
            }
            this.originalLiterals.put(literal.id(), literal);
        }
        for (Map.Entry entry : hb.entrySet()) {
            this.literalMultiMap.add((Triple)entry.getKey(), IntegerSet.createIntegerSet((Set)entry.getValue()));
        }
    }

    private void buildPredicateMap(Clause e) {
        this.predicateMultiMap = new IntegerMultiMap();
        for (String predicate : e.predicates()) {
            MultiMap<Integer, Integer> lits = new MultiMap<Integer, Integer>();
            for (Literal literal : e.getLiteralsByPredicate(predicate)) {
                lits.put(literal.arity(), literal.id());
            }
            for (Map.Entry entry : lits.entrySet()) {
                this.predicateMultiMap.add(PredicateDefinition.predicateToInteger(predicate, (Integer)entry.getKey()), IntegerSet.createIntegerSet((Set)entry.getValue()));
            }
        }
    }

    private void buildPredicateTermMultiMap(Clause e) {
        MultiMap<Pair<Integer, Integer>, Integer> auxMultiMap = new MultiMap<Pair<Integer, Integer>, Integer>();
        for (Literal l : e.literals()) {
            for (int i = 0; i < l.arity(); ++i) {
                auxMultiMap.put(new Pair<Integer, Integer>(PredicateDefinition.predicateToInteger(l.predicate().name, l.arity()), i), termsToIntegers.valueToIndex(l.get(i).name()));
            }
        }
        this.predicateTermMultiMap = IntegerMultiMap.createIntegerMultiMap(auxMultiMap);
    }

    private void buildTermsInLiterals(Clause e) {
        MultiMap<Pair<Integer, Integer>, Integer> hb = new MultiMap<Pair<Integer, Integer>, Integer>();
        for (Literal l : e.literals()) {
            int[] args = new int[l.arity()];
            for (int i = 0; i < l.arity(); ++i) {
                hb.put(new Pair<Integer, Integer>(PredicateDefinition.predicateToInteger(l.predicate().name, l.arity()), i), termsToIntegers.valueToIndex(l.get(i).toString()));
                args[i] = termsToIntegers.valueToIndex(l.get(i).toString());
            }
            this.termsInLiterals.put(l.id(), args);
        }
    }

    public Literal integerToLiteral(int integer) {
        return this.originalLiterals.get(integer);
    }

    public IntegerSet getLiteralDomain(int predicate) {
        IntegerSet domain = this.predicateMultiMap.get(predicate);
        if (domain == null) {
            return IntegerSet.emptySet;
        }
        return domain;
    }

    public IntegerSet getLiteralDomain(int predicate, int term, int argument) {
        return this.literalMultiMap.get(new Triple<Integer, Integer, Integer>(predicate, argument, term));
    }

    public IntegerSet getLiteralDomain(int predicate, IntegerSet terms, int argument) {
        int domSize = 0;
        int index = 0;
        IntegerSet[] domains = new IntegerSet[terms.size()];
        for (int term : terms.values()) {
            domains[index] = this.getLiteralDomain(predicate, term, argument);
            domSize += domains[index].size();
            ++index;
        }
        index = 0;
        int[] values = new int[domSize];
        for (int i = 0; i < domains.length; ++i) {
            int[] valuesI = domains[i].values();
            for (int j = 0; j < valuesI.length; ++j) {
                values[index] = valuesI[j];
                ++index;
            }
        }
        Arrays.sort(values);
        return IntegerSet.createIntegerSetFromSortedArray(values);
    }

    public IntegerSet getTermDomain(int predicate, int argument) {
        return this.predicateTermMultiMap.get(new Pair<Integer, Integer>(predicate, argument));
    }

    public IntegerSet getTermDomain(IntegerSet literalDomain, int argument) {
        IntegerSet retVal = null;
        LinkedHashSet<Integer> termDomain = new LinkedHashSet<Integer>();
        for (int i : literalDomain.values()) {
            if (i == -1) continue;
            termDomain.add(this.getTerm(i, argument));
        }
        retVal = IntegerSet.createIntegerSet(termDomain);
        return retVal;
    }

    public int getTerm(int literalID, int argument) {
        int[] args = null;
        args = this.termsInLiterals.get(literalID);
        if (args != null) {
            return args[argument];
        }
        return -1;
    }

    public String toString() {
        return this.originalLiterals.toString();
    }

    public Collection<Literal> literals() {
        return this.originalLiterals.values();
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (o instanceof Example) {
            return ((Example)o).id == this.id;
        }
        return false;
    }

    public int id() {
        return this.id;
    }

    public static String termToString(int term) {
        return termsToIntegers.indexToValue(term);
    }

    public static int stringToTerm(String term) {
        return termsToIntegers.valueToIndex(term);
    }

    public Set<Integer> literalIDs() {
        return this.originalLiterals.keySet();
    }

    static {
        termsToIntegers = new ValueToIndex();
    }
}

