/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.features.treeliker;

import cz.cvut.fel.ida.logic.features.treeliker.Block;
import cz.cvut.fel.ida.utils.math.Sugar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class FeaturesProcessing {
    public static void process(Collection<Block> features, Sugar.VoidFun<Block> transformFun) {
        HashSet<Integer> alreadyProcessed = new HashSet<Integer>();
        for (Block b : features) {
            FeaturesProcessing.process(b, transformFun, alreadyProcessed);
        }
    }

    private static void process(Block b, Sugar.VoidFun<Block> transformFun, Set<Integer> alreadyProcessed) {
        for (int i = 0; i < b.arity(); ++i) {
            if (b.children(i) == null) continue;
            for (Block child : b.children(i)) {
                if (alreadyProcessed.contains(b.id())) continue;
                FeaturesProcessing.process(child, transformFun, alreadyProcessed);
            }
        }
        transformFun.apply(b);
        alreadyProcessed.add(b.id());
    }
}

