/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.features.treeliker;

import cz.cvut.fel.ida.logic.features.treeliker.AggregablesBuilder;
import cz.cvut.fel.ida.logic.features.treeliker.Block;
import cz.cvut.fel.ida.logic.features.treeliker.Dataset;
import cz.cvut.fel.ida.logic.features.treeliker.Domain;
import cz.cvut.fel.ida.logic.features.treeliker.Example;
import cz.cvut.fel.ida.logic.features.treeliker.FeaturesProcessing;
import cz.cvut.fel.ida.logic.features.treeliker.Join;
import cz.cvut.fel.ida.logic.features.treeliker.JoinAndInt;
import cz.cvut.fel.ida.logic.features.treeliker.PredicateDefinition;
import cz.cvut.fel.ida.logic.features.treeliker.ProgressListener;
import cz.cvut.fel.ida.logic.features.treeliker.SyntaxChecker;
import cz.cvut.fel.ida.logic.features.treeliker.Table;
import cz.cvut.fel.ida.logic.features.treeliker.TreeLikerSettings;
import cz.cvut.fel.ida.logic.features.treeliker.aggregables.VoidAggregablesBuilder;
import cz.cvut.fel.ida.logic.features.treeliker.impl.BlockBuilder;
import cz.cvut.fel.ida.logic.features.treeliker.impl.BlocksWithLiteralsInDomainBuilder;
import cz.cvut.fel.ida.logic.features.treeliker.impl.CombinationsBuilder;
import cz.cvut.fel.ida.logic.features.treeliker.impl.DomainComputing;
import cz.cvut.fel.ida.logic.features.treeliker.impl.FeatureSearchUtils;
import cz.cvut.fel.ida.logic.features.treeliker.impl.HSubsumption;
import cz.cvut.fel.ida.logic.features.treeliker.impl.MaxSizeChecker;
import cz.cvut.fel.ida.logic.features.treeliker.impl.NumAggregatorsChecker;
import cz.cvut.fel.ida.logic.features.treeliker.impl.Pruning;
import cz.cvut.fel.ida.logic.features.treeliker.impl.TermsInDomainsOfBuilder;
import cz.cvut.fel.ida.utils.generic.tuples.Pair;
import cz.cvut.fel.ida.utils.math.Sugar;
import cz.cvut.fel.ida.utils.math.VectorUtils;
import cz.cvut.fel.ida.utils.math.collections.MultiList;
import cz.cvut.fel.ida.utils.math.collections.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class HiFi {
    private List<ProgressListener> progressListeners = new ArrayList<ProgressListener>();
    private Dataset examples;
    private int maxSize = Integer.MAX_VALUE;
    private int maxAggregators = Integer.MAX_VALUE;
    private boolean[] mask;
    private boolean[] negMask;
    private boolean alive = true;
    protected static int LITERALS = 1;
    protected static int TERMS = 2;
    private HSubsumption hsubsumptionEngine = new HSubsumption();
    private DomainComputing domainComputing;
    private Pruning pruning;
    private List<SyntaxChecker> syntaxCheckers = new ArrayList<SyntaxChecker>();
    private AggregablesBuilder aggregablesBuilder = VoidAggregablesBuilder.construct();
    private AggregablesBuilder postProcessingAggregablesBuilder = VoidAggregablesBuilder.construct();
    private Block normalizationFactor;

    public HiFi(Dataset examples) {
        this.examples = examples;
        this.domainComputing = new DomainComputing(this.examples.shallowCopy());
        this.mask = new boolean[examples.countExamples()];
        Arrays.fill(this.mask, true);
        this.negMask = VectorUtils.not(this.mask);
        this.pruning = new Pruning(this.mask, this.negMask, 1);
    }

    /*
     * WARNING - void declaration
     */
    public List<Block> constructFeatures(Set<PredicateDefinition> definitions) {
        void var6_11;
        Object modes;
        if (!this.alive) {
            throw new IllegalStateException("Each instance of class RelF can be used only once.");
        }
        this.alive = false;
        ArrayList<Block> constructedFeatures = new ArrayList<Block>();
        MultiList<Integer, Object> mm = new MultiList<Integer, Object>();
        List<PredicateDefinition> open = HiFi.buildOpenList(definitions);
        this.syntaxCheckers.add(new MaxSizeChecker(this.maxSize, open));
        this.syntaxCheckers.add(new NumAggregatorsChecker(this.maxAggregators));
        for (ProgressListener progressListener : this.progressListeners) {
            progressListener.readingExamples();
        }
        ArrayList<PredicateDefinition> inputOnlyDefinitions = new ArrayList<PredicateDefinition>();
        for (PredicateDefinition predicateDefinition : open) {
            if (!predicateDefinition.isInputOnly()) continue;
            inputOnlyDefinitions.add(predicateDefinition);
        }
        open = Sugar.listDifference(open, inputOnlyDefinitions);
        for (PredicateDefinition predicateDefinition : inputOnlyDefinitions) {
            if (TreeLikerSettings.VERBOSITY > 0) {
                System.out.println("Processing: " + String.valueOf(predicateDefinition));
            }
            for (ProgressListener pl : this.progressListeners) {
                pl.processingPredicate(predicateDefinition);
            }
            if (!predicateDefinition.isInputOnly()) continue;
            ArrayList<Block> generatedPosFeatures = new ArrayList<Block>();
            Block posFeat = new Block(predicateDefinition, this.aggregablesBuilder);
            modes = predicateDefinition.modes();
            for (int j = 0; j < ((int[])modes).length; ++j) {
                if (modes[j] != 1) continue;
                generatedPosFeatures.add(posFeat);
            }
            mm.putAll(predicateDefinition.types()[predicateDefinition.input()], generatedPosFeatures);
        }
        for (Map.Entry entry : mm.copy().entrySet()) {
            ConcurrentHashMap<Integer, Domain[]> computedDomains = this.domainComputing.computeTermDomainsInParallel(entry.getValue());
            Collection<Block> filtered = this.pruning.filterRedundantBlocksInParallel(entry.getValue(), computedDomains);
            mm.set((Integer)entry.getKey(), filtered);
        }
        this.examples.reset();
        boolean bl = false;
        while (var6_11 < open.size()) {
            PredicateDefinition predicateDefinition = open.get((int)var6_11);
            if (TreeLikerSettings.VERBOSITY > 0) {
                System.out.println("Processing: " + String.valueOf(predicateDefinition));
            }
            for (ProgressListener pl : this.progressListeners) {
                pl.processingPredicate(predicateDefinition);
            }
            List<Collection<Join>> combinations = Collections.synchronizedList(new ArrayList());
            for (int j = 0; j < predicateDefinition.modes().length; ++j) {
                if (predicateDefinition.modes()[j] == 2) {
                    combinations.add(this.combinationsOfPosFeatures(mm, predicateDefinition.types()[j], predicateDefinition.branchingFactors()[j]));
                    continue;
                }
                combinations.add(new ArrayList());
            }
            Collection<Block> newBlocks = this.buildBlocksFromCombinations(predicateDefinition, combinations);
            if (predicateDefinition.isOutputOnly()) {
                modes = newBlocks.iterator();
                while (modes.hasNext()) {
                    Block newFeature = (Block)modes.next();
                    constructedFeatures.add(newFeature);
                }
            } else if (mm.containsKey(predicateDefinition.types()[predicateDefinition.input()])) {
                ConcurrentHashMap<Integer, Domain[]> computedDomains = this.domainComputing.computeTermDomainsInParallel(Sugar.listFromCollections(newBlocks, mm.get(predicateDefinition.types()[predicateDefinition.input()])));
                Collection<Block> filtered = this.pruning.filterRedundantBlocksInParallel(Sugar.setFromCollections(newBlocks, mm.get(predicateDefinition.types()[predicateDefinition.input()])), computedDomains);
                mm.set(Integer.valueOf(predicateDefinition.types()[predicateDefinition.input()]), filtered);
            } else {
                mm.putAll(predicateDefinition.types()[predicateDefinition.input()], newBlocks);
            }
            ++var6_11;
        }
        return constructedFeatures;
    }

    public Table<Integer, String> constructTable(List<Block> constructedFeatures) {
        this.examples.reset();
        Table<Integer, String> table = new Table<Integer, String>();
        while (this.examples.hasNextExample()) {
            this.examples.nextExample();
            table.addClassification(this.examples.currentIndex(), this.examples.classificationOfCurrentExample());
        }
        ConcurrentHashMap<Integer, Domain[]> domains = this.domainComputing.computeLiteralDomainsInParallel(constructedFeatures);
        if (this.postProcessingAggregablesBuilder != null && !this.aggregablesBuilder.equals(this.postProcessingAggregablesBuilder) && !(this.postProcessingAggregablesBuilder instanceof VoidAggregablesBuilder)) {
            FeaturesProcessing.process(constructedFeatures, new Sugar.VoidFun<Block>(){

                @Override
                public void apply(Block t) {
                    t.deleteCachedDomains();
                    t.setAggregablesBuilder(HiFi.this.postProcessingAggregablesBuilder);
                }
            });
        }
        if (this.normalizationFactor != null) {
            this.normalizationFactor.applyRecursively(new Sugar.Fun<Block, Block>(){

                @Override
                public Block apply(Block t) {
                    t.setAggregablesBuilder(HiFi.this.postProcessingAggregablesBuilder);
                    return t;
                }
            });
        }
        this.examples.reset();
        while (this.examples.hasNextExample()) {
            Domain d;
            Example example = this.examples.nextExample();
            Double normalizationCoeff = null;
            if (this.normalizationFactor != null && !(d = this.normalizationFactor.termDomain(-1, example)).isEmpty() && d.getAggregableByDomainElement(-1) != null) {
                normalizationCoeff = new Double(d.getAggregableByDomainElement(-1).toString());
            }
            for (Block block : constructedFeatures) {
                if (this.aggregablesBuilder instanceof VoidAggregablesBuilder && this.postProcessingAggregablesBuilder instanceof VoidAggregablesBuilder) {
                    if (!block.literalDomain(example).isEmpty()) {
                        table.add(this.examples.currentIndex(), block.toClause(), "+", block.size());
                        continue;
                    }
                    table.add(this.examples.currentIndex(), block.toClause(), "-", block.size());
                    continue;
                }
                if (!((Domain[])domains.get(block.id()))[this.examples.currentIndex()].isEmpty()) {
                    Domain domain = block.termDomain(-1, example);
                    if (normalizationCoeff == null) {
                        table.add(this.examples.currentIndex(), block.toClause(), domain.getAggregableByDomainElement(-1).toString());
                        continue;
                    }
                    table.add(this.examples.currentIndex(), block.toClause(), String.valueOf(Double.parseDouble(domain.getAggregableByDomainElement(-1).toString()) / normalizationCoeff));
                    continue;
                }
                table.add(this.examples.currentIndex(), block.toClause(), "0", block.size());
            }
        }
        for (ProgressListener pl : this.progressListeners) {
            pl.finished(table.countOfAttributes());
        }
        return table;
    }

    private Collection<Join> combinationsOfPosFeatures(MultiList posFeatures, int inputType, int branching) {
        int i;
        MultiMap<Pair<Integer, Integer>, Block> termsInDomainsOf = new MultiMap<Pair<Integer, Integer>, Block>();
        List listOfBlocks = Sugar.listFromCollections(posFeatures.get(inputType));
        ConcurrentHashMap<Block, Integer> indices = new ConcurrentHashMap<Block, Integer>();
        ConcurrentHashMap<Integer, Block> posFeaturesLookup = new ConcurrentHashMap<Integer, Block>();
        for (int i2 = 0; i2 < listOfBlocks.size(); ++i2) {
            indices.put((Block)listOfBlocks.get(i2), i2);
            posFeaturesLookup.put(((Block)listOfBlocks.get(i2)).id(), (Block)listOfBlocks.get(i2));
        }
        ConcurrentHashMap<Integer, Domain[]> computedDomainsOfBlocks = this.domainComputing.computeTermDomainsInParallel(listOfBlocks);
        ArrayList<TermsInDomainsOfBuilder> tasks0 = new ArrayList<TermsInDomainsOfBuilder>();
        for (Map<Integer, Domain[]> taskMap : Sugar.splitMap(computedDomainsOfBlocks, Runtime.getRuntime().availableProcessors())) {
            tasks0.add(new TermsInDomainsOfBuilder(termsInDomainsOf, taskMap, posFeaturesLookup, this.mask));
        }
        Sugar.runInParallel(tasks0);
        MultiList<Integer, JoinAndInt> hbl = new MultiList<Integer, JoinAndInt>();
        ConcurrentHashMap<Pair<Block, Block>, Boolean> hSubsumptions = new ConcurrentHashMap<Pair<Block, Block>, Boolean>();
        ConcurrentHashMap<List<Domain>, Integer> redundancyMap = new ConcurrentHashMap<List<Domain>, Integer>();
        for (i = 0; i < listOfBlocks.size(); ++i) {
            hbl.put(1, new JoinAndInt(new Join((Block)listOfBlocks.get(i)), i));
        }
        for (i = 1; i < branching; ++i) {
            List tasks1 = Collections.synchronizedList(new ArrayList());
            for (JoinAndInt tuplePair : hbl.get(i)) {
                if (tuplePair == null) continue;
                tasks1.add(new CombinationsBuilder(tuplePair, redundancyMap, indices, hSubsumptions, hbl, i, termsInDomainsOf, this.domainComputing, this.hsubsumptionEngine, this.pruning, this.syntaxCheckers));
            }
            Sugar.runInParallel(tasks1, Runtime.getRuntime().availableProcessors());
            Iterator iterator = tasks1.iterator();
            while (iterator.hasNext()) {
                CombinationsBuilder cb = (CombinationsBuilder)iterator.next();
                redundancyMap.putAll(cb.getRedundancyMap());
            }
            if (hbl.get(i + 1).isEmpty()) break;
            List iterator2 = hbl.get(i + 1);
            hbl.set((Integer)(i + 1), iterator2);
        }
        List<JoinAndInt> flattened = Collections.synchronizedList(new ArrayList());
        for (Map.Entry entry : hbl.entrySet()) {
            for (JoinAndInt pair : (List)entry.getValue()) {
                flattened.add(pair);
            }
        }
        List<Join> retVal = Collections.synchronizedList(new ArrayList());
        for (JoinAndInt pair : flattened) {
            if (pair == null) continue;
            retVal.add((Join)pair.r);
        }
        return retVal;
    }

    private Collection<Block> buildBlocksFromCombinations(PredicateDefinition def, List<Collection<Join>> combinations) {
        MultiMap<Pair<Integer, Integer>, Join> bagPosFeaturesWithLiteralsInDomain = new MultiMap<Pair<Integer, Integer>, Join>();
        int argument = 0;
        for (Collection<Join> list : combinations) {
            ArrayList<BlocksWithLiteralsInDomainBuilder> tasks0 = new ArrayList<BlocksWithLiteralsInDomainBuilder>();
            for (Join join : list) {
                tasks0.add(new BlocksWithLiteralsInDomainBuilder(join, def.predicate(), argument, bagPosFeaturesWithLiteralsInDomain, this.examples));
            }
            Sugar.runInParallel(tasks0, Runtime.getRuntime().availableProcessors());
            ++argument;
        }
        Block root = new Block(def, this.aggregablesBuilder);
        List<Block> old = Sugar.list(root);
        List<Block> current = Collections.synchronizedList(new ArrayList());
        ConcurrentHashMap<Integer, Domain[]> domains = new ConcurrentHashMap<Integer, Domain[]>();
        domains.put(root.id(), this.domainComputing.computeLiteralDomains(root));
        for (int arg = 0; arg < def.modes().length; ++arg) {
            if (def.modes()[arg] != 2) continue;
            ArrayList<BlockBuilder> tasks1 = new ArrayList<BlockBuilder>();
            for (Block oldPos : old) {
                tasks1.add(new BlockBuilder(oldPos, arg, bagPosFeaturesWithLiteralsInDomain, domains, current, this.domainComputing, this.pruning, this.syntaxCheckers));
            }
            Sugar.runInParallel(tasks1, TreeLikerSettings.PROCESSORS);
            current = Sugar.listFromCollections(this.pruning.filterRedundantBlocksInParallel(current, domains));
            old = current;
            current = Collections.synchronizedList(new ArrayList());
        }
        return old;
    }

    public void setMinFrequency(int minFreq) {
        this.pruning.setMinFrequencyOnCoveredClass(minFreq);
    }

    private static List<PredicateDefinition> buildOpenList(Collection<PredicateDefinition> defs) {
        return FeatureSearchUtils.buildPredicateList(defs);
    }

    public void addProgressListener(ProgressListener pl) {
        this.progressListeners.add(pl);
    }

    public void addSyntaxChecker(SyntaxChecker syntaxChecker) {
        this.syntaxCheckers.add(syntaxChecker);
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public void setAggregablesBuilder(AggregablesBuilder aggregablesBuilder) {
        this.aggregablesBuilder = aggregablesBuilder;
    }

    public void setPostProcessingAggregablesBuilder(AggregablesBuilder postProcessingAggregablesBuilder) {
        this.postProcessingAggregablesBuilder = postProcessingAggregablesBuilder;
    }

    public void setMaxAggregators(int maxAggregators) {
        this.maxAggregators = maxAggregators;
    }

    public void setNormalizationFactor(Block normalizationFactor) {
        this.normalizationFactor = normalizationFactor;
    }
}

