/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.features.treeliker;

import cz.cvut.fel.ida.logic.features.treeliker.Block;
import cz.cvut.fel.ida.logic.features.treeliker.Dataset;
import cz.cvut.fel.ida.logic.features.treeliker.Domain;
import cz.cvut.fel.ida.logic.features.treeliker.Example;
import cz.cvut.fel.ida.logic.features.treeliker.Join;
import cz.cvut.fel.ida.logic.features.treeliker.JoinAndInt;
import cz.cvut.fel.ida.logic.features.treeliker.PredicateDefinition;
import cz.cvut.fel.ida.logic.features.treeliker.ProgressListener;
import cz.cvut.fel.ida.logic.features.treeliker.SyntaxChecker;
import cz.cvut.fel.ida.logic.features.treeliker.Table;
import cz.cvut.fel.ida.logic.features.treeliker.TreeLikerSettings;
import cz.cvut.fel.ida.logic.features.treeliker.aggregables.PolyAggregable;
import cz.cvut.fel.ida.logic.features.treeliker.aggregables.PolyAggregablesBuilder;
import cz.cvut.fel.ida.logic.features.treeliker.impl.BlockBuilder;
import cz.cvut.fel.ida.logic.features.treeliker.impl.BlocksWithLiteralsInDomainBuilder;
import cz.cvut.fel.ida.logic.features.treeliker.impl.CombinationsBuilder;
import cz.cvut.fel.ida.logic.features.treeliker.impl.DomainComputing;
import cz.cvut.fel.ida.logic.features.treeliker.impl.FeatureSearchUtils;
import cz.cvut.fel.ida.logic.features.treeliker.impl.HSubsumption;
import cz.cvut.fel.ida.logic.features.treeliker.impl.MaxSizeChecker;
import cz.cvut.fel.ida.logic.features.treeliker.impl.NumAggregatorsChecker;
import cz.cvut.fel.ida.logic.features.treeliker.impl.Pruning;
import cz.cvut.fel.ida.logic.features.treeliker.impl.TermsInDomainsOfBuilder;
import cz.cvut.fel.ida.utils.generic.tuples.Pair;
import cz.cvut.fel.ida.utils.generic.tuples.Tuple;
import cz.cvut.fel.ida.utils.math.Sugar;
import cz.cvut.fel.ida.utils.math.VectorUtils;
import cz.cvut.fel.ida.utils.math.collections.MultiList;
import cz.cvut.fel.ida.utils.math.collections.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class Poly {
    private List<ProgressListener> progressListeners = new ArrayList<ProgressListener>();
    private Dataset examples;
    private int maxSize = Integer.MAX_VALUE;
    private boolean[] mask;
    private boolean[] negMask;
    private boolean alive = true;
    private HSubsumption hsubsumptionEngine = new HSubsumption();
    private DomainComputing domainComputing;
    private Pruning pruning;
    private List<SyntaxChecker> syntaxCheckers = new ArrayList<SyntaxChecker>();
    private PolyAggregablesBuilder aggregablesBuilder;
    private boolean useGroundingCounting = true;

    public Poly(Dataset examples) {
        this.examples = examples;
        this.domainComputing = new DomainComputing(this.examples.shallowCopy());
        this.mask = new boolean[examples.countExamples()];
        Arrays.fill(this.mask, true);
        this.negMask = VectorUtils.not(this.mask);
        this.pruning = new Pruning(this.mask, this.negMask, 1);
    }

    /*
     * WARNING - void declaration
     */
    public List<Block> constructFeatures(Set<PredicateDefinition> definitions, int maxDegree) {
        void var7_12;
        Object modes;
        if (!this.alive) {
            throw new IllegalStateException("Each instance of class RelF can be used only once.");
        }
        this.alive = false;
        this.aggregablesBuilder = PolyAggregablesBuilder.construct(maxDegree);
        ArrayList<Block> constructedFeatures = new ArrayList<Block>();
        MultiList<Integer, Object> mm = new MultiList<Integer, Object>();
        List<PredicateDefinition> open = Poly.buildOpenList(definitions);
        this.syntaxCheckers.add(new MaxSizeChecker(this.maxSize, open));
        this.syntaxCheckers.add(new NumAggregatorsChecker(maxDegree));
        for (ProgressListener progressListener : this.progressListeners) {
            progressListener.readingExamples();
        }
        this.examples.reset();
        ArrayList<PredicateDefinition> inputOnlyDefinitions = new ArrayList<PredicateDefinition>();
        for (PredicateDefinition predicateDefinition : open) {
            if (!predicateDefinition.isInputOnly()) continue;
            inputOnlyDefinitions.add(predicateDefinition);
        }
        open = Sugar.listDifference(open, inputOnlyDefinitions);
        for (PredicateDefinition predicateDefinition : inputOnlyDefinitions) {
            if (TreeLikerSettings.VERBOSITY > 0) {
                System.out.println("Processing: " + String.valueOf(predicateDefinition));
            }
            for (ProgressListener pl : this.progressListeners) {
                pl.processingPredicate(predicateDefinition);
            }
            if (!predicateDefinition.isInputOnly()) continue;
            ArrayList<Block> generatedPosFeatures = new ArrayList<Block>();
            Block posFeat = new Block(predicateDefinition, this.aggregablesBuilder);
            modes = predicateDefinition.modes();
            for (int j = 0; j < ((int[])modes).length; ++j) {
                if (modes[j] != 1) continue;
                generatedPosFeatures.add(posFeat);
            }
            mm.putAll(predicateDefinition.types()[predicateDefinition.input()], generatedPosFeatures);
        }
        for (Map.Entry entry : mm.copy().entrySet()) {
            ConcurrentHashMap<Integer, Domain[]> computedDomains = this.domainComputing.computeTermDomainsInParallel(entry.getValue());
            Collection<Block> filtered = this.pruning.filterRedundantBlocksInParallel(entry.getValue(), computedDomains);
            mm.set((Integer)entry.getKey(), filtered);
        }
        this.examples.reset();
        boolean bl = false;
        while (var7_12 < open.size()) {
            PredicateDefinition predicateDefinition = open.get((int)var7_12);
            if (TreeLikerSettings.VERBOSITY > 0) {
                System.out.println("Processing: " + String.valueOf(predicateDefinition));
            }
            for (ProgressListener pl : this.progressListeners) {
                pl.processingPredicate(predicateDefinition);
            }
            List<Collection<Join>> combinations = Collections.synchronizedList(new ArrayList());
            for (int j = 0; j < predicateDefinition.modes().length; ++j) {
                if (predicateDefinition.modes()[j] == 2) {
                    combinations.add(this.combinationsOfPosFeatures(mm, predicateDefinition.types()[j], predicateDefinition.branchingFactors()[j]));
                    continue;
                }
                combinations.add(new ArrayList());
            }
            Collection<Block> newBlocks = this.buildBlocksFromCombinations(predicateDefinition, combinations);
            if (predicateDefinition.isOutputOnly()) {
                modes = newBlocks.iterator();
                while (modes.hasNext()) {
                    Block newFeature = (Block)modes.next();
                    constructedFeatures.add(newFeature);
                }
            } else if (mm.containsKey(predicateDefinition.types()[predicateDefinition.input()])) {
                ConcurrentHashMap<Integer, Domain[]> computedDomains = this.domainComputing.computeTermDomainsInParallel(Sugar.listFromCollections(newBlocks, mm.get(predicateDefinition.types()[predicateDefinition.input()])));
                Collection<Block> filtered = this.pruning.filterRedundantBlocksInParallel(Sugar.setFromCollections(newBlocks, mm.get(predicateDefinition.types()[predicateDefinition.input()])), computedDomains);
                mm.set(Integer.valueOf(predicateDefinition.types()[predicateDefinition.input()]), filtered);
            } else {
                mm.putAll(predicateDefinition.types()[predicateDefinition.input()], newBlocks);
            }
            ++var7_12;
        }
        return constructedFeatures;
    }

    public Table<Integer, String> constructTable(List<Block> constructedFeatures) {
        Table<Integer, String> table = new Table<Integer, String>();
        this.examples.reset();
        while (this.examples.hasNextExample()) {
            this.examples.nextExample();
            table.addClassification(this.examples.currentIndex(), this.examples.classificationOfCurrentExample());
        }
        ConcurrentHashMap<Integer, Domain[]> domains = this.domainComputing.computeLiteralDomainsInParallel(constructedFeatures);
        this.examples.reset();
        while (this.examples.hasNextExample()) {
            Example example = this.examples.nextExample();
            for (Block block : constructedFeatures) {
                PolyAggregable agg;
                Domain domain;
                String toClause;
                if (block.numAggregators() > 0) {
                    toClause = block.toClause();
                    if (((Domain[])domains.get(block.id()))[this.examples.currentIndex()].isEmpty()) continue;
                    domain = block.termDomain(-1, example);
                    agg = (PolyAggregable)domain.getAggregableByDomainElement(-1);
                    double[] monomials = agg.monomials();
                    List<Tuple<Integer>> monomialExponents = PolyAggregable.allMonomialExponents(block.numAggregators(), agg.maxDegree());
                    for (int i = 0; i < monomials.length; ++i) {
                        table.add(this.examples.currentIndex(), toClause + " -> " + Poly.monomialToString(monomialExponents.get(i)), String.valueOf(monomials[i]), block.size());
                    }
                    continue;
                }
                toClause = block.toClause();
                if (!((Domain[])domains.get(block.id()))[this.examples.currentIndex()].isEmpty()) {
                    if (this.useGroundingCounting) {
                        domain = block.termDomain(-1, example);
                        agg = (PolyAggregable)domain.getAggregableByDomainElement(-1);
                        table.add(this.examples.currentIndex(), toClause, String.valueOf(agg.samples()), block.size());
                        continue;
                    }
                    table.add(this.examples.currentIndex(), toClause, "+", block.size());
                    continue;
                }
                if (this.useGroundingCounting) {
                    table.add(this.examples.currentIndex(), toClause, "0", block.size());
                    continue;
                }
                table.add(this.examples.currentIndex(), toClause, "-", block.size());
            }
        }
        for (String attribute : Sugar.listFromCollections(table.attributes())) {
            Map attributeVector = table.getAttributeVector(attribute);
            Iterator iterator = Sugar.listFromCollections(table.examples()).iterator();
            while (iterator.hasNext()) {
                int example = (Integer)iterator.next();
                if (attributeVector.containsKey(example)) continue;
                table.add(example, attribute, "?");
            }
        }
        for (ProgressListener pl : this.progressListeners) {
            pl.finished(table.countOfAttributes());
        }
        return table;
    }

    private Collection<Join> combinationsOfPosFeatures(MultiList posFeatures, int inputType, int branching) {
        int i;
        MultiMap<Pair<Integer, Integer>, Block> termsInDomainsOf = new MultiMap<Pair<Integer, Integer>, Block>();
        List listOfBlocks = Sugar.listFromCollections(posFeatures.get(inputType));
        ConcurrentHashMap<Block, Integer> indices = new ConcurrentHashMap<Block, Integer>();
        ConcurrentHashMap<Integer, Block> posFeaturesLookup = new ConcurrentHashMap<Integer, Block>();
        for (int i2 = 0; i2 < listOfBlocks.size(); ++i2) {
            indices.put((Block)listOfBlocks.get(i2), i2);
            posFeaturesLookup.put(((Block)listOfBlocks.get(i2)).id(), (Block)listOfBlocks.get(i2));
        }
        ConcurrentHashMap<Integer, Domain[]> computedDomainsOfBlocks = this.domainComputing.computeTermDomainsInParallel(listOfBlocks);
        ArrayList<TermsInDomainsOfBuilder> tasks0 = new ArrayList<TermsInDomainsOfBuilder>();
        for (Map<Integer, Domain[]> taskMap : Sugar.splitMap(computedDomainsOfBlocks, Runtime.getRuntime().availableProcessors())) {
            tasks0.add(new TermsInDomainsOfBuilder(termsInDomainsOf, taskMap, posFeaturesLookup, this.mask));
        }
        Sugar.runInParallel(tasks0);
        MultiList<Integer, JoinAndInt> hbl = new MultiList<Integer, JoinAndInt>();
        ConcurrentHashMap<Pair<Block, Block>, Boolean> hSubsumptions = new ConcurrentHashMap<Pair<Block, Block>, Boolean>();
        ConcurrentHashMap<List<Domain>, Integer> redundancyMap = new ConcurrentHashMap<List<Domain>, Integer>();
        for (i = 0; i < listOfBlocks.size(); ++i) {
            hbl.put(1, new JoinAndInt(new Join((Block)listOfBlocks.get(i)), i));
        }
        for (i = 1; i < branching; ++i) {
            List tasks1 = Collections.synchronizedList(new ArrayList());
            for (JoinAndInt tuplePair : hbl.get(i)) {
                if (tuplePair == null) continue;
                CombinationsBuilder cb = new CombinationsBuilder(tuplePair, redundancyMap, indices, hSubsumptions, hbl, i, termsInDomainsOf, this.domainComputing, this.hsubsumptionEngine, this.pruning, this.syntaxCheckers);
                cb.setUseRepetitions(true);
                tasks1.add(cb);
            }
            Sugar.runInParallel(tasks1, Runtime.getRuntime().availableProcessors());
            Iterator iterator = tasks1.iterator();
            while (iterator.hasNext()) {
                CombinationsBuilder cb = (CombinationsBuilder)iterator.next();
                redundancyMap.putAll(cb.getRedundancyMap());
            }
            if (hbl.get(i + 1).isEmpty()) break;
            List<JoinAndInt> iterator2 = hbl.get(i + 1);
            hbl.set((Integer)(i + 1), (Collection<JoinAndInt>)iterator2);
        }
        List<JoinAndInt> flattened = Collections.synchronizedList(new ArrayList());
        for (Map.Entry entry : hbl.entrySet()) {
            for (JoinAndInt pair : (List)entry.getValue()) {
                flattened.add(pair);
            }
        }
        List<Join> retVal = Collections.synchronizedList(new ArrayList());
        for (JoinAndInt pair : flattened) {
            if (pair == null) continue;
            retVal.add((Join)pair.r);
        }
        return retVal;
    }

    private Collection<Block> buildBlocksFromCombinations(PredicateDefinition def, List<Collection<Join>> combinations) {
        MultiMap<Pair<Integer, Integer>, Join> bagPosFeaturesWithLiteralsInDomain = new MultiMap<Pair<Integer, Integer>, Join>();
        int argument = 0;
        for (Collection<Join> list : combinations) {
            ArrayList<BlocksWithLiteralsInDomainBuilder> tasks0 = new ArrayList<BlocksWithLiteralsInDomainBuilder>();
            for (Join join : list) {
                tasks0.add(new BlocksWithLiteralsInDomainBuilder(join, def.predicate(), argument, bagPosFeaturesWithLiteralsInDomain, this.examples));
            }
            Sugar.runInParallel(tasks0, Runtime.getRuntime().availableProcessors());
            ++argument;
        }
        Block root = new Block(def, this.aggregablesBuilder);
        List<Block> old = Sugar.list(root);
        List<Block> current = Collections.synchronizedList(new ArrayList());
        ConcurrentHashMap<Integer, Domain[]> domains = new ConcurrentHashMap<Integer, Domain[]>();
        domains.put(root.id(), this.domainComputing.computeLiteralDomains(root));
        for (int arg = 0; arg < def.modes().length; ++arg) {
            if (def.modes()[arg] != 2) continue;
            ArrayList<BlockBuilder> tasks1 = new ArrayList<BlockBuilder>();
            for (Block oldPos : old) {
                tasks1.add(new BlockBuilder(oldPos, arg, bagPosFeaturesWithLiteralsInDomain, domains, current, this.domainComputing, this.pruning, this.syntaxCheckers));
            }
            Sugar.runInParallel(tasks1, TreeLikerSettings.PROCESSORS);
            current = Sugar.listFromCollections(this.pruning.filterRedundantBlocksInParallel(current, domains));
            old = current;
            current = Collections.synchronizedList(new ArrayList());
        }
        return old;
    }

    public void setMinFrequency(int minFreq) {
        this.pruning.setMinFrequencyOnCoveredClass(minFreq);
    }

    private static List<PredicateDefinition> buildOpenList(Collection<PredicateDefinition> defs) {
        return FeatureSearchUtils.buildPredicateList(defs);
    }

    public void addProgressListener(ProgressListener pl) {
        this.progressListeners.add(pl);
    }

    public void addSyntaxChecker(SyntaxChecker syntaxChecker) {
        this.syntaxCheckers.add(syntaxChecker);
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    private static String monomialToString(Tuple<Integer> exponents) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < exponents.size(); ++i) {
            if (exponents.get(i) == 0) continue;
            if (first) {
                first = false;
            } else {
                sb.append("*");
            }
            if (exponents.get(i) == 1) {
                sb.append("x").append(i + 1);
                continue;
            }
            sb.append("x").append(i + 1).append("^").append(exponents.get(i));
        }
        return sb.toString();
    }

    public void setUseGroundingCounting(boolean countTrueGroundings) {
        this.useGroundingCounting = countTrueGroundings;
    }
}

