/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.features.treeliker;

import cz.cvut.fel.ida.logic.Clause;
import cz.cvut.fel.ida.logic.Literal;
import cz.cvut.fel.ida.logic.Term;
import cz.cvut.fel.ida.utils.generic.tuples.Pair;
import cz.cvut.fel.ida.utils.math.VectorUtils;
import cz.cvut.fel.ida.utils.math.collections.ValueToIndex;
import java.util.HashSet;
import java.util.Set;

public final class PredicateDefinition {
    public static final int INPUT = 1;
    public static final int OUTPUT = 2;
    public static final int CONSTANT = 3;
    public static final int GLOBAL_CONSTANT = 4;
    public static final int IGNORE = 5;
    public static final int IDENTIFIER = 6;
    public static final int CLASS = 7;
    public static final int NUMBER = 8;
    public static final int AGGREGATOR = 9;
    private static ValueToIndex<Pair<String, Integer>> integerToPredicate = new ValueToIndex();
    private static ValueToIndex<String> integerToType = new ValueToIndex();
    private static int lastId;
    private int id;
    private int predicate;
    private int input;
    private int[] types;
    private int[] modes;
    private int[] originalModes;
    private int branchingModPredicate;
    private int[] branching;
    private boolean isOutputOnly;
    private boolean isInputOnly;
    private boolean isGlobalConstant;
    private boolean isConstant;
    private boolean hasNumber;
    private boolean containsAggregation;
    private int numAggregators;

    protected PredicateDefinition() {
    }

    public PredicateDefinition(int predicate, int[] types, int[] modes) {
        this(predicate, types, modes, new int[modes.length], 0);
    }

    public PredicateDefinition(int predicate, int[] types, int[] modes, int[] branching, int branchingModPredicate) {
        this(predicate, types, modes, branching, branchingModPredicate, modes);
    }

    public PredicateDefinition(int predicate, int[] types, int[] modes, int[] branching, int branchingModPredicate, int[] originalModes) {
        this.predicate = predicate;
        this.types = types;
        this.modes = modes;
        this.originalModes = originalModes;
        this.branching = branching;
        this.branchingModPredicate = branchingModPredicate;
        this.id = ++lastId;
        this.recomputeEverything();
    }

    private void recomputeEverything() {
        int outputs = 0;
        int inputs = 0;
        this.isConstant = false;
        this.isGlobalConstant = false;
        this.isInputOnly = false;
        this.isOutputOnly = false;
        this.hasNumber = false;
        this.containsAggregation = false;
        this.numAggregators = 0;
        for (int i = 0; i < this.modes.length; ++i) {
            if (this.modes[i] == 1) {
                this.input = i;
                ++inputs;
                continue;
            }
            if (this.modes[i] == 2) {
                ++outputs;
                continue;
            }
            if (this.modes[i] == 3) continue;
            if (this.modes[i] == 4) {
                this.isGlobalConstant = true;
                continue;
            }
            if (this.modes[i] == 8) {
                this.hasNumber = true;
                continue;
            }
            if (this.modes[i] != 9) continue;
            this.containsAggregation = true;
            ++this.numAggregators;
        }
        if (outputs == 0 && inputs > 0 && !this.isGlobalConstant) {
            this.isInputOnly = true;
        }
        if (inputs == 0 && !this.isGlobalConstant) {
            this.isOutputOnly = true;
        }
    }

    public void setMode(int mode, int index) {
        this.modes[index] = mode;
        this.recomputeEverything();
    }

    public int predicate() {
        return this.predicate;
    }

    public int arity() {
        return this.modes.length;
    }

    public int[] types() {
        return this.types;
    }

    public int[] modes() {
        return this.modes;
    }

    public int[] originalModes() {
        return this.originalModes;
    }

    public int[] branchingFactors() {
        return this.branching;
    }

    public int branchingModPredicate() {
        return this.branchingModPredicate;
    }

    public boolean isInputOnly() {
        return this.isInputOnly;
    }

    public boolean isOutputOnly() {
        return this.isOutputOnly;
    }

    public boolean isGlobalConstant() {
        return this.isGlobalConstant;
    }

    public boolean containsNumber() {
        return this.hasNumber;
    }

    public boolean containsAggregator() {
        return this.containsAggregation;
    }

    public int numAggregators() {
        return this.numAggregators;
    }

    public void setConstant(boolean isConstant) {
        this.isConstant = isConstant;
    }

    public boolean isConstant() {
        return this.isConstant;
    }

    public int hashCode() {
        return this.predicate;
    }

    public int input() {
        return this.input;
    }

    public String stringPredicate() {
        return (String)PredicateDefinition.integerToPredicate.indexToValue((int)this.predicate).r;
    }

    public String stringType(int index) {
        return integerToType.indexToValue(this.types[index]);
    }

    public boolean equals(Object o) {
        if (o instanceof PredicateDefinition) {
            PredicateDefinition def = (PredicateDefinition)o;
            if (def.predicate != this.predicate) {
                return false;
            }
            for (int i = 0; i < def.modes.length; ++i) {
                if (this.modes[i] != def.modes[i]) {
                    return false;
                }
                if (this.types[i] == def.types[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.branchingModPredicate == 0 || this.branchingModPredicate == Integer.MAX_VALUE) {
            sb.append(integerToPredicate.indexToValue(this.predicate)).append("(");
        } else {
            sb.append(integerToPredicate.indexToValue(this.predicate)).append("[").append(this.branchingModPredicate).append("](");
        }
        for (int i = 0; i < this.types.length; ++i) {
            if (this.modes[i] == 1) {
                sb.append("+");
            } else if (this.modes[i] == 2) {
                sb.append("-");
            } else if (this.modes[i] == 3) {
                sb.append("#");
            } else if (this.modes[i] == 4) {
                sb.append("@");
            } else if (this.modes[i] == 5) {
                sb.append("!");
            } else if (this.modes[i] == 6) {
                sb.append("&");
            } else if (this.modes[i] == 7) {
                sb.append("~");
            } else if (this.modes[i] == 8) {
                sb.append("$");
            } else if (this.modes[i] == 9) {
                sb.append("*");
            }
            if (this.branching[i] > 0 && this.branching[i] < Integer.MAX_VALUE) {
                sb.append(integerToType.indexToValue(this.types[i])).append("[").append(this.branching[i]).append("]");
            } else {
                sb.append(integerToType.indexToValue(this.types[i]));
            }
            if (i >= this.types.length - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    public PredicateDefinition cloneDefinition() {
        return new PredicateDefinition(this.predicate, VectorUtils.copyArray(this.types), VectorUtils.copyArray(this.modes), VectorUtils.copyArray(this.branching), this.branchingModPredicate, VectorUtils.copyArray(this.modes));
    }

    public static Set<PredicateDefinition> parseDefinition(String definition) {
        HashSet<PredicateDefinition> definitions = new HashSet<PredicateDefinition>();
        Clause parsedDefinition = Clause.parse(definition);
        for (Literal l : parsedDefinition.literals()) {
            int predicate = -1;
            predicate = l.predicate().name.indexOf(91) > 0 ? PredicateDefinition.predicateToInteger(l.predicate().name.substring(0, l.predicate().name.lastIndexOf(91)), l.arity()) : PredicateDefinition.predicateToInteger(l.predicate().name, l.arity());
            int[] types = new int[l.arity()];
            int[] modes = new int[l.arity()];
            int[] branching = new int[l.arity()];
            int branchingModPredicate = PredicateDefinition.parseParameter(l.predicate().name);
            for (int i = 0; i < l.arity(); ++i) {
                types[i] = PredicateDefinition.typeToInteger(l.get(i));
                modes[i] = PredicateDefinition.modeToInteger(l.get(i));
                branching[i] = PredicateDefinition.parseParameter(l.get(i));
            }
            PredicateDefinition pdef = new PredicateDefinition(predicate, types, modes, branching, branchingModPredicate);
            definitions.add(pdef);
        }
        return definitions;
    }

    private static int parseParameter(Term term) {
        return PredicateDefinition.parseParameter(term.toString());
    }

    private static int parseParameter(String t) {
        if (t.indexOf(91) > 0) {
            String substr = t.substring(t.indexOf(91) + 1, t.indexOf(93));
            return Integer.parseInt(substr.trim());
        }
        return Integer.MAX_VALUE;
    }

    private static int modeToInteger(Term term) {
        if (term.name().charAt(0) == '+') {
            return 1;
        }
        if (term.name().charAt(0) == '-') {
            return 2;
        }
        if (term.name().charAt(0) == '#') {
            return 3;
        }
        if (term.name().charAt(0) == '@') {
            return 4;
        }
        if (term.name().charAt(0) == '!') {
            return 5;
        }
        if (term.name().charAt(0) == '&') {
            return 6;
        }
        if (term.name().charAt(0) == '~') {
            return 7;
        }
        if (term.name().charAt(0) == '$') {
            return 8;
        }
        if (term.name().charAt(0) == '*') {
            return 9;
        }
        return -1;
    }

    private static int typeToInteger(Term type) {
        String t = type.name().substring(1);
        if (t.indexOf(91) > 0) {
            t = t.substring(0, t.indexOf(91));
        }
        return PredicateDefinition.typeToInteger(t.trim());
    }

    public int id() {
        return this.id;
    }

    public static int typeToInteger(String type) {
        return integerToType.valueToIndex(type);
    }

    public static String integerToType(int type) {
        return integerToType.indexToValue(type);
    }

    public static int predicateToInteger(String predicate, int arity) {
        return integerToPredicate.valueToIndex(new Pair<String, Integer>(predicate, arity));
    }

    public static String integerToPredicate(int predicate) {
        return (String)PredicateDefinition.integerToPredicate.indexToValue((int)predicate).r;
    }
}

