/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.features.treeliker;

import cz.cvut.fel.ida.logic.Clause;
import cz.cvut.fel.ida.logic.Constant;
import cz.cvut.fel.ida.logic.Literal;
import cz.cvut.fel.ida.logic.LogicUtils;
import cz.cvut.fel.ida.logic.features.treeliker.Block;
import cz.cvut.fel.ida.logic.features.treeliker.Dataset;
import cz.cvut.fel.ida.logic.features.treeliker.Example;
import cz.cvut.fel.ida.logic.features.treeliker.HiFi;
import cz.cvut.fel.ida.logic.features.treeliker.MemoryBasedDataset;
import cz.cvut.fel.ida.logic.features.treeliker.Poly;
import cz.cvut.fel.ida.logic.features.treeliker.PredicateDefinition;
import cz.cvut.fel.ida.logic.features.treeliker.Preprocessor;
import cz.cvut.fel.ida.logic.features.treeliker.RelF;
import cz.cvut.fel.ida.logic.features.treeliker.Table;
import cz.cvut.fel.ida.logic.features.treeliker.aggregables.GroundingCountingAggregablesBuilder;
import cz.cvut.fel.ida.logic.features.treeliker.aggregables.VoidAggregablesBuilder;
import cz.cvut.fel.ida.utils.generic.tuples.Pair;
import cz.cvut.fel.ida.utils.generic.tuples.Triple;
import cz.cvut.fel.ida.utils.math.Sugar;
import cz.cvut.fel.ida.utils.math.VectorUtils;
import cz.cvut.fel.ida.utils.math.collections.IntegerSet;
import cz.cvut.fel.ida.utils.math.collections.MultiList;
import cz.cvut.fel.ida.utils.math.collections.MultiMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Stack;

public class Propositionalization {
    private double minFrequency = 0.0;
    static boolean filterIrrelevantSubfeatures = true;
    private int seed = 1;
    private int maxDegree = 1;
    public static final int RELF = 3;
    public static final int HIFI = 4;
    public static final int HIFI_GROUNDING_COUNTING = 6;
    public static final int RELF_GROUNDING_COUNTING = 7;
    public static final int POLY = 9;
    public static final int POLY_GROUNDING_COUNTING = 10;
    private Set<String> coveredClasses = null;
    private int foldsCount = 10;
    private boolean constructFeaturesOnlyFromFirstExample = false;
    private boolean useSampling = false;
    private int sampleSize = 10;
    private int numSamples = 10;
    private Block normalizationFactor;

    public Table<String, String> relf(String template, Reader reader) throws IOException {
        return this.propositionalize(template, Integer.MAX_VALUE, reader, 3);
    }

    public Table<String, String> relf(String modeDeclarations, Reader reader, int mode) throws IOException {
        if (mode != 3 && mode != 7) {
            throw new IllegalArgumentException("The argument must be either RELF or RELF_GROUNDING_COUNTING");
        }
        return this.propositionalize(modeDeclarations, Integer.MAX_VALUE, reader, mode);
    }

    public Table<String, String> hifi(String template, int maxFeatureLength, Reader reader, int mode) throws IOException {
        if (mode != 4 && mode != 6) {
            throw new IllegalArgumentException("The argument must be either HIFI or HIFI_GROUNDING_COUNTING");
        }
        return this.propositionalize(template, maxFeatureLength, reader, mode);
    }

    public Table<String, String> poly(String template, int maxFeatureLength, Reader reader) throws IOException {
        return this.propositionalize(template, maxFeatureLength, reader, 9);
    }

    public Table<String, String> poly(String template, int maxFeatureLength, Reader reader, int mode) throws IOException {
        if (mode != 9 && mode != 10) {
            throw new IllegalArgumentException("The argument must be either POLY or POLY_GROUNDING_COUNTING");
        }
        return this.propositionalize(template, maxFeatureLength, reader, mode);
    }

    private Table<String, String> propositionalize(String template, int maxSize, Reader reader, int mode) throws IOException {
        Triple<List<Set<PredicateDefinition>>, List<PredicateDefinition>, Dataset> preprocessed = this.readDataset(template, reader);
        Set<Block> features = this.constructFeatures((Collection)preprocessed.r, (List)preprocessed.s, (Dataset)preprocessed.t, mode, maxSize);
        return this.buildTable(features, (List)preprocessed.s, (Dataset)preprocessed.t, mode).transform(new Sugar.Fun<Integer, String>(){

            @Override
            public String apply(Integer t) {
                return String.valueOf(t);
            }
        }, new Sugar.IdentityFun(), new Sugar.IdentityFun<String>());
    }

    private Set<Block> constructFeaturesUsingSampling_impl(Collection<Set<PredicateDefinition>> templates, Dataset dataset, int mode, int maxSize) {
        HashSet<Block> retVal = new HashSet<Block>();
        Random rand = new Random(this.seed);
        for (int i = 0; i < this.numSamples; ++i) {
            Dataset subsampled = dataset.subsample(this.sampleSize, rand.nextInt());
            retVal.addAll(this.constructFeatures_impl(templates, subsampled, mode, maxSize));
        }
        return retVal;
    }

    private Set<Block> constructFeatures(Collection<Set<PredicateDefinition>> templates, List<PredicateDefinition> globalConstants, Dataset dataset, int mode, int maxSize) {
        if (this.useSampling) {
            return this.constructFeaturesUsingSampling_impl(templates, dataset, mode, maxSize);
        }
        return this.constructFeatures_impl(templates, dataset, mode, maxSize);
    }

    private Set<Block> constructFeatures_impl(Collection<Set<PredicateDefinition>> templates, Dataset dataset, int mode, int maxSize) {
        HashSet<Block> retVal = new HashSet<Block>();
        for (Set<PredicateDefinition> def : templates) {
            if (mode == 3 || mode == 7) {
                Collection<String> tsclasses = dataset.classes();
                for (String cl : tsclasses) {
                    if (this.coveredClasses != null && !this.coveredClasses.contains(cl) && !this.coveredClasses.contains("'" + cl + "'") && !this.coveredClasses.contains(LogicUtils.unquote(Constant.construct(cl)).name())) continue;
                    RelF relf = new RelF(dataset, cl);
                    if (mode == 7) {
                        relf.setFeatureMode(2);
                    }
                    if (this.minFrequency > 0.0) {
                        relf.setMinFrequencyOnClass(Math.max(1, (int)(this.minFrequency * (double)dataset.countExamples(cl))));
                    }
                    retVal.addAll(relf.constructFeatures(def));
                }
                continue;
            }
            if (mode == 4 || mode == 6) {
                HiFi featureConstructionHifi = new HiFi(dataset);
                featureConstructionHifi.setMaxSize(maxSize);
                if (mode == 6) {
                    featureConstructionHifi.setAggregablesBuilder(GroundingCountingAggregablesBuilder.construct());
                    featureConstructionHifi.setPostProcessingAggregablesBuilder(GroundingCountingAggregablesBuilder.construct());
                }
                if (this.minFrequency > 0.0) {
                    featureConstructionHifi.setMinFrequency(Math.max(1, (int)(this.minFrequency * (double)dataset.countExamples())));
                }
                featureConstructionHifi.setMaxSize(maxSize);
                if (this.minFrequency > 0.0) {
                    featureConstructionHifi.setMinFrequency(Math.max(1, (int)(this.minFrequency * (double)dataset.countExamples())));
                }
                retVal.addAll(featureConstructionHifi.constructFeatures(def));
                continue;
            }
            if (mode != 9 && mode != 10) continue;
            Poly featureConstructionHiFi = null;
            if (this.constructFeaturesOnlyFromFirstExample) {
                MemoryBasedDataset smallDataset = new MemoryBasedDataset();
                dataset.reset();
                if (dataset.hasNextExample()) {
                    smallDataset.addExample(dataset.nextExample(), dataset.classificationOfCurrentExample());
                }
                featureConstructionHiFi = new Poly(smallDataset);
            } else {
                featureConstructionHiFi = new Poly(dataset);
            }
            if (mode == 9) {
                featureConstructionHiFi.setUseGroundingCounting(false);
            } else if (mode == 10) {
                featureConstructionHiFi.setUseGroundingCounting(true);
            }
            featureConstructionHiFi.setMaxSize(maxSize);
            if (this.minFrequency > 0.0) {
                featureConstructionHiFi.setMinFrequency(Math.max(1, (int)(this.minFrequency * (double)dataset.countExamples())));
            }
            retVal.addAll(featureConstructionHiFi.constructFeatures(def, this.maxDegree));
        }
        return retVal;
    }

    private void makeCompatible(Table<Integer, String> trainTable, Table<Integer, String> testTable, int mode) {
        if (mode == 4 || mode == 3) {
            Set<String> values;
            for (String attribute : trainTable.attributes()) {
                values = trainTable.getAttributeValues(attribute);
                if (values.size() != 1 || !Sugar.chooseOne(values).equals("+")) continue;
                trainTable.addAdditionalUnseenValue(attribute, "-");
            }
            for (String attribute : testTable.attributes()) {
                values = testTable.getAttributeValues(attribute);
                if (values.size() != 1 || !Sugar.chooseOne(values).equals("+")) continue;
                testTable.addAdditionalUnseenValue(attribute, "-");
            }
        }
        trainTable.makeCompatible(testTable);
        testTable.makeCompatible(trainTable);
    }

    private Table<Integer, String> buildTable(Collection<Block> features, List<PredicateDefinition> globalConstants, Dataset dataset, int mode) {
        Table<Integer, String> table = new Table<Integer, String>();
        ArrayList<Block> nonConstantAttributes = new ArrayList<Block>();
        ArrayList<Block> globalConstantAttributes = new ArrayList<Block>();
        for (Block attribute : features) {
            if (attribute.definition().isGlobalConstant()) {
                globalConstantAttributes.add(attribute);
                continue;
            }
            nonConstantAttributes.add(attribute);
        }
        Dataset copyOfDataset = dataset.shallowCopy();
        copyOfDataset.reset();
        while (copyOfDataset.hasNextExample()) {
            Example example = copyOfDataset.nextExample();
            table.addClassification(copyOfDataset.currentIndex(), copyOfDataset.classificationOfCurrentExample());
            this.addGlobalConstants(example, copyOfDataset.currentIndex(), table, globalConstants);
        }
        if (mode == 4 || mode == 6 || mode == 3 || mode == 7) {
            HiFi tableConstructionHifi = new HiFi(dataset);
            if (mode == 6 || mode == 7) {
                tableConstructionHifi.setAggregablesBuilder(VoidAggregablesBuilder.construct());
                tableConstructionHifi.setPostProcessingAggregablesBuilder(GroundingCountingAggregablesBuilder.construct());
            }
            if (this.normalizationFactor != null) {
                tableConstructionHifi.setNormalizationFactor(this.normalizationFactor);
            }
            table.addAll(tableConstructionHifi.constructTable(nonConstantAttributes));
        } else if (mode == 9 || mode == 10) {
            Poly tableConstructionHiFi = new Poly(dataset);
            if (mode == 9) {
                tableConstructionHiFi.setUseGroundingCounting(false);
            } else if (mode == 10) {
                tableConstructionHiFi.setUseGroundingCounting(true);
            }
            table.addAll(tableConstructionHiFi.constructTable(nonConstantAttributes));
        }
        return table;
    }

    public void trainTest(String template, int maxSize, int[] trainSet, int[] testSet, Reader examples, String directory, int mode) throws IOException {
        this.trainTest_impl(template, maxSize, trainSet, testSet, examples, new File(directory + "/train.arff"), new File(directory + "/train.arff"), mode);
    }

    public void trainTest(String template, int maxSize, Reader trainReader, Reader testReader, String directory, int mode) throws IOException {
        ArrayList<Clause> clauses = new ArrayList<Clause>();
        ArrayList<String> classifications = new ArrayList<String>();
        this.readExamples(trainReader, clauses, classifications);
        int[] trainSetIndices = new int[clauses.size()];
        for (int i = 0; i < trainSetIndices.length; ++i) {
            trainSetIndices[i] = i;
        }
        this.readExamples(testReader, clauses, classifications);
        int[] testSetIndices = new int[clauses.size() - trainSetIndices.length];
        for (int i = 0; i < testSetIndices.length; ++i) {
            testSetIndices[i] = i + trainSetIndices.length;
        }
        Triple<List<Set<PredicateDefinition>>, List<PredicateDefinition>, Dataset> preprocessed = this.preprocessDataset(clauses, classifications, PredicateDefinition.parseDefinition(template));
        this.trainTest_impl((Dataset)preprocessed.t, (List)preprocessed.r, (List)preprocessed.s, maxSize, trainSetIndices, testSetIndices, new File(directory + "/train.arff"), new File(directory + "/test.arff"), mode);
    }

    private void trainTest_impl(String template, int maxSize, int[] trainSetIndices, int[] testSetIndices, Reader exampleReader, File trainOutput, File testOutput, int mode) throws IOException {
        ArrayList<Clause> clauses = new ArrayList<Clause>();
        ArrayList<String> classifications = new ArrayList<String>();
        this.readExamples(exampleReader, clauses, classifications);
        Triple<List<Set<PredicateDefinition>>, List<PredicateDefinition>, Dataset> preprocessed = this.preprocessDataset(clauses, classifications, PredicateDefinition.parseDefinition(template));
        this.trainTest_impl((Dataset)preprocessed.t, (List)preprocessed.r, (List)preprocessed.s, maxSize, trainSetIndices, testSetIndices, trainOutput, testOutput, mode);
    }

    private void trainTest_impl(Dataset allExamples, List<Set<PredicateDefinition>> preprocessedTemplate, List<PredicateDefinition> globalConstants, int maxSize, int[] trainSetIndices, int[] testSetIndices, File trainOutput, File testOutput, int mode) throws IOException {
        File dir2;
        Dataset trainSet = allExamples.get(trainSetIndices);
        Set<Block> features = this.constructFeatures(preprocessedTemplate, globalConstants, trainSet, mode, maxSize);
        Table<Integer, String> trainTable = this.buildTable(features, globalConstants, trainSet, mode);
        Dataset testSet = allExamples.get(testSetIndices);
        Table<Integer, String> testTable = this.buildTable(features, globalConstants, testSet, mode);
        this.makeCompatible(trainTable, testTable, mode);
        File dir1 = trainOutput.getParentFile();
        if (!dir1.exists()) {
            dir1.mkdirs();
        }
        if (!(dir2 = trainOutput.getParentFile()).exists()) {
            dir2.mkdirs();
        }
        FileWriter trainWriter = new FileWriter(trainOutput);
        FileWriter testWriter = new FileWriter(testOutput);
        trainTable.saveWithoutFiltering(trainWriter);
        testTable.saveWithoutFiltering(testWriter);
        ((Writer)trainWriter).close();
        ((Writer)testWriter).close();
        trainSet.reset();
    }

    public void cv(String template, int maxSize, Reader examples, String directory, int mode) throws IOException {
        Set<PredicateDefinition> definitions = PredicateDefinition.parseDefinition(template);
        this.cv_impl(definitions, maxSize, examples, directory, mode);
    }

    private void cv_impl(Set<PredicateDefinition> template, int maxSize, Reader exampleReader, String directory, int mode) throws IOException {
        ArrayList<Clause> clauses = new ArrayList<Clause>();
        ArrayList<String> classifications = new ArrayList<String>();
        this.readExamples(exampleReader, clauses, classifications);
        Triple<List<Set<PredicateDefinition>>, List<PredicateDefinition>, Dataset> preprocessed = this.preprocessDataset(clauses, classifications, template);
        List<int[]> folds = this.constructStratifiedFolds(classifications, this.foldsCount, this.seed);
        for (int i = 0; i < this.foldsCount; ++i) {
            Pair<int[], int[]> trainTestSplit = this.constructTrainTestSplit(folds, i);
            this.trainTest_impl((Dataset)preprocessed.t, (List)preprocessed.r, (List)preprocessed.s, maxSize, (int[])trainTestSplit.r, (int[])trainTestSplit.s, new File(directory + "/train_" + (i + 1) + ".arff"), new File(directory + "/test_" + (i + 1) + ".arff"), mode);
            System.out.println("Fold " + (i + 1) + " done!\n");
        }
    }

    private Pair<int[], int[]> constructTrainTestSplit(List<int[]> folds, int foldIndex) {
        if (folds.size() == 1) {
            return new Pair<int[], int[]>(folds.get(0), new int[0]);
        }
        ArrayList<Integer> train = new ArrayList<Integer>();
        int[] test = folds.get(foldIndex);
        for (int i = 0; i < folds.size(); ++i) {
            if (i == foldIndex) continue;
            for (int exampleIndex : folds.get(i)) {
                train.add(exampleIndex);
            }
        }
        return new Pair<int[], int[]>(VectorUtils.toIntegerArray(train), test);
    }

    /*
     * WARNING - void declaration
     */
    private List<int[]> constructStratifiedFolds(List<String> classifications, int foldsCount, int seed) {
        void var7_10;
        MultiList<String, Integer> classes = new MultiList<String, Integer>();
        for (int i = 0; i < classifications.size(); ++i) {
            String classification = classifications.get(i);
            classes.put(classification, i);
        }
        Random random = new Random(seed);
        for (List list : classes.values()) {
            Collections.shuffle(list, random);
        }
        ArrayList<int[]> folds = new ArrayList<int[]>();
        boolean bl = false;
        while (var7_10 < foldsCount) {
            ArrayList<Integer> fold = new ArrayList<Integer>();
            for (Map.Entry entry : classes.entrySet()) {
                void j;
                List c = entry.getValue();
                if (var7_10 < foldsCount - 1) {
                    for (j = var7_10 * c.size() / foldsCount; j < (var7_10 + true) * c.size() / foldsCount; ++j) {
                        fold.add((Integer)c.get((int)j));
                    }
                    continue;
                }
                for (j = var7_10 * c.size() / foldsCount; j < c.size(); ++j) {
                    fold.add((Integer)c.get((int)j));
                }
            }
            folds.add(VectorUtils.toIntegerArray(fold));
            ++var7_10;
        }
        return folds;
    }

    private Triple<List<Set<PredicateDefinition>>, List<PredicateDefinition>, Dataset> readDataset(String template, Reader datasetReader) throws IOException {
        ArrayList<Clause> clauses = new ArrayList<Clause>();
        ArrayList<String> classifications = new ArrayList<String>();
        this.readExamples(datasetReader, clauses, classifications);
        return this.preprocessDataset(clauses, classifications, PredicateDefinition.parseDefinition(template));
    }

    private Triple<List<Set<PredicateDefinition>>, List<PredicateDefinition>, Dataset> preprocessDataset(List<Clause> clauses, List<String> classifications, Set<PredicateDefinition> literalDefinitions) {
        ArrayList<PredicateDefinition> globalConstants = new ArrayList<PredicateDefinition>();
        for (PredicateDefinition def : literalDefinitions) {
            if (!def.isGlobalConstant()) continue;
            globalConstants.add(def);
        }
        Pair<Set<PredicateDefinition>, Dataset> pair = this.preprocess_impl(literalDefinitions, globalConstants, clauses, classifications);
        clauses = null;
        ArrayList<PredicateDefinition> outputOnlyLiteralDefinitions = new ArrayList<PredicateDefinition>();
        LinkedHashSet<PredicateDefinition> remainingLiteralDefinitions = new LinkedHashSet<PredicateDefinition>();
        for (PredicateDefinition def : (Set)pair.r) {
            if (def.isOutputOnly()) {
                outputOnlyLiteralDefinitions.add(def);
                continue;
            }
            remainingLiteralDefinitions.add(def);
        }
        ArrayList definitionsList = new ArrayList();
        for (PredicateDefinition output : outputOnlyLiteralDefinitions) {
            definitionsList.add(Sugar.setFromCollections(this.connectedComponent(output, remainingLiteralDefinitions), Sugar.set(output)));
        }
        return new Triple<List<Set<PredicateDefinition>>, List<PredicateDefinition>, Dataset>(definitionsList, globalConstants, (Dataset)pair.s);
    }

    private void readExamples(Reader exampleReader, List<Clause> clauses, List<String> classifications) throws IOException {
        int index = 0;
        BufferedReader br = new BufferedReader(exampleReader);
        String line = null;
        index = 0;
        while ((line = br.readLine()) != null) {
            int indexOfSecondQuote;
            if ((line = line.trim()).length() <= 1 || line.indexOf(" ") == -1 && line.indexOf("\"") == -1 && line.indexOf("'") == -1) continue;
            Object classification = null;
            String clausePart = null;
            if (line.charAt(0) == '\"') {
                indexOfSecondQuote = line.indexOf("\"", 1);
                classification = line.substring(1, indexOfSecondQuote);
                clausePart = line.substring(indexOfSecondQuote + 1);
            } else if (line.charAt(0) == '\'') {
                indexOfSecondQuote = line.indexOf("'", 1);
                classification = "'" + line.substring(1, indexOfSecondQuote) + "'";
                clausePart = line.substring(indexOfSecondQuote + 1);
            } else {
                classification = "'" + line.substring(0, line.indexOf(" ")) + "'";
                clausePart = line.substring(line.indexOf(" ") + 1);
            }
            classifications.add((String)classification);
            clauses.add(Clause.parse(clausePart));
            ++index;
        }
    }

    private void addGlobalConstants(Example example, int exampleIndex, Table<Integer, String> t, List<PredicateDefinition> globalConstants) {
        for (PredicateDefinition def : globalConstants) {
            IntegerSet domain = example.getLiteralDomain(def.predicate());
            if (domain.size() == 1) {
                int literalId = domain.values()[0];
                Literal literal = example.integerToLiteral(literalId);
                for (int i = 0; i < def.modes().length; ++i) {
                    if (def.modes()[i] != 4) continue;
                    if (literal.arity() == 1) {
                        t.add(exampleIndex, def.stringPredicate(), literal.get(i).toString());
                        continue;
                    }
                    System.out.println("Warning: " + String.valueOf(def) + " cannot be used as global constant because its arity is not equal to one!!!!");
                }
                continue;
            }
            if (domain.size() > 1) {
                System.out.println("Warning: " + String.valueOf(def) + " cannot be used as global constant because there are more than one literals of the kind " + String.valueOf(def) + " in the example being processed or there is none!!!!");
                continue;
            }
            System.out.println("Warning: " + String.valueOf(def) + " cannot be used as global constant because there are no literals of the kind " + String.valueOf(def) + " in the example being processed or there is none!!!!");
        }
    }

    private Set<PredicateDefinition> processDefinitions(Set<PredicateDefinition> definitions) {
        HashSet<PredicateDefinition> retVal = new HashSet<PredicateDefinition>();
        for (PredicateDefinition def : definitions) {
            PredicateDefinition clone = def.cloneDefinition();
            int[] modes = def.modes();
            for (int i = 0; i < def.arity(); ++i) {
                if (modes[i] != 6 && modes[i] != 7) continue;
                clone.setMode(5, i);
            }
            retVal.add(clone);
        }
        return retVal;
    }

    private Pair<Set<PredicateDefinition>, Dataset> preprocess_impl(Set<PredicateDefinition> template, List<PredicateDefinition> globalConstants, List<Clause> examples, List<String> classifications) {
        LinkedHashSet<PredicateDefinition> modifiedTemplate = new LinkedHashSet<PredicateDefinition>();
        MemoryBasedDataset mbe = new MemoryBasedDataset();
        int index = 0;
        template = this.processDefinitions(template);
        ListIterator<Clause> li = examples.listIterator();
        while (li.hasNext()) {
            Clause reachableExample = Preprocessor.reachableLiterals(template, globalConstants, li.next());
            li.set(null);
            LinkedHashSet<Literal> literals = new LinkedHashSet<Literal>();
            LinkedHashSet<String> constants = new LinkedHashSet<String>();
            for (PredicateDefinition def : template) {
                Collection<Literal> eLiterals = reachableExample.getLiteralsByPredicate(def.stringPredicate());
                PredicateDefinition cloned = def.cloneDefinition();
                for (int i = 0; i < def.modes().length; ++i) {
                    if (def.modes()[i] != 3) continue;
                    cloned.setMode(2, i);
                    for (Literal constLit : eLiterals) {
                        boolean prune;
                        StringBuilder sb = new StringBuilder();
                        try {
                            sb.append(constLit.get(i).toString());
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            System.err.println("Problem with " + String.valueOf(reachableExample));
                        }
                        constants.add(constLit.get(i).toString());
                        sb.append("(+");
                        sb.append(def.stringType(i));
                        sb.append("[1]), ");
                        PredicateDefinition constantDefinition = Sugar.chooseOne(PredicateDefinition.parseDefinition(sb.toString()));
                        if (constantDefinition != null && !(prune = false)) {
                            constantDefinition.setConstant(true);
                            modifiedTemplate.add(constantDefinition);
                        }
                        Literal newLiteral = new Literal(constLit.get(i).toString(), 1);
                        newLiteral.set(constLit.get(i), 0);
                        literals.add(newLiteral);
                    }
                }
                modifiedTemplate.add(cloned);
            }
            literals.addAll(reachableExample.literals());
            mbe.addExample(new Example(new Clause(literals)), classifications.get(index));
            ++index;
        }
        return new Pair<Set<PredicateDefinition>, Dataset>(modifiedTemplate, mbe);
    }

    private static boolean consistsOfMegaExamples(Set<PredicateDefinition> defs) {
        for (PredicateDefinition def : defs) {
            int[] modes = def.modes();
            for (int i = 0; i < def.arity(); ++i) {
                if (modes[i] != 6) continue;
                return true;
            }
        }
        return false;
    }

    public void setMinFrequency(double minFreq) {
        this.minFrequency = minFreq;
    }

    public void setRelfCoveredClasses(Set<String> coveredClasses) {
        this.coveredClasses = coveredClasses;
    }

    private Set<PredicateDefinition> connectedComponent(PredicateDefinition output, Set<PredicateDefinition> other) {
        HashSet<PredicateDefinition> closed = new HashSet<PredicateDefinition>();
        MultiMap<String, PredicateDefinition> inputToPredicate = new MultiMap<String, PredicateDefinition>();
        for (PredicateDefinition def : other) {
            String inputType = def.stringType(def.input());
            inputToPredicate.put(inputType, def);
        }
        Stack<PredicateDefinition> open = new Stack<PredicateDefinition>();
        open.push(output);
        while (open.size() > 0) {
            PredicateDefinition def;
            def = (PredicateDefinition)open.pop();
            closed.add(def);
            for (int i = 0; i < def.modes().length; ++i) {
                if (def.modes()[i] != 2) continue;
                for (PredicateDefinition d : inputToPredicate.get(def.stringType(i))) {
                    if (closed.contains(d)) continue;
                    open.push(d);
                }
            }
        }
        return closed;
    }

    public void setFoldsCount(int folds) {
        this.foldsCount = folds;
    }

    public void setConstructFeaturesOnlyFromFirstExample(boolean constructFeaturesOnlyFromFirstExample) {
        this.constructFeaturesOnlyFromFirstExample = constructFeaturesOnlyFromFirstExample;
    }

    public void setMaxDegree(int maxDegree) {
        this.maxDegree = maxDegree;
    }

    public void setSampleSize(int sampleSize) {
        this.sampleSize = sampleSize;
    }

    public void setNumSamples(int numSamples) {
        this.numSamples = numSamples;
    }

    public void setUseSampling(boolean useSampling) {
        this.useSampling = useSampling;
    }

    public void setNormalizationFactor(Block feature) {
        this.normalizationFactor = feature;
    }
}

