/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.features.treeliker;

import cz.cvut.fel.ida.logic.features.treeliker.AggregablesBuilder;
import cz.cvut.fel.ida.logic.features.treeliker.Block;
import cz.cvut.fel.ida.logic.features.treeliker.Dataset;
import cz.cvut.fel.ida.logic.features.treeliker.Domain;
import cz.cvut.fel.ida.logic.features.treeliker.Join;
import cz.cvut.fel.ida.logic.features.treeliker.JoinAndInt;
import cz.cvut.fel.ida.logic.features.treeliker.PredicateDefinition;
import cz.cvut.fel.ida.logic.features.treeliker.ProgressListener;
import cz.cvut.fel.ida.logic.features.treeliker.SyntaxChecker;
import cz.cvut.fel.ida.logic.features.treeliker.TreeLikerSettings;
import cz.cvut.fel.ida.logic.features.treeliker.aggregables.VoidAggregablesBuilder;
import cz.cvut.fel.ida.logic.features.treeliker.impl.BlockBuilder;
import cz.cvut.fel.ida.logic.features.treeliker.impl.BlocksWithLiteralsInDomainBuilder;
import cz.cvut.fel.ida.logic.features.treeliker.impl.CombinationsBuilder;
import cz.cvut.fel.ida.logic.features.treeliker.impl.DomainComputing;
import cz.cvut.fel.ida.logic.features.treeliker.impl.FeatureSearchUtils;
import cz.cvut.fel.ida.logic.features.treeliker.impl.HSubsumption;
import cz.cvut.fel.ida.logic.features.treeliker.impl.Pruning;
import cz.cvut.fel.ida.logic.features.treeliker.impl.TermsInDomainsOfBuilder;
import cz.cvut.fel.ida.utils.generic.tuples.Pair;
import cz.cvut.fel.ida.utils.math.Sugar;
import cz.cvut.fel.ida.utils.math.VectorUtils;
import cz.cvut.fel.ida.utils.math.collections.MultiList;
import cz.cvut.fel.ida.utils.math.collections.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class RelF {
    private List<ProgressListener> progressListeners = new ArrayList<ProgressListener>();
    public static final int EXISTENTIAL = 1;
    public static final int GROUNDINGS = 2;
    private int featureMode = 1;
    private Dataset examples;
    private boolean[] mask;
    private boolean[] negMask;
    private boolean alive = true;
    protected static int LITERALS = 1;
    protected static int TERMS = 2;
    private HSubsumption hsubsumptionEngine = new HSubsumption();
    private DomainComputing domainComputing;
    private Pruning pruning;
    private List<SyntaxChecker> syntaxCheckers = new ArrayList<SyntaxChecker>();
    private AggregablesBuilder aggregablesBuilder = VoidAggregablesBuilder.construct();

    public RelF(Dataset examples) {
        this(examples, "+");
    }

    public RelF(Dataset examples, String coveredClass) {
        this.examples = examples;
        this.mask = new boolean[examples.countExamples()];
        this.domainComputing = new DomainComputing(this.examples.shallowCopy());
        examples.reset();
        int i = 0;
        while (examples.hasNextExample()) {
            examples.nextExample();
            if (examples.classificationOfCurrentExample().equals(coveredClass)) {
                this.mask[i] = true;
            }
            ++i;
        }
        this.negMask = VectorUtils.not(this.mask);
        this.pruning = new Pruning(this.mask, this.negMask, 1);
    }

    /*
     * WARNING - void declaration
     */
    public List<Block> constructFeatures(Set<PredicateDefinition> definitions) {
        void var6_11;
        Object modes;
        if (!this.alive) {
            throw new IllegalStateException("Each instance of class RelF can be used only once.");
        }
        this.alive = false;
        ArrayList<Block> constructedFeatures = new ArrayList<Block>();
        MultiList<Integer, Object> mm = new MultiList<Integer, Object>();
        List<PredicateDefinition> open = RelF.buildOpenList(definitions);
        for (ProgressListener progressListener : this.progressListeners) {
            progressListener.readingExamples();
        }
        ArrayList<PredicateDefinition> inputOnlyDefinitions = new ArrayList<PredicateDefinition>();
        for (PredicateDefinition predicateDefinition : open) {
            if (!predicateDefinition.isInputOnly()) continue;
            inputOnlyDefinitions.add(predicateDefinition);
        }
        open = Sugar.listDifference(open, inputOnlyDefinitions);
        for (PredicateDefinition predicateDefinition : inputOnlyDefinitions) {
            if (TreeLikerSettings.VERBOSITY > 0) {
                System.out.println("Processing: " + String.valueOf(predicateDefinition));
            }
            for (ProgressListener pl : this.progressListeners) {
                pl.processingPredicate(predicateDefinition);
            }
            if (!predicateDefinition.isInputOnly()) continue;
            ArrayList<Block> generatedPosFeatures = new ArrayList<Block>();
            Block posFeat = new Block(predicateDefinition, this.aggregablesBuilder);
            modes = predicateDefinition.modes();
            for (int j = 0; j < ((int[])modes).length; ++j) {
                if (modes[j] != 1) continue;
                generatedPosFeatures.add(posFeat);
            }
            mm.putAll(predicateDefinition.types()[predicateDefinition.input()], generatedPosFeatures);
        }
        for (Map.Entry entry : mm.copy().entrySet()) {
            ConcurrentHashMap<Integer, Domain[]> computedDomains = this.domainComputing.computeTermDomainsInParallel(entry.getValue());
            Collection<Block> filtered = this.pruning.filterIrrelevantBlocksInParallel(this.pruning.filterRedundantBlocksInParallel(entry.getValue(), computedDomains), (Map<Integer, Domain[]>)computedDomains);
            mm.set((Integer)entry.getKey(), filtered);
        }
        this.examples.reset();
        boolean bl = false;
        while (var6_11 < open.size()) {
            PredicateDefinition predicateDefinition = open.get((int)var6_11);
            if (TreeLikerSettings.VERBOSITY > 0) {
                System.out.println("Processing: " + String.valueOf(predicateDefinition));
            }
            for (ProgressListener pl : this.progressListeners) {
                pl.processingPredicate(predicateDefinition);
            }
            List<Collection<Join>> combinations = Collections.synchronizedList(new ArrayList());
            for (int j = 0; j < predicateDefinition.modes().length; ++j) {
                if (predicateDefinition.modes()[j] == 2) {
                    combinations.add(this.combinationsOfPosFeatures(mm, predicateDefinition.types()[j], predicateDefinition.branchingFactors()[j]));
                    continue;
                }
                combinations.add(new ArrayList());
            }
            Collection<Block> newBlocks = this.buildBlocksFromCombinations(predicateDefinition, combinations);
            if (predicateDefinition.isOutputOnly()) {
                modes = newBlocks.iterator();
                while (modes.hasNext()) {
                    Block newFeature = (Block)modes.next();
                    constructedFeatures.add(newFeature);
                }
            } else if (mm.containsKey(predicateDefinition.types()[predicateDefinition.input()])) {
                ConcurrentHashMap<Integer, Domain[]> computedDomains = this.domainComputing.computeTermDomainsInParallel(Sugar.listFromCollections(newBlocks, mm.get(predicateDefinition.types()[predicateDefinition.input()])));
                Collection<Block> filtered = this.pruning.filterRedundantBlocksInParallel(Sugar.setFromCollections(newBlocks, mm.get(predicateDefinition.types()[predicateDefinition.input()])), computedDomains);
                filtered = this.pruning.filterIrrelevantBlocksInParallel(filtered, computedDomains);
                mm.set(Integer.valueOf(predicateDefinition.types()[predicateDefinition.input()]), filtered);
            } else {
                mm.putAll(predicateDefinition.types()[predicateDefinition.input()], newBlocks);
            }
            ++var6_11;
        }
        return constructedFeatures;
    }

    private Collection<Join> combinationsOfPosFeatures(MultiList posFeatures, int inputType, int branching) {
        MultiMap<Pair<Integer, Integer>, Block> termsInDomainsOf = new MultiMap<Pair<Integer, Integer>, Block>();
        List listOfBlocks = Sugar.listFromCollections(posFeatures.get(inputType));
        ConcurrentHashMap<Block, Integer> indices = new ConcurrentHashMap<Block, Integer>();
        ConcurrentHashMap<Integer, Block> posFeaturesLookup = new ConcurrentHashMap<Integer, Block>();
        for (int i = 0; i < listOfBlocks.size(); ++i) {
            indices.put((Block)listOfBlocks.get(i), i);
            posFeaturesLookup.put(((Block)listOfBlocks.get(i)).id(), (Block)listOfBlocks.get(i));
        }
        ConcurrentHashMap<Integer, Domain[]> computedDomainsOfBlocks = this.domainComputing.computeTermDomainsInParallel(listOfBlocks);
        ArrayList<TermsInDomainsOfBuilder> tasks0 = new ArrayList<TermsInDomainsOfBuilder>();
        for (Map<Integer, Domain[]> taskMap : Sugar.splitMap(computedDomainsOfBlocks, Runtime.getRuntime().availableProcessors())) {
            tasks0.add(new TermsInDomainsOfBuilder(termsInDomainsOf, taskMap, posFeaturesLookup, this.mask));
        }
        Sugar.runInParallel(tasks0);
        MultiList<Integer, JoinAndInt> hbl = new MultiList<Integer, JoinAndInt>();
        ConcurrentHashMap<Pair<Block, Block>, Boolean> hSubsumptions = new ConcurrentHashMap<Pair<Block, Block>, Boolean>();
        ConcurrentHashMap<List<Domain>, Integer> redundancyMap = new ConcurrentHashMap<List<Domain>, Integer>();
        for (int i = 0; i < listOfBlocks.size(); ++i) {
            hbl.put(1, new JoinAndInt(new Join((Block)listOfBlocks.get(i)), i));
        }
        ConcurrentHashMap<Integer, Domain[]> computedDomainsOfJoins = this.domainComputing.computeTermDomainsInParallel(hbl.get(1));
        for (int i = 1; i < branching; ++i) {
            List tasks1 = Collections.synchronizedList(new ArrayList());
            for (JoinAndInt tuplePair : hbl.get(i)) {
                CombinationsBuilder cb = new CombinationsBuilder(tuplePair, redundancyMap, indices, hSubsumptions, hbl, i, termsInDomainsOf, this.domainComputing, this.hsubsumptionEngine, this.pruning, this.syntaxCheckers);
                cb.setUseIrrelevancyFiltering(true);
                tasks1.add(cb);
            }
            Sugar.runInParallel(tasks1, Runtime.getRuntime().availableProcessors());
            Iterator iterator = tasks1.iterator();
            while (iterator.hasNext()) {
                CombinationsBuilder cb = (CombinationsBuilder)iterator.next();
                redundancyMap.putAll(cb.getRedundancyMap());
            }
            if (hbl.get(i + 1).isEmpty()) break;
            ConcurrentHashMap<Integer, Domain[]> iterator2 = this.domainComputing.computeTermDomainsInParallel(hbl.get(i + 1));
            Collection<JoinAndInt> filtered = this.pruning.filterIrrelevantCombinationsOfBlocksInParallel(this.pruning.filterRedundantCombinationsOfBlocksInParallel(hbl.get(i + 1), iterator2), iterator2);
            computedDomainsOfJoins.putAll(iterator2);
            hbl.set((Integer)(i + 1), filtered);
        }
        List<JoinAndInt> flattened = Collections.synchronizedList(new ArrayList());
        for (Map.Entry entry : hbl.entrySet()) {
            for (JoinAndInt pair : (List)entry.getValue()) {
                flattened.add(pair);
            }
        }
        List<Join> retVal = Collections.synchronizedList(new ArrayList());
        for (JoinAndInt pair : this.pruning.filterIrrelevantCombinationsOfBlocksInParallel(this.pruning.filterRedundantCombinationsOfBlocksInParallel(flattened, computedDomainsOfJoins), computedDomainsOfJoins)) {
            retVal.add((Join)pair.r);
        }
        return retVal;
    }

    private Collection<Block> buildBlocksFromCombinations(PredicateDefinition def, List<Collection<Join>> combinations) {
        MultiMap<Pair<Integer, Integer>, Join> bagPosFeaturesWithLiteralsInDomain = new MultiMap<Pair<Integer, Integer>, Join>();
        int argument = 0;
        for (Collection<Join> list : combinations) {
            ArrayList<BlocksWithLiteralsInDomainBuilder> tasks0 = new ArrayList<BlocksWithLiteralsInDomainBuilder>();
            for (Join join : list) {
                tasks0.add(new BlocksWithLiteralsInDomainBuilder(join, def.predicate(), argument, bagPosFeaturesWithLiteralsInDomain, this.examples));
            }
            Sugar.runInParallel(tasks0, Runtime.getRuntime().availableProcessors());
            ++argument;
        }
        Block root = new Block(def, this.aggregablesBuilder);
        List<Block> old = Sugar.list(root);
        List<Block> current = Collections.synchronizedList(new ArrayList());
        ConcurrentHashMap<Integer, Domain[]> domains = new ConcurrentHashMap<Integer, Domain[]>();
        domains.put(root.id(), this.domainComputing.computeLiteralDomains(root));
        for (int arg = 0; arg < def.modes().length; ++arg) {
            if (def.modes()[arg] != 2) continue;
            ArrayList<BlockBuilder> tasks1 = new ArrayList<BlockBuilder>();
            for (Block oldPos : old) {
                BlockBuilder bb = new BlockBuilder(oldPos, arg, bagPosFeaturesWithLiteralsInDomain, domains, current, this.domainComputing, this.pruning, this.syntaxCheckers);
                bb.setUseIrrelevancyFiltering(true);
                tasks1.add(bb);
            }
            Sugar.runInParallel(tasks1, TreeLikerSettings.PROCESSORS);
            current = Sugar.listFromCollections(this.pruning.filterIrrelevantBlocksInParallel(this.pruning.filterRedundantBlocksInParallel(current, domains), domains));
            old = current;
            current = Collections.synchronizedList(new ArrayList());
        }
        return old;
    }

    public void setMinFrequencyOnClass(int minFreq) {
        this.pruning.setMinFrequencyOnCoveredClass(minFreq);
    }

    private static List<PredicateDefinition> buildOpenList(Collection<PredicateDefinition> defs) {
        return FeatureSearchUtils.buildPredicateList(defs);
    }

    public void addProgressListener(ProgressListener pl) {
        this.progressListeners.add(pl);
    }

    public void setFeatureMode(int mode) {
        this.featureMode = mode;
    }

    public void setAggregablesBuilder(AggregablesBuilder aggregablesBuilder) {
        this.aggregablesBuilder = aggregablesBuilder;
    }

    public void addSyntaxChecker(SyntaxChecker syntaxChecker) {
        this.syntaxCheckers.add(syntaxChecker);
    }
}

