/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.features.treeliker;

import cz.cvut.fel.ida.logic.Clause;
import cz.cvut.fel.ida.logic.Literal;
import cz.cvut.fel.ida.logic.PrologList;
import cz.cvut.fel.ida.logic.features.treeliker.Block;
import cz.cvut.fel.ida.logic.features.treeliker.Propositionalization;
import cz.cvut.fel.ida.logic.features.treeliker.Table;
import cz.cvut.fel.ida.logic.features.treeliker.TreeLikerSettings;
import cz.cvut.fel.ida.logic.io.Prolog2PseudoPrologReader;
import cz.cvut.fel.ida.utils.math.CommandLine;
import cz.cvut.fel.ida.utils.math.StringUtils;
import cz.cvut.fel.ida.utils.math.Sugar;
import cz.cvut.fel.ida.utils.math.VectorUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

public class TreeLikerMain {
    public static void main(String[] a) throws IOException {
        Map<String, String> params = CommandLine.parseParams(a);
        if (params.containsKey("-batch")) {
            BufferedReader br = new BufferedReader(new FileReader(params.get("-batch")));
            HashMap<String, String> batchParams = new HashMap<String, String>();
            Propositionalization prop = new Propositionalization();
            int maxSize = Integer.MAX_VALUE;
            int mode = 3;
            boolean PSEUDOPROLOG = true;
            int PROLOG = 2;
            int inputType = 1;
            for (String line : Sugar.readLines(br)) {
                if ((line = line.trim()).indexOf(46) > -1 && line.lastIndexOf(46) == line.length() - 1) {
                    line = line.substring(0, line.length() - 1);
                }
                if (line.indexOf("%") > -1) {
                    line = line.substring(0, line.indexOf("%"));
                }
                if (line.length() <= 0) continue;
                Clause c = Clause.parse(line);
                for (Literal l : c.literals()) {
                    Reader examplesReader;
                    String foldsCount;
                    String inputFormat;
                    String normalizationFactor;
                    String size;
                    String algorithm;
                    String regressionRedundancyTolerance;
                    String minFrequency;
                    String hreduction;
                    String cv;
                    if (l.predicate().name.equalsIgnoreCase("print")) {
                        System.out.println(">> " + l.get(0).toString());
                        continue;
                    }
                    if (l.predicate().name.equalsIgnoreCase("get")) {
                        String usrInput = CommandLine.read();
                        batchParams.put(l.get(0).name(), usrInput);
                        continue;
                    }
                    if (l.predicate().name.equalsIgnoreCase("set")) {
                        if (l.get(0).name().equals("template")) {
                            PrologList pl = (PrologList)l.get(1);
                            StringBuilder sb = new StringBuilder();
                            for (int i = 0; i < pl.countItems(); ++i) {
                                sb.append(pl.get(i));
                                if (i >= pl.countItems() - 1) continue;
                                sb.append(", ");
                            }
                            if (sb.charAt(0) == '\'' && sb.charAt(sb.length() - 1) == '\'') {
                                batchParams.put(l.get(0).name(), sb.substring(1, sb.length() - 1));
                                continue;
                            }
                            batchParams.put(l.get(0).name(), sb.toString());
                            continue;
                        }
                        if (l.get(1).name().charAt(0) == '\'' && l.get(1).name().charAt(l.get(1).name().length() - 1) == '\'') {
                            batchParams.put(l.get(0).name(), l.get(1).name().substring(1, l.get(1).name().length() - 1));
                            continue;
                        }
                        batchParams.put(l.get(0).name(), l.get(1).name().toString());
                        continue;
                    }
                    if (!l.predicate().name.equalsIgnoreCase("work") && !l.predicate().name.equalsIgnoreCase("whatever")) continue;
                    Object examples = (String)batchParams.get("examples");
                    examples = new File(params.get("-batch")).getAbsoluteFile().getParent() + File.separator + (String)examples;
                    String template = (String)batchParams.get("template");
                    if (template == null) {
                        System.out.println("Template was not found in " + params.get("-batch"));
                    }
                    if ((cv = (String)batchParams.get("output_type")) == null) {
                        cv = "single";
                    }
                    if ((hreduction = (String)batchParams.get("use_hreduction")) == null) {
                        hreduction = (String)batchParams.get("use_h_reduction");
                    }
                    if (hreduction != null && hreduction.equalsIgnoreCase("true")) {
                        TreeLikerSettings.USE_H_REDUCTION = true;
                    } else if (hreduction != null && hreduction.equalsIgnoreCase("false")) {
                        TreeLikerSettings.USE_H_REDUCTION = false;
                    }
                    String redundancy = (String)batchParams.get("use_redundancy");
                    if (redundancy != null && redundancy.equalsIgnoreCase("true")) {
                        TreeLikerSettings.USE_REDUNDANCY_FILTERING = true;
                    } else if (redundancy != null && redundancy.equalsIgnoreCase("false")) {
                        TreeLikerSettings.USE_REDUNDANCY_FILTERING = false;
                    }
                    String coveredClass = (String)batchParams.get("covered_class");
                    Object output = (String)batchParams.get("output");
                    if (output == null) {
                        System.out.println("Parameter output, which is where the propositionalized table(s) should be stored, is missing in " + params.get("-batch"));
                        System.exit(0);
                    }
                    if (!new File((String)output).exists()) {
                        output = new File(params.get("-batch")).getAbsoluteFile().getParent() + File.separator + (String)output;
                    }
                    if ((minFrequency = (String)batchParams.get("min_frequency")) == null) {
                        minFrequency = (String)batchParams.get("minimum_frequency");
                    }
                    if (minFrequency != null && StringUtils.isNumeric(minFrequency)) {
                        prop.setMinFrequency(Double.parseDouble(minFrequency));
                    }
                    if ((regressionRedundancyTolerance = (String)batchParams.get("regression_redundancy_tolerance")) != null) {
                        if (StringUtils.isInteger(regressionRedundancyTolerance)) {
                            TreeLikerSettings.REGRESSION_REDUNDANCY_TOLERANCE = Integer.parseInt(regressionRedundancyTolerance);
                        } else {
                            System.out.println("Parameter regression_redundancy_tolerance must be an integer.");
                        }
                    }
                    if ((algorithm = (String)batchParams.get("algorithm")) != null && algorithm.equalsIgnoreCase("relf")) {
                        mode = 3;
                    } else if (algorithm != null && (algorithm.equalsIgnoreCase("relf_grounding_counting") || algorithm.equalsIgnoreCase("relf_groundings_counting"))) {
                        mode = 7;
                    } else if (algorithm != null && algorithm.equalsIgnoreCase("hifi")) {
                        mode = 4;
                    } else if (algorithm != null && (algorithm.equalsIgnoreCase("hifi_grounding_counting") || algorithm.equalsIgnoreCase("hifi_groundings_counting"))) {
                        mode = 6;
                    } else if (algorithm != null && algorithm.equalsIgnoreCase("poly")) {
                        mode = 9;
                    } else if (algorithm != null && (algorithm.equalsIgnoreCase("poly_grounding_counting") || algorithm.equalsIgnoreCase("poly_groundings_counting"))) {
                        mode = 10;
                    }
                    if (batchParams.containsKey("use_sampling")) {
                        if (((String)batchParams.get("use_sampling")).equalsIgnoreCase("true")) {
                            prop.setUseSampling(true);
                        } else {
                            prop.setUseSampling(false);
                        }
                    }
                    if (batchParams.containsKey("num_samples") && StringUtils.isInteger((String)batchParams.get("num_samples"))) {
                        prop.setNumSamples(Integer.parseInt((String)batchParams.get("num_samples")));
                    }
                    if (batchParams.containsKey("sample_size") && StringUtils.isInteger((String)batchParams.get("sample_size"))) {
                        prop.setSampleSize(Integer.parseInt((String)batchParams.get("sample_size")));
                    }
                    boolean useJustFirstExample = false;
                    if (batchParams.containsKey("use_just_first_example") && ((String)batchParams.get("use_just_first_example")).equalsIgnoreCase("true")) {
                        useJustFirstExample = true;
                    }
                    if ((size = (String)batchParams.get("max_size")) == null) {
                        size = (String)batchParams.get("maximum_size");
                    }
                    if ((normalizationFactor = (String)batchParams.get("normalization_factor")) != null) {
                        String normF = normalizationFactor;
                        if (normF.contains("[")) {
                            normF = normF.substring(normF.indexOf("[") + 1);
                        }
                        if (normF.contains("]")) {
                            normF = normF.substring(0, normF.lastIndexOf("]"));
                        }
                        prop.setNormalizationFactor(Block.parse(normF));
                    }
                    if (batchParams.containsKey("verbosity")) {
                        TreeLikerSettings.VERBOSITY = Integer.parseInt(((String)batchParams.get("verbosity")).trim());
                    }
                    if (batchParams.containsKey("max_degree")) {
                        prop.setMaxDegree(Integer.parseInt((String)batchParams.get("max_degree")));
                    }
                    if (size != null) {
                        if (StringUtils.isNumeric(size)) {
                            maxSize = (int)Double.parseDouble(size);
                        } else {
                            System.out.println("Warning: max_size must be an integer!");
                        }
                    }
                    if ((inputFormat = (String)batchParams.get("input_format")) != null) {
                        if (inputFormat.equalsIgnoreCase("pseudoprolog") || inputFormat.equalsIgnoreCase("pseudo_prolog")) {
                            inputType = 1;
                        } else if (inputFormat.equalsIgnoreCase("prolog")) {
                            inputType = 2;
                        }
                    }
                    if ((foldsCount = (String)batchParams.get("folds_count")) == null) {
                        foldsCount = (String)batchParams.get("num_folds");
                    }
                    prop.setConstructFeaturesOnlyFromFirstExample(useJustFirstExample);
                    long m1 = System.currentTimeMillis();
                    if (cv.equalsIgnoreCase("single")) {
                        Table<String, String> table;
                        File outputFile;
                        File parent;
                        if (examples == null) {
                            System.out.println("Parameter examples, which points to the file with examples, is missing in " + params.get("-batch"));
                            System.exit(0);
                        }
                        if ((parent = (outputFile = new File((String)output)).getAbsoluteFile().getParentFile()) != null && !parent.exists()) {
                            parent.mkdirs();
                        }
                        examplesReader = new FileReader((String)examples);
                        if (inputType == 2) {
                            examplesReader = new Prolog2PseudoPrologReader(examplesReader);
                        }
                        if (mode == 3) {
                            if (coveredClass != null) {
                                prop.setRelfCoveredClasses(Sugar.set(coveredClass));
                            }
                            table = prop.relf(template, examplesReader);
                            if (TreeLikerSettings.USE_REDUNDANCY_FILTERING) {
                                table.save(new FileWriter((String)output));
                            } else {
                                table.saveWithoutFiltering(new FileWriter((String)output));
                            }
                        } else if (mode == 9 || mode == 10) {
                            table = prop.poly(template, maxSize, examplesReader);
                            if (TreeLikerSettings.USE_REDUNDANCY_FILTERING) {
                                table.save(new FileWriter((String)output));
                            } else {
                                table.saveWithoutFiltering(new FileWriter((String)output));
                            }
                        } else if (mode == 7) {
                            if (coveredClass != null) {
                                prop.setRelfCoveredClasses(Sugar.set(coveredClass));
                            }
                            table = prop.relf(template, examplesReader, 7);
                            if (TreeLikerSettings.USE_REDUNDANCY_FILTERING) {
                                table.save(new FileWriter((String)output));
                            } else {
                                table.saveWithoutFiltering(new FileWriter((String)output));
                            }
                        } else if (mode == 4 || mode == 6) {
                            table = prop.hifi(template, maxSize, examplesReader, mode);
                            if (TreeLikerSettings.USE_REDUNDANCY_FILTERING) {
                                table.save(new FileWriter((String)output));
                            } else {
                                table.saveWithoutFiltering(new FileWriter((String)output));
                            }
                        }
                    } else if (cv.equalsIgnoreCase("train_test") || cv.equalsIgnoreCase("traintest")) {
                        if ((mode == 3 || mode == 7) && coveredClass != null) {
                            prop.setRelfCoveredClasses(Sugar.set(coveredClass));
                        }
                        String trainSet = (String)batchParams.get("train_set");
                        String testSet = (String)batchParams.get("test_set");
                        if (trainSet != null && testSet != null) {
                            if (trainSet.startsWith("[") && testSet.startsWith("[")) {
                                examplesReader = new FileReader((String)examples);
                                if (inputType == 2) {
                                    examplesReader = new Prolog2PseudoPrologReader(examplesReader);
                                }
                                prop.trainTest(template, maxSize, VectorUtils.parseIntegerArray(trainSet), VectorUtils.parseIntegerArray(testSet), examplesReader, (String)output, mode);
                            } else {
                                String trainSetPath = new File(params.get("-batch")).getAbsoluteFile().getParent() + File.separator + trainSet;
                                String testSetPath = new File(params.get("-batch")).getAbsoluteFile().getParent() + File.separator + testSet;
                                Reader trainSetReader = new FileReader(trainSetPath);
                                Reader testSetReader = new FileReader(testSetPath);
                                if (inputType == 2) {
                                    trainSetReader = new Prolog2PseudoPrologReader(trainSetReader);
                                    testSetReader = new Prolog2PseudoPrologReader(testSetReader);
                                }
                                prop.trainTest(template, maxSize, trainSetReader, testSetReader, (String)output, mode);
                            }
                        }
                    } else if (cv.equalsIgnoreCase("cv") || cv.equalsIgnoreCase("cross-validation")) {
                        if (examples == null) {
                            System.out.println("Parameter examples, which points to the file with examples, is missing in " + params.get("-batch"));
                            System.exit(0);
                        }
                        if ((mode == 3 || mode == 7) && coveredClass != null) {
                            prop.setRelfCoveredClasses(Sugar.set(coveredClass));
                        }
                        if (foldsCount != null) {
                            if (StringUtils.isInteger(foldsCount)) {
                                prop.setFoldsCount(Integer.parseInt(foldsCount));
                            } else {
                                System.out.println("Warning: Number of folds must be an integer! Ignoring this setting.");
                            }
                        }
                        Reader examplesReader2 = new FileReader((String)examples);
                        if (inputType == 2) {
                            examplesReader2 = new Prolog2PseudoPrologReader(examplesReader2);
                        }
                        prop.cv(template, maxSize, examplesReader2, (String)output, mode);
                    }
                    long m2 = System.currentTimeMillis();
                    System.out.println("Finished in " + (double)(m2 - m1) / 1000.0 + " seconds");
                }
            }
        } else {
            System.out.println("Example usage: java -jar -Xmx1G TreeLiker.jar -batch settingsfile.treeliker");
        }
    }
}

