/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.features.treeliker.aggregables;

import cz.cvut.fel.ida.logic.features.treeliker.Aggregables;
import cz.cvut.fel.ida.logic.features.treeliker.AggregablesBuilder;
import cz.cvut.fel.ida.logic.features.treeliker.Example;
import cz.cvut.fel.ida.logic.features.treeliker.PredicateDefinition;
import cz.cvut.fel.ida.logic.features.treeliker.aggregables.PolyAggregable;
import cz.cvut.fel.ida.utils.generic.tuples.Tuple;
import cz.cvut.fel.ida.utils.math.collections.IntegerSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PolyAggregablesBuilder
implements AggregablesBuilder {
    private static final Map<Integer, PolyAggregablesBuilder> one = new HashMap<Integer, PolyAggregablesBuilder>();
    private static PolyAggregable empty;
    private int maxDegree;

    private PolyAggregablesBuilder(int maxDegree) {
        this.maxDegree = maxDegree;
        empty = new PolyAggregable(0, maxDegree, new double[0], 1.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PolyAggregablesBuilder construct(int maxDegree) {
        Map<Integer, PolyAggregablesBuilder> map = one;
        synchronized (map) {
            PolyAggregablesBuilder pab = null;
            pab = one.get(maxDegree);
            if (pab == null) {
                pab = new PolyAggregablesBuilder(maxDegree);
                one.put(maxDegree, pab);
            }
            return pab;
        }
    }

    @Override
    public Aggregables construct(PredicateDefinition def, IntegerSet literalIDs, Example example) {
        Aggregables<PolyAggregable> aggregables = new Aggregables<PolyAggregable>(literalIDs.size());
        if (def.containsAggregator()) {
            int aggregationArgument = 0;
            int[] modes = def.modes();
            for (int i = 0; i < def.arity(); ++i) {
                if (modes[i] != 9) continue;
                aggregationArgument = i;
                break;
            }
            List<Tuple<Integer>> exponents = PolyAggregable.allMonomialExponents(1, this.maxDegree);
            for (int literal : literalIDs.values()) {
                double val = Double.parseDouble(Example.termToString(example.getTerm(literal, aggregationArgument)));
                double[] values = new double[exponents.size()];
                for (int i = 0; i < exponents.size(); ++i) {
                    values[i] = Math.pow(val, exponents.get(i).get(0).intValue());
                }
                aggregables.add(new PolyAggregable(1, this.maxDegree, values, 1.0));
            }
        } else {
            for (int i = 0; i < literalIDs.size(); ++i) {
                aggregables.add(empty);
            }
        }
        return aggregables;
    }
}

