/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.features.treeliker.impl;

import cz.cvut.fel.ida.logic.features.treeliker.Block;
import cz.cvut.fel.ida.logic.features.treeliker.Domain;
import cz.cvut.fel.ida.logic.features.treeliker.Join;
import cz.cvut.fel.ida.logic.features.treeliker.SyntaxChecker;
import cz.cvut.fel.ida.logic.features.treeliker.impl.DomainComputing;
import cz.cvut.fel.ida.logic.features.treeliker.impl.Pruning;
import cz.cvut.fel.ida.utils.generic.tuples.Pair;
import cz.cvut.fel.ida.utils.math.collections.MultiMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class BlockBuilder
implements Runnable {
    private Block oldPos;
    private int arg;
    private List<Block> current;
    private ConcurrentHashMap<Integer, Domain[]> literalDomains;
    private MultiMap<Pair<Integer, Integer>, Join> bagPosFeaturesWithLiteralsInDomain;
    private DomainComputing domainComputing;
    private Pruning pruning;
    private List<SyntaxChecker> syntaxCheckers;
    private boolean useIrrelevancyFiltering = false;

    public BlockBuilder(Block oldBlock, int arg, MultiMap<Pair<Integer, Integer>, Join> bagLiteralsWithLiteralsInDomain, ConcurrentHashMap<Integer, Domain[]> literalDomains, List<Block> current, DomainComputing domainComputing, Pruning pruning, List<SyntaxChecker> syntaxCheckers) {
        this.oldPos = oldBlock;
        this.arg = arg;
        this.bagPosFeaturesWithLiteralsInDomain = bagLiteralsWithLiteralsInDomain;
        this.literalDomains = literalDomains;
        this.current = current;
        this.domainComputing = domainComputing;
        this.pruning = pruning;
        this.syntaxCheckers = syntaxCheckers;
    }

    @Override
    public void run() {
        Domain[] oldPosDomains = this.literalDomains.get(this.oldPos.id());
        HashSet<Join> candidates = new HashSet<Join>();
        for (Domain oldPosDomain : oldPosDomains) {
            for (int literalID : oldPosDomain.integerSet().values()) {
                candidates.addAll(this.bagPosFeaturesWithLiteralsInDomain.get(new Pair<Integer, Integer>(this.arg, literalID)));
            }
        }
        ArrayList<Block> generated = new ArrayList<Block>();
        for (Join join : candidates) {
            Block newBlock = this.oldPos.shallowCopy();
            newBlock.setChildren(join, this.arg);
            if (!this.checkSyntax(newBlock)) continue;
            generated.add(newBlock);
            this.literalDomains.put(newBlock.id(), this.domainComputing.computeLiteralDomains(newBlock));
        }
        int remainingOutputs = 0;
        for (int i = this.arg + 1; i < this.oldPos.arity(); ++i) {
            if (this.oldPos.modes()[i] != 2) continue;
            ++remainingOutputs;
        }
        if (remainingOutputs > 0 && this.useIrrelevancyFiltering) {
            this.current.addAll(this.pruning.filterIrrelevantBlocksInParallel(generated, this.literalDomains));
        } else {
            this.current.addAll(generated);
        }
    }

    private boolean checkSyntax(Block block) {
        for (SyntaxChecker syntaxChecker : this.syntaxCheckers) {
            if (syntaxChecker.check(block)) continue;
            return false;
        }
        return true;
    }

    public void setUseIrrelevancyFiltering(boolean useIrrelevancyFiltering) {
        this.useIrrelevancyFiltering = useIrrelevancyFiltering;
    }
}

