/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.features.treeliker.impl;

import cz.cvut.fel.ida.logic.features.treeliker.Dataset;
import cz.cvut.fel.ida.logic.features.treeliker.Domain;
import cz.cvut.fel.ida.logic.features.treeliker.Example;
import cz.cvut.fel.ida.logic.features.treeliker.Join;
import cz.cvut.fel.ida.utils.generic.tuples.Pair;
import cz.cvut.fel.ida.utils.math.collections.IntegerSet;
import cz.cvut.fel.ida.utils.math.collections.MultiMap;

public class BlocksWithLiteralsInDomainBuilder
implements Runnable {
    private MultiMap<Pair<Integer, Integer>, Join> bagPosFeaturesWithLiteralsInDomain;
    private int argument;
    private int predicate;
    private Join join;
    private Dataset examples;

    public BlocksWithLiteralsInDomainBuilder(Join join, int predicate, int argument, MultiMap<Pair<Integer, Integer>, Join> blocksWithLiteralsInDomain, Dataset examples) {
        this.join = join;
        this.predicate = predicate;
        this.argument = argument;
        this.bagPosFeaturesWithLiteralsInDomain = blocksWithLiteralsInDomain;
        this.examples = examples;
    }

    @Override
    public void run() {
        IntegerSet[] literalDomains;
        Domain[] termDomains = new Domain[this.examples.countExamples()];
        Dataset localExamples = this.examples.shallowCopy();
        localExamples.reset();
        int index = 0;
        while (localExamples.hasNextExample()) {
            termDomains[index] = this.join.termDomain(localExamples.nextExample());
            ++index;
        }
        for (IntegerSet literalDomain : literalDomains = this.computeLiteralDomainsFromTermDomains(termDomains, this.predicate, this.argument)) {
            for (int literalID : literalDomain.values()) {
                this.bagPosFeaturesWithLiteralsInDomain.put(new Pair<Integer, Integer>(this.argument, literalID), this.join);
            }
        }
    }

    private IntegerSet[] computeLiteralDomainsFromTermDomains(Domain[] termDomains, int predicate, int argument) {
        IntegerSet[] literalDomains = new IntegerSet[this.examples.countExamples()];
        Dataset localExamples = this.examples.shallowCopy();
        localExamples.reset();
        int index = 0;
        while (localExamples.hasNextExample()) {
            Example e = localExamples.nextExample();
            literalDomains[index] = e.getLiteralDomain(predicate, termDomains[index].integerSet(), argument);
            ++index;
        }
        return literalDomains;
    }
}

