/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.features.treeliker.impl;

import cz.cvut.fel.ida.logic.features.treeliker.Block;
import cz.cvut.fel.ida.logic.features.treeliker.Domain;
import cz.cvut.fel.ida.logic.features.treeliker.Join;
import cz.cvut.fel.ida.logic.features.treeliker.JoinAndInt;
import cz.cvut.fel.ida.logic.features.treeliker.SyntaxChecker;
import cz.cvut.fel.ida.logic.features.treeliker.TreeLikerSettings;
import cz.cvut.fel.ida.logic.features.treeliker.impl.DomainComputing;
import cz.cvut.fel.ida.logic.features.treeliker.impl.HSubsumption;
import cz.cvut.fel.ida.logic.features.treeliker.impl.Pruning;
import cz.cvut.fel.ida.utils.generic.tuples.Pair;
import cz.cvut.fel.ida.utils.math.collections.Counters;
import cz.cvut.fel.ida.utils.math.collections.MultiList;
import cz.cvut.fel.ida.utils.math.collections.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CombinationsBuilder
implements Runnable {
    private JoinAndInt originalJoin;
    private ConcurrentHashMap<List<Domain>, Integer> redundancyMap;
    private ConcurrentHashMap<Block, Integer> indices;
    private ConcurrentHashMap<Pair<Block, Block>, Boolean> hSubsumptions;
    private MultiList<Integer, JoinAndInt> hbl;
    private int combinationSize;
    private MultiMap<Pair<Integer, Integer>, Block> termsInDomainsOf;
    private DomainComputing domainComputing;
    private HSubsumption hsubsumptionEngine;
    private Pruning pruning;
    private boolean[] mask;
    private boolean[] negMask;
    private List<SyntaxChecker> syntaxCheckers;
    private boolean useIrrelevancyFiltering = false;
    private boolean useRepetitions = false;

    public CombinationsBuilder(JoinAndInt originalJoin, ConcurrentHashMap<List<Domain>, Integer> redundancyMap, ConcurrentHashMap<Block, Integer> indices, ConcurrentHashMap<Pair<Block, Block>, Boolean> hSubsumptions, MultiList<Integer, JoinAndInt> hbl, int combinationSize, MultiMap<Pair<Integer, Integer>, Block> termsInDomainsOf, DomainComputing domainComputing, HSubsumption hsubsumption, Pruning pruning, List<SyntaxChecker> syntaxCheckers) {
        this.originalJoin = originalJoin;
        this.redundancyMap = redundancyMap;
        this.indices = indices;
        this.hSubsumptions = hSubsumptions;
        this.hbl = hbl;
        this.combinationSize = combinationSize;
        this.termsInDomainsOf = termsInDomainsOf;
        this.domainComputing = domainComputing;
        this.hsubsumptionEngine = hsubsumption;
        this.pruning = pruning;
        this.mask = pruning.getMask();
        this.negMask = pruning.getNegMask();
        this.syntaxCheckers = syntaxCheckers;
    }

    @Override
    public void run() {
        Join join = (Join)this.originalJoin.r;
        Counters<Block> frequencyOnCoveredClass = new Counters<Block>();
        Domain[] termDomainsOfCombination = this.domainComputing.computeTermDomains(join);
        LinkedHashSet<Pair<Block, Integer>> candidates0 = new LinkedHashSet<Pair<Block, Integer>>();
        for (int j = 0; j < termDomainsOfCombination.length; ++j) {
            for (int k : termDomainsOfCombination[j].integerSet().values()) {
                for (Block candidate : this.termsInDomainsOf.get(new Pair<Integer, Integer>(j, k))) {
                    int index = this.indices.get(candidate);
                    if (index <= (Integer)this.originalJoin.s && (index != (Integer)this.originalJoin.s || !this.useRepetitions) || !this.checkBranchings(join, candidate) || !this.mask[j] || frequencyOnCoveredClass.incrementPre(candidate) < this.pruning.minFrequencyOnCoveredClass()) continue;
                    candidates0.add(new Pair<Block, Integer>(candidate, index));
                }
            }
        }
        ArrayList<JoinAndInt> combinations = new ArrayList<JoinAndInt>();
        HashMap<Integer, Domain[]> combinationsDomains = new HashMap<Integer, Domain[]>();
        for (Pair pair : candidates0) {
            Domain[] intersections;
            Join newJoin;
            Block block = (Block)pair.r;
            int index = (Integer)pair.s;
            if (TreeLikerSettings.USE_H_REDUCTION && this.becomesHReducible((Join)this.originalJoin.r, (Block)pair.r, this.hSubsumptions) || !this.checkSyntax(newJoin = join.addBlock(block))) continue;
            Domain[] blockDomains = this.domainComputing.computeTermDomains(block);
            if (TreeLikerSettings.USE_REDUNDANCY_FILTERING && this.useIrrelevancyFiltering && (Domain.allAreSubsets(termDomainsOfCombination, blockDomains, this.negMask) || Domain.allAreSubsets(blockDomains, termDomainsOfCombination, this.negMask)) || Domain.countNonEmpty(intersections = Domain.cross(termDomainsOfCombination, blockDomains), this.mask) < this.pruning.minFrequencyOnCoveredClass()) continue;
            List<Domain> asList = Arrays.asList(intersections);
            if (TreeLikerSettings.USE_REDUNDANCY_FILTERING && this.getRedundancyMap().containsKey(asList)) {
                if (this.getRedundancyMap().get(asList) <= block.size() + ((Join)this.originalJoin.r).numLiterals()) continue;
                this.getRedundancyMap().put(asList, block.size() + ((Join)this.originalJoin.r).numLiterals());
                combinations.add(new JoinAndInt(newJoin, index));
                combinationsDomains.put(newJoin.id(), intersections);
                continue;
            }
            combinations.add(new JoinAndInt(newJoin, index));
            this.getRedundancyMap().put(asList, block.size() + ((Join)this.originalJoin.r).numLiterals());
            combinationsDomains.put(newJoin.id(), intersections);
        }
        if (this.useIrrelevancyFiltering) {
            for (JoinAndInt joinAndInt : this.pruning.filterIrrelevantCombinationsOfBlocksInParallel(combinations, combinationsDomains)) {
                this.hbl.put(this.combinationSize + 1, (JoinAndInt[])new JoinAndInt[]{joinAndInt});
            }
        } else {
            this.hbl.putAll(this.combinationSize + 1, combinations);
        }
    }

    private boolean checkBranchings(Join join, Block block) {
        Counters<Integer> counters = new Counters<Integer>();
        if (block.branchingFactors()[block.input()] > 0 && block.branchingFactors()[block.input()] < join.numBlocks() + 1) {
            return false;
        }
        if (block.branchingModPredicate() > 0) {
            counters.increment(block.predicate());
        }
        for (Block inJoin : join) {
            if (inJoin.branchingFactors()[inJoin.input()] > 0 && inJoin.branchingFactors()[inJoin.input()] < join.numBlocks() + 1) {
                return false;
            }
            if (inJoin.branchingModPredicate() <= 0 || counters.incrementPre(inJoin.predicate()) <= inJoin.branchingModPredicate()) continue;
            return false;
        }
        return true;
    }

    private boolean becomesHReducible(Join join, Block block, Map<Pair<Block, Block>, Boolean> subsumptions) {
        if (TreeLikerSettings.USE_H_REDUCTION) {
            for (Block inJoin : join) {
                if ((block.numAggregators() != 0 || !this.hsubsumptionEngine.hSubsumption(block, inJoin, subsumptions)) && (inJoin.numAggregators() != 0 || !this.hsubsumptionEngine.hSubsumption(inJoin, block, subsumptions))) continue;
                return true;
            }
        }
        return false;
    }

    public ConcurrentHashMap<List<Domain>, Integer> getRedundancyMap() {
        return this.redundancyMap;
    }

    private boolean checkSyntax(Join join) {
        for (SyntaxChecker syntaxChecker : this.syntaxCheckers) {
            if (syntaxChecker.check(join)) continue;
            return false;
        }
        return true;
    }

    public void setUseIrrelevancyFiltering(boolean useIrrelevancyFiltering) {
        this.useIrrelevancyFiltering = useIrrelevancyFiltering;
    }

    public void setUseRepetitions(boolean useRepetitions) {
        this.useRepetitions = useRepetitions;
    }
}

