/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.features.treeliker.impl;

import cz.cvut.fel.ida.logic.features.treeliker.Block;
import cz.cvut.fel.ida.logic.features.treeliker.Join;
import cz.cvut.fel.ida.logic.features.treeliker.PredicateDefinition;
import cz.cvut.fel.ida.logic.features.treeliker.SyntaxChecker;
import cz.cvut.fel.ida.logic.features.treeliker.TreeLikerSettings;
import cz.cvut.fel.ida.logic.features.treeliker.utils.graphs.DirectedGraph;
import cz.cvut.fel.ida.logic.features.treeliker.utils.graphs.DirectedVertex;
import cz.cvut.fel.ida.logic.features.treeliker.utils.graphs.GraphAlgorithms;
import cz.cvut.fel.ida.utils.math.collections.MultiMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MaxSizeChecker
implements SyntaxChecker {
    private int maxSize;
    private Map<Integer, Integer> sizesDown;
    private Map<Integer, Integer> sizesUp;

    public MaxSizeChecker(int maxSize, List<PredicateDefinition> topologicallyOrderedTemplate) {
        this.maxSize = maxSize;
        this.sizesDown = MaxSizeChecker.computeSmallestFeatureSizesDown(topologicallyOrderedTemplate);
        this.sizesUp = MaxSizeChecker.computeSmallestFeatureSizesUp(topologicallyOrderedTemplate, this.sizesDown);
    }

    @Override
    public boolean check(Block block) {
        int s = block.size();
        int[] modes = block.definition().modes();
        int[] types = block.definition().types();
        for (int i = 0; i < block.arity(); ++i) {
            if (block.children(i) != null || modes[i] != 2) continue;
            s += this.sizesDown.get(types[i]).intValue();
        }
        return s <= this.maxSize;
    }

    @Override
    public boolean check(Join join) {
        return join.numLiterals() + this.sizesUp.get(join.first().definition().types()[join.first().input()]) <= this.maxSize;
    }

    private static Map<Integer, Integer> computeSmallestFeatureSizesUp(List<PredicateDefinition> topologicallyOrdered, Map<Integer, Integer> smallestFeaturesDown) {
        Object modes;
        MultiMap<Integer, PredicateDefinition> havingOutputType = new MultiMap<Integer, PredicateDefinition>();
        HashMap<Integer, PredicateDefinition> definitions = new HashMap<Integer, PredicateDefinition>();
        for (PredicateDefinition def : topologicallyOrdered) {
            modes = def.modes();
            int[] types = def.types();
            for (int i = 0; i < ((int[])modes).length; ++i) {
                if (modes[i] != 2) continue;
                havingOutputType.put(types[i], def);
            }
            definitions.put(def.id(), def);
        }
        HashMap<Integer, DirectedVertex> vertices = new HashMap<Integer, DirectedVertex>();
        DirectedVertex dummy = new DirectedVertex(-1);
        vertices.put(dummy.id(), dummy);
        modes = topologicallyOrdered.iterator();
        while (modes.hasNext()) {
            DirectedVertex from;
            PredicateDefinition def = (PredicateDefinition)modes.next();
            if (!def.isOutputOnly()) {
                from = null;
                from = vertices.containsKey(def.id()) ? (DirectedVertex)vertices.get(def.id()) : new DirectedVertex(def.id());
                int inputType = def.types()[def.input()];
                Set havingDesiredOutput = havingOutputType.get(inputType);
                for (PredicateDefinition desiredDef : havingDesiredOutput) {
                    DirectedVertex to = null;
                    to = vertices.containsKey(desiredDef.id()) ? (DirectedVertex)vertices.get(desiredDef.id()) : new DirectedVertex(desiredDef.id());
                    int distance = 1;
                    boolean desiredTypeFound = false;
                    for (int j = 0; j < desiredDef.modes().length; ++j) {
                        if (desiredDef.modes()[j] == 2 && (desiredTypeFound || desiredDef.types()[j] != inputType)) {
                            distance = smallestFeaturesDown.containsKey(desiredDef.types()[j]) ? (distance += smallestFeaturesDown.get(desiredDef.types()[j]).intValue()) : Integer.MAX_VALUE;
                        }
                        if (desiredDef.types()[j] != inputType) continue;
                        desiredTypeFound = true;
                    }
                    DirectedVertex.connectDirected(from, to, distance);
                    vertices.put(from.id(), from);
                    vertices.put(to.id(), to);
                }
                continue;
            }
            from = null;
            from = vertices.containsKey(def.id()) ? (DirectedVertex)vertices.get(def.id()) : new DirectedVertex(def.id());
            DirectedVertex.connectDirected(from, dummy, 0);
        }
        DirectedGraph graph = new DirectedGraph(vertices.values());
        Map<DirectedVertex, Integer> distances = GraphAlgorithms.shortestPathsInAcyclicGraphToVertex(graph, dummy);
        HashMap<Integer, Integer> distancesFromTypes = new HashMap<Integer, Integer>();
        for (Map.Entry<DirectedVertex, Integer> entry : distances.entrySet()) {
            PredicateDefinition def;
            if (entry.getKey().id() == -1 || (def = (PredicateDefinition)definitions.get(entry.getKey().id())).isOutputOnly()) continue;
            int inputType = def.types()[def.input()];
            distancesFromTypes.put(inputType, entry.getValue());
        }
        return distancesFromTypes;
    }

    private static HashMap<Integer, Integer> computeSmallestFeatureSizesDown(List<PredicateDefinition> topologicallyOrdered) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (PredicateDefinition def : topologicallyOrdered) {
            int size = 1;
            if (def.isConstant() && !TreeLikerSettings.COUNT_CONSTANTS_AS_LITERALS) {
                size = 0;
            }
            int[] modes = def.modes();
            int[] types = def.types();
            for (int i = 0; i < def.arity(); ++i) {
                if (modes[i] != 2) continue;
                if (map.containsKey(types[i])) {
                    size += map.get(types[i]).intValue();
                    continue;
                }
                size = Integer.MAX_VALUE;
            }
            if (map.containsKey(types[def.input()]) && map.get(types[def.input()]) <= size) continue;
            map.put(types[def.input()], size);
        }
        return map;
    }
}

