/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.features.treeliker.utils.graphs;

import cz.cvut.fel.ida.logic.features.treeliker.utils.graphs.DirectedVertex;
import cz.cvut.fel.ida.utils.math.Sugar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DirectedGraph {
    private Map<Integer, DirectedVertex> vertices = new HashMap<Integer, DirectedVertex>();
    private Map<Integer, DirectedVertex> inDegreeZeroVertices = new HashMap<Integer, DirectedVertex>();
    private Map<Integer, DirectedVertex> outDegreeZeroVertices = new HashMap<Integer, DirectedVertex>();
    private Map<Integer, DirectedVertex> inDegreeOneVertices = new HashMap<Integer, DirectedVertex>();
    private Map<Integer, DirectedVertex> outDegreeOneVertices = new HashMap<Integer, DirectedVertex>();

    public DirectedGraph(Collection<DirectedVertex> vertices) {
        for (DirectedVertex vertex : vertices) {
            this.vertices.put(vertex.id(), vertex);
            this.addToDegreeVertices(vertex);
        }
    }

    public boolean isConnected() {
        HashSet<DirectedVertex> closed = new HashSet<DirectedVertex>();
        LinkedList<DirectedVertex> open = new LinkedList<DirectedVertex>();
        open.add(Sugar.chooseOne(this.vertices));
        while (open.size() > 0) {
            DirectedVertex v = (DirectedVertex)open.poll();
            for (DirectedVertex expanded : v.outVertices()) {
                if (closed.contains(expanded)) continue;
                open.add(expanded);
            }
            closed.add(v);
        }
        return closed.size() == this.vertices.size();
    }

    public DirectedGraph clone() {
        HashMap<Integer, DirectedVertex> map = new HashMap<Integer, DirectedVertex>();
        ArrayList<DirectedVertex> verts = new ArrayList<DirectedVertex>();
        for (DirectedVertex v : this.vertices()) {
            DirectedVertex clonedVertex = new DirectedVertex(v.id());
            clonedVertex.setNote(v.getNote());
            verts.add(clonedVertex);
            map.put(clonedVertex.id(), clonedVertex);
        }
        for (DirectedVertex v : this.vertices()) {
            for (DirectedVertex outAdj : v.outVertices()) {
                if (v.outDistance(outAdj) == Integer.MAX_VALUE) {
                    DirectedVertex.connectDirected((DirectedVertex)map.get(v.id()), (DirectedVertex)map.get(outAdj.id()));
                    continue;
                }
                DirectedVertex.connectDirected((DirectedVertex)map.get(v.id()), (DirectedVertex)map.get(outAdj.id()), v.outDistance(outAdj));
            }
        }
        return new DirectedGraph(verts);
    }

    public int vertexCount() {
        return this.vertices.size();
    }

    public Collection<DirectedVertex> vertices() {
        return this.vertices.values();
    }

    public DirectedVertex getVertex(int id) {
        return this.vertices.get(id);
    }

    public void hide(DirectedVertex vertex) {
        if (this.vertices.containsKey(vertex.id())) {
            this.vertices.remove(vertex.id());
            List<DirectedVertex> inVertices = Sugar.listFromCollections(vertex.inVertices());
            List<DirectedVertex> outVertices = Sugar.listFromCollections(vertex.outVertices());
            vertex.disconnectFromInVertices();
            vertex.disconnectFromOutVertices();
            this.inDegreeOneVertices.remove(vertex.id());
            this.outDegreeOneVertices.remove(vertex.id());
            this.inDegreeZeroVertices.remove(vertex.id());
            this.outDegreeZeroVertices.remove(vertex.id());
            for (DirectedVertex adj : inVertices) {
                this.addToDegreeVertices(adj);
                this.removeFromDegreeVertices(adj);
            }
            for (DirectedVertex adj : outVertices) {
                this.addToDegreeVertices(adj);
                this.removeFromDegreeVertices(adj);
            }
        }
    }

    public void restore(DirectedVertex vertex) {
        if (!this.vertices.containsKey(vertex.id())) {
            this.vertices.put(vertex.id(), vertex);
            vertex.restoreLinksToInVertices();
            vertex.restoreLinksToOutVertices();
            this.addToDegreeVertices(vertex);
            for (DirectedVertex adj : vertex.inVertices()) {
                this.addToDegreeVertices(adj);
                this.removeFromDegreeVertices(adj);
            }
            for (DirectedVertex adj : vertex.outVertices()) {
                this.addToDegreeVertices(adj);
                this.removeFromDegreeVertices(adj);
            }
        }
    }

    private void addToDegreeVertices(DirectedVertex v) {
        if (v.outDegree() == 1) {
            this.outDegreeOneVertices.put(v.id(), v);
        }
        if (v.inDegree() == 1) {
            this.inDegreeOneVertices.put(v.id(), v);
        }
        if (v.outDegree() == 0) {
            this.outDegreeZeroVertices.put(v.id(), v);
        }
        if (v.inDegree() == 0) {
            this.inDegreeZeroVertices.put(v.id(), v);
        }
    }

    private void removeFromDegreeVertices(DirectedVertex v) {
        if (v.outDegree() != 1 && this.outDegreeOneVertices.containsKey(v.id())) {
            this.outDegreeOneVertices.remove(v.id());
        }
        if (v.inDegree() != 1 && this.inDegreeOneVertices.containsKey(v.id())) {
            this.inDegreeOneVertices.remove(v.id());
        }
        if (v.outDegree() != 0 && this.outDegreeZeroVertices.containsKey(v.id())) {
            this.outDegreeZeroVertices.remove(v.id());
        }
        if (v.inDegree() != 0 && this.inDegreeZeroVertices.containsKey(v.id())) {
            this.inDegreeZeroVertices.remove(v.id());
        }
    }

    public String toString() {
        return this.vertices.toString();
    }

    public Collection<DirectedVertex> inDegreeZeroVertices() {
        return this.inDegreeZeroVertices.values();
    }

    public Collection<DirectedVertex> outDegreeZeroVertices() {
        return this.outDegreeZeroVertices.values();
    }

    public Collection<DirectedVertex> inDegreeOneVertices() {
        return this.inDegreeOneVertices.values();
    }
}

