/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.features.treeliker.utils.graphs;

import cz.cvut.fel.ida.logic.features.treeliker.utils.graphs.DirectedGraph;
import cz.cvut.fel.ida.logic.features.treeliker.utils.graphs.DirectedVertex;
import cz.cvut.fel.ida.utils.math.Sugar;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class GraphAlgorithms {
    public static Map<DirectedVertex, Integer> shortestPathsInAcyclicGraphToVertex(DirectedGraph dg, DirectedVertex target) {
        int i;
        HashMap<DirectedVertex, Integer> distances = new HashMap<DirectedVertex, Integer>();
        List<DirectedVertex> topological = GraphAlgorithms.topologicalOrder(dg);
        Collections.reverse(topological);
        distances.put(target, 0);
        for (i = 0; i < topological.size() && !topological.get(i).equals(target); ++i) {
        }
        while (i < topological.size()) {
            DirectedVertex v = topological.get(i);
            for (DirectedVertex in : v.inVertices()) {
                if (distances.containsKey(v)) {
                    int distance = (Integer)distances.get(v) + v.inDistance(in);
                    if (distances.containsKey(in) && (Integer)distances.get(in) <= distance) continue;
                    distances.put(in, distance);
                    continue;
                }
                distances.put(in, Integer.MAX_VALUE);
            }
            ++i;
        }
        return distances;
    }

    public static List<DirectedVertex> topologicalOrder(DirectedGraph graph) {
        HashMap<Integer, DirectedVertex> vertices = new HashMap<Integer, DirectedVertex>();
        for (DirectedVertex directedVertex : graph.vertices()) {
            vertices.put(directedVertex.id(), directedVertex);
        }
        graph = graph.clone();
        ArrayList<DirectedVertex> list = new ArrayList<DirectedVertex>();
        while (graph.vertexCount() > 0) {
            if (graph.inDegreeZeroVertices().size() > 0) {
                for (DirectedVertex dv : Sugar.listFromCollections(graph.inDegreeZeroVertices())) {
                    list.add(dv);
                    graph.hide(dv);
                }
                continue;
            }
            return null;
        }
        ArrayList<DirectedVertex> arrayList = new ArrayList<DirectedVertex>();
        for (DirectedVertex v : list) {
            arrayList.add((DirectedVertex)vertices.get(v.id()));
        }
        return arrayList;
    }

    public static List<Set<DirectedVertex>> connectedComponents(DirectedGraph dg) {
        dg = dg.clone();
        ArrayList<Set<DirectedVertex>> components = new ArrayList<Set<DirectedVertex>>();
        while (dg.vertexCount() > 0) {
            DirectedVertex start = Sugar.chooseOne(dg.vertices());
            Stack<DirectedVertex> open = new Stack<DirectedVertex>();
            HashSet<DirectedVertex> closed = new HashSet<DirectedVertex>();
            open.push(start);
            closed.add(start);
            while (!open.empty()) {
                DirectedVertex expanded = (DirectedVertex)open.pop();
                for (DirectedVertex v : expanded.outVertices()) {
                    if (closed.contains(v)) continue;
                    open.push(v);
                    closed.add(v);
                }
                for (DirectedVertex v : expanded.inVertices()) {
                    if (closed.contains(v)) continue;
                    open.push(v);
                    closed.add(v);
                }
                dg.hide(expanded);
            }
            components.add(closed);
        }
        return components;
    }
}

