/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.grounding;

import cz.cvut.fel.ida.algebra.functions.Aggregation;
import cz.cvut.fel.ida.algebra.values.Value;
import cz.cvut.fel.ida.logic.HornClause;
import cz.cvut.fel.ida.logic.Literal;
import cz.cvut.fel.ida.logic.constructs.Atom;
import cz.cvut.fel.ida.logic.constructs.building.factories.WeightFactory;
import cz.cvut.fel.ida.logic.constructs.example.GroundExample;
import cz.cvut.fel.ida.logic.constructs.example.LiftedExample;
import cz.cvut.fel.ida.logic.constructs.example.QueryAtom;
import cz.cvut.fel.ida.logic.constructs.example.ValuedFact;
import cz.cvut.fel.ida.logic.constructs.template.Template;
import cz.cvut.fel.ida.logic.constructs.template.components.WeightedRule;
import cz.cvut.fel.ida.logic.grounding.GroundTemplate;
import cz.cvut.fel.ida.logic.grounding.GroundingSample;
import cz.cvut.fel.ida.logic.grounding.bottomUp.BottomUp;
import cz.cvut.fel.ida.logic.grounding.topDown.Gringo;
import cz.cvut.fel.ida.logic.grounding.topDown.TopDown;
import cz.cvut.fel.ida.setup.Settings;
import cz.cvut.fel.ida.utils.exporting.Exportable;
import cz.cvut.fel.ida.utils.generic.Pair;
import cz.cvut.fel.ida.utils.generic.Timing;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public abstract class Grounder
implements Exportable {
    private static final Logger LOG = Logger.getLogger(Grounder.class.getName());
    public transient Settings settings;
    public WeightFactory weightFactory;
    public Timing timing;

    public Grounder(Settings settings) {
        this(settings, new WeightFactory(settings.inferred.maxWeightCount));
    }

    public Grounder(Settings settings, WeightFactory weightFactory) {
        this.settings = settings;
        this.weightFactory = weightFactory;
        this.timing = new Timing();
    }

    public static Grounder getGrounder(Settings settings) {
        switch (settings.grounding) {
            case BUP: {
                return new BottomUp(settings);
            }
            case TDOWN: {
                return new TopDown(settings);
            }
            case GRINGO: {
                return new Gringo(settings);
            }
        }
        return new BottomUp(settings);
    }

    public abstract GroundTemplate groundRulesAndFacts(LiftedExample var1, Template var2);

    public abstract GroundTemplate groundRulesAndFacts(LiftedExample var1, Template var2, GroundTemplate var3);

    public Pair<Map<HornClause, List<WeightedRule>>, Map<Literal, ValuedFact>> rulesAndFacts(LiftedExample example, Template template) {
        Map<HornClause, List<WeightedRule>> ruleMap;
        LinkedHashSet flatFacts;
        if (!template.facts.isEmpty() || !example.conjunctions.isEmpty()) {
            flatFacts = new LinkedHashSet(example.flatFacts);
            flatFacts.addAll(example.conjunctions.stream().flatMap(conj -> conj.facts.stream()).collect(Collectors.toList()));
            flatFacts.addAll(template.facts);
        } else {
            flatFacts = example.flatFacts;
        }
        Map<Literal, ValuedFact> atomMap = this.mapToLogic(flatFacts);
        if (example.rules.isEmpty()) {
            if (template.hornClauses == null) {
                template.hornClauses = this.rulesToHornClauses(template.rules);
            }
            ruleMap = template.hornClauses;
        } else {
            LinkedHashSet<WeightedRule> rules = new LinkedHashSet<WeightedRule>(template.rules);
            rules.addAll(example.rules);
            ruleMap = this.rulesToHornClauses(rules);
        }
        return new Pair<Map<HornClause, List<WeightedRule>>, Map<Literal, ValuedFact>>(ruleMap, atomMap);
    }

    private LinkedHashMap<HornClause, List<WeightedRule>> rulesToHornClauses(Set<WeightedRule> rules) {
        return rules.stream().collect(Collectors.toMap(WeightedRule::toHornClause, k -> new ArrayList<WeightedRule>(Collections.singletonList(k)), this::merge2rules, LinkedHashMap::new));
    }

    public Pair<Map<HornClause, List<WeightedRule>>, Map<Literal, ValuedFact>> mapToLogic(Pair<Set<WeightedRule>, Set<ValuedFact>> raf) {
        LinkedHashMap<HornClause, List<WeightedRule>> ruleMap = this.rulesToHornClauses((Set)raf.r);
        Map<Literal, ValuedFact> factMap = this.mapToLogic((Set)raf.s);
        return new Pair<Map<HornClause, List<WeightedRule>>, Map<Literal, ValuedFact>>(ruleMap, factMap);
    }

    public Map<Literal, ValuedFact> mapToLogic(Set<ValuedFact> facts) {
        return facts.stream().collect(Collectors.toMap(Atom::getLiteral, vf -> vf, this::merge2facts));
    }

    public Set<Literal> getAllFacts(GroundExample example) {
        Set collect = example.conjunctions.stream().flatMap(conj -> conj.facts.stream()).collect(Collectors.toSet());
        collect.addAll(example.flatFacts);
        return collect.stream().map(l -> l.literal).collect(Collectors.toSet());
    }

    private List<WeightedRule> merge2rules(List<WeightedRule> a, List<WeightedRule> b) {
        LOG.severe("Two rules with the same logical signature detected! This is most likely by mistake and can cause troubles. Check the template for duplicites around:");
        LOG.severe(a.get(0).getOriginalString());
        LOG.severe(b.get(0).getOriginalString());
        a.addAll(b);
        return a;
    }

    private ValuedFact merge2facts(ValuedFact a, ValuedFact b) {
        Aggregation factAggregation = Aggregation.getFunction(this.settings.factMergeActivation);
        Value evaluation = factAggregation.evaluate(Arrays.asList(a.getValue(), b.getValue()));
        return new ValuedFact(a.getOffsettedPredicate(), a.getLiteral().termList(), a.getLiteral().isNegated(), this.weightFactory.construct("foo", evaluation, true, true));
    }

    public List<GroundingSample> globalGroundingSample(List<GroundingSample> sampleList) {
        int i;
        LOG.info("Global grounding for " + sampleList.size() + " samples.");
        Template template = new Template(sampleList.get((int)0).template);
        LiftedExample liftedExample = new LiftedExample();
        for (i = 1; i < sampleList.size(); ++i) {
            if (sampleList.get((int)i).template == sampleList.get((int)(i - 1)).template) continue;
            template.addAllFrom(sampleList.get((int)i).template);
        }
        liftedExample.addAllFrom((LiftedExample)((QueryAtom)sampleList.get((int)0).query).evidence);
        for (i = 1; i < sampleList.size(); ++i) {
            if (((QueryAtom)sampleList.get((int)i).query).evidence == ((QueryAtom)sampleList.get((int)(i - 1)).query).evidence) continue;
            liftedExample.addAllFrom((LiftedExample)((QueryAtom)sampleList.get((int)i).query).evidence);
        }
        GroundTemplate groundTemplate = this.groundRulesAndFacts(liftedExample, template);
        for (GroundingSample sample : sampleList) {
            sample.groundingWrap.setGroundTemplate(groundTemplate);
            sample.groundingWrap.example = liftedExample;
        }
        return sampleList;
    }
}

